/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeCompat;
import com.minecolonies.api.compatibility.resourcefulbees.ResourcefulBeesCompat;
import com.minecolonies.api.compatibility.tinkers.SlimeTreeCheck;
import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockStateStorage;
import com.minecolonies.api.util.Disease;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.OreBlock;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CompatibilityManager
implements ICompatibilityManager {
    private final Map<BlockStateStorage, ItemStorage> leavesToSaplingMap = new HashMap<BlockStateStorage, ItemStorage>();
    private final List<ItemStorage> saplings = new ArrayList<ItemStorage>();
    private final List<Property<?>> leafCompareWithoutProperties = ImmutableList.of((Object)checkDecay, (Object)decayable, (Object)DYN_PROP_HYDRO, (Object)TREE_DISTANCE);
    private static final BooleanProperty checkDecay = BooleanProperty.func_177716_a((String)"check_decay");
    private static final BooleanProperty decayable = BooleanProperty.func_177716_a((String)"decayable");
    public static final IntegerProperty DYN_PROP_HYDRO = IntegerProperty.func_177719_a((String)"hydro", (int)1, (int)4);
    public static final IntegerProperty TREE_DISTANCE = IntegerProperty.func_177719_a((String)"distance", (int)1, (int)7);
    private final Set<Block> oreBlocks = new HashSet<Block>();
    private final Set<ItemStorage> smeltableOres = new HashSet<ItemStorage>();
    private final Map<Item, CompostRecipe> compostRecipes = new HashMap<Item, CompostRecipe>();
    private final Set<ItemStorage> plantables = new HashSet<ItemStorage>();
    private final Set<ItemStorage> fuel = new HashSet<ItemStorage>();
    private final Set<ItemStorage> food = new HashSet<ItemStorage>();
    private final Set<ItemStorage> edibles = new HashSet<ItemStorage>();
    private final Map<String, Disease> diseases = new HashMap<String, Disease>();
    private final List<String> diseaseList = new ArrayList<String>();
    private final List<ItemStorage> luckyOres = new ArrayList<ItemStorage>();
    private final List<Tuple<Item, Integer>> recruitmentCostsWeights = new ArrayList<Tuple<Item, Integer>>();
    private static final Random random = new Random();
    private static ImmutableList<ItemStack> allItems = ImmutableList.of();
    private static ImmutableSet<ItemStorage> allItemsSet = ImmutableSet.of();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private ImmutableSet<ResourceLocation> monsters = ImmutableSet.of();

    @Override
    public void discover(@NotNull RecipeManager recipeManager) {
        this.saplings.clear();
        this.oreBlocks.clear();
        this.smeltableOres.clear();
        this.plantables.clear();
        this.food.clear();
        this.edibles.clear();
        this.fuel.clear();
        this.compostRecipes.clear();
        this.luckyOres.clear();
        this.recruitmentCostsWeights.clear();
        this.diseases.clear();
        this.diseaseList.clear();
        this.freeBlocks.clear();
        this.freePositions.clear();
        this.monsters = ImmutableSet.of();
        this.discoverAllItems();
        this.discoverSaplings();
        this.discoverOres();
        this.discoverPlantables();
        this.discoverFood();
        this.discoverFuel();
        this.discoverMobs();
        this.discoverCompostRecipes(recipeManager);
        this.discoverLuckyOres();
        this.discoverRecruitCosts();
        this.discoverDiseases();
        this.discoverFreeBlocksAndPos();
        this.discoverModCompat();
    }

    @Override
    public List<ItemStack> getListOfAllItems() {
        return allItems;
    }

    @Override
    public Set<ItemStorage> getSetOfAllItems() {
        return allItemsSet;
    }

    @Override
    public boolean isPlantable(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof BlockItem && ModTags.floristFlowers.func_230235_a_((Object)itemStack.func_77973_b());
    }

    @Override
    public boolean isLuckyBlock(Block block) {
        return ModTags.oreChanceBlocks.func_230235_a_((Object)block);
    }

    @Override
    public ItemStack getSaplingForLeaf(BlockState block) {
        BlockStateStorage tempLeaf = new BlockStateStorage(block, this.leafCompareWithoutProperties, true);
        if (this.leavesToSaplingMap.containsKey(tempLeaf)) {
            return this.leavesToSaplingMap.get(tempLeaf).getItemStack();
        }
        return null;
    }

    @Override
    public Set<ItemStorage> getCopyOfSaplings() {
        return new HashSet<ItemStorage>(this.saplings);
    }

    @Override
    public Set<ItemStorage> getFuel() {
        return this.fuel;
    }

    @Override
    public Set<ItemStorage> getFood() {
        return this.food;
    }

    @Override
    public Set<ItemStorage> getEdibles(int minNutrition) {
        HashSet<ItemStorage> filteredEdibles = new HashSet<ItemStorage>();
        for (ItemStorage storage : this.edibles) {
            if (storage.getItem().func_219967_s() == null || storage.getItem().func_219967_s().func_221466_a() < minNutrition) continue;
            filteredEdibles.add(storage);
        }
        return filteredEdibles;
    }

    @Override
    public Set<ItemStorage> getSmeltableOres() {
        return this.smeltableOres;
    }

    @Override
    public Map<Item, CompostRecipe> getCopyOfCompostRecipes() {
        return ImmutableMap.copyOf(this.compostRecipes);
    }

    @Override
    public Set<ItemStorage> getCompostInputs() {
        return this.compostRecipes.keySet().stream().map(item -> new ItemStorage(new ItemStack((IItemProvider)item))).collect(Collectors.toSet());
    }

    @Override
    public Set<ItemStorage> getCopyOfPlantables() {
        return new HashSet<ItemStorage>(this.plantables);
    }

    @Override
    public String getRandomDisease() {
        return this.diseaseList.get(random.nextInt(this.diseaseList.size()));
    }

    @Override
    public Disease getDisease(String disease) {
        return this.diseases.get(disease);
    }

    @Override
    public List<Disease> getDiseases() {
        return new ArrayList<Disease>(this.diseases.values());
    }

    @Override
    public List<Tuple<Item, Integer>> getRecruitmentCostsWeights() {
        return Collections.unmodifiableList(this.recruitmentCostsWeights);
    }

    @Override
    public boolean isOre(BlockState block) {
        if (block.func_177230_c() instanceof OreBlock || block.func_177230_c() instanceof RedstoneOreBlock) {
            return true;
        }
        return this.oreBlocks.contains(block.func_177230_c());
    }

    @Override
    public boolean isOre(@NotNull ItemStack stack) {
        if (this.isMineableOre(stack)) {
            return !MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack).func_190926_b();
        }
        return false;
    }

    @Override
    public boolean isMineableOre(@NotNull ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && stack.func_77973_b().func_206844_a((ITag)Tags.Items.ORES);
    }

    @Override
    public void write(@NotNull CompoundNBT compound) {
        @NotNull ListNBT saplingsLeavesTagList = this.leavesToSaplingMap.entrySet().stream().filter(entry -> entry.getKey() != null).map(entry -> CompatibilityManager.writeLeafSaplingEntryToNBT(((BlockStateStorage)entry.getKey()).getState(), (ItemStorage)entry.getValue())).collect(NBTUtils.toListNBT());
        compound.func_218657_a("tagSapLeaves", (INBT)saplingsLeavesTagList);
    }

    @Override
    public void read(@NotNull CompoundNBT compound) {
        NBTUtils.streamCompound(compound.func_150295_c("tagSapLeaves", 10)).map(CompatibilityManager::readLeafSaplingEntryFromNBT).filter(key -> !this.leavesToSaplingMap.containsKey(new BlockStateStorage((BlockState)key.getA(), this.leafCompareWithoutProperties, true)) && !this.leavesToSaplingMap.containsValue(key.getB())).forEach(key -> this.leavesToSaplingMap.put(new BlockStateStorage((BlockState)key.getA(), this.leafCompareWithoutProperties, true), (ItemStorage)key.getB()));
    }

    @Override
    public void connectLeafToSapling(BlockState leaf, ItemStack stack) {
        BlockStateStorage store = new BlockStateStorage(leaf, this.leafCompareWithoutProperties, true);
        if (!this.leavesToSaplingMap.containsKey(store)) {
            this.leavesToSaplingMap.put(store, new ItemStorage(stack, false, true));
        }
    }

    @Override
    public ItemStack getRandomLuckyOre(double chanceBonus) {
        if (random.nextDouble() * 100.0 <= (double)((Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().luckyBlockChance.get()).intValue() * chanceBonus) {
            return this.luckyOres.get(random.nextInt(this.luckyOres.size())).getItemStack().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean isFreeBlock(Block block) {
        return this.freeBlocks.contains(block);
    }

    @Override
    public boolean isFreePos(BlockPos block) {
        return this.freePositions.contains(block);
    }

    @Override
    public ImmutableSet<ResourceLocation> getAllMonsters() {
        return this.monsters;
    }

    private void discoverMobs() {
        HashSet<ResourceLocation> monsterSet = new HashSet<ResourceLocation>();
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            if (((EntityType)entry.getValue()).func_220339_d() == EntityClassification.MONSTER) {
                monsterSet.add(((RegistryKey)entry.getKey()).func_240901_a_());
                continue;
            }
            if (!ModTags.hostile.func_230235_a_(entry.getValue())) continue;
            monsterSet.add(((RegistryKey)entry.getKey()).func_240901_a_());
        }
        this.monsters = ImmutableSet.copyOf(monsterSet);
    }

    private void discoverAllItems() {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(ItemGroup.field_78027_g, list);
            listBuilder.addAll((Iterable)list);
            for (ItemStack stack : list) {
                setBuilder.add((Object)new ItemStorage(stack, true));
            }
        }
        allItems = listBuilder.build();
        allItemsSet = setBuilder.build();
    }

    private void discoverOres() {
        if (this.smeltableOres.isEmpty()) {
            for (Item item : Tags.Items.ORES.func_230236_b_()) {
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(ItemGroup.field_78027_g, list);
                for (ItemStack stack : list) {
                    if (stack.func_77973_b() instanceof BlockItem) {
                        this.oreBlocks.add(((BlockItem)stack.func_77973_b()).func_179223_d());
                    }
                    if (MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack).func_190926_b()) continue;
                    this.smeltableOres.add(new ItemStorage(stack));
                }
            }
        }
        Log.getLogger().info("Finished discovering Ores " + this.oreBlocks.size() + " " + this.smeltableOres.size());
    }

    private void discoverSaplings() {
        for (Item item : ItemTags.field_200037_g.func_230236_b_()) {
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(ItemGroup.field_78027_g, list);
            for (ItemStack stack : list) {
                this.saplings.add(new ItemStorage(stack, false, true));
            }
        }
        Log.getLogger().info("Finished discovering saplings " + this.saplings.size());
    }

    private void discoverCompostRecipes(@NotNull RecipeManager recipeManager) {
        if (this.compostRecipes.isEmpty()) {
            for (IRecipe r : recipeManager.func_215366_a(CompostRecipe.TYPE).values()) {
                CompostRecipe recipe = (CompostRecipe)r;
                for (ItemStack stack : recipe.getInput().func_193365_a()) {
                    this.compostRecipes.merge(stack.func_77973_b(), recipe, (r1, r2) -> r1.getStrength() < r2.getStrength() ? r1 : r2);
                }
            }
            Log.getLogger().info("Finished discovering compostables " + this.compostRecipes.size());
        }
    }

    private void discoverPlantables() {
        if (this.plantables.isEmpty()) {
            for (Item item : ModTags.floristFlowers.func_230236_b_()) {
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(ItemGroup.field_78027_g, list);
                for (ItemStack stack : list) {
                    if (!(stack.func_77973_b() instanceof BlockItem)) continue;
                    this.plantables.add(new ItemStorage(stack));
                }
            }
        }
        Log.getLogger().info("Finished discovering plantables " + this.plantables.size());
    }

    private void discoverFuel() {
        if (this.fuel.isEmpty()) {
            for (ItemStack item : allItems) {
                if (!FurnaceTileEntity.func_213991_b((ItemStack)item)) continue;
                this.fuel.add(new ItemStorage(item));
            }
        }
        Log.getLogger().info("Finished discovering fuel " + this.fuel.size());
    }

    private void discoverFood() {
        if (this.food.isEmpty()) {
            for (ItemStack item : allItems) {
                if (!ItemStackUtils.ISFOOD.test(item) && !ItemStackUtils.ISCOOKABLE.test(item)) continue;
                this.food.add(new ItemStorage(item));
                if (!ItemStackUtils.CAN_EAT.test(item)) continue;
                this.edibles.add(new ItemStorage(item));
            }
        }
        Log.getLogger().info("Finished discovering food " + this.edibles.size() + " " + this.food.size());
    }

    private void discoverLuckyOres() {
        if (this.luckyOres.isEmpty()) {
            for (String ore : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().luckyOres.get()) {
                String[] split = ore.split("!");
                if (split.length < 2) {
                    Log.getLogger().warn("Wrong configured ore: " + ore);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
                if (item == null || item == Items.field_190931_a) {
                    Log.getLogger().warn("Invalid lucky block: " + ore);
                    continue;
                }
                ItemStack stack = new ItemStack((IItemProvider)item, 1);
                try {
                    int rarity = Integer.parseInt(split[split.length - 1]);
                    for (int i = 0; i < rarity; ++i) {
                        this.luckyOres.add(new ItemStorage(stack));
                    }
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Ore has invalid rarity: " + ore);
                }
            }
        }
        Log.getLogger().info("Finished discovering lucky oreBlocks " + this.luckyOres.size());
    }

    private void discoverRecruitCosts() {
        if (this.recruitmentCostsWeights.isEmpty()) {
            for (String itemString : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().configListRecruitmentItems.get()) {
                String[] split = itemString.split(";");
                if (split.length < 2) {
                    Log.getLogger().warn("Wrong configured recruitment cost: " + itemString);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
                if (item == null || item == Items.field_190931_a) {
                    Log.getLogger().warn("Invalid recruitment item: " + item);
                    continue;
                }
                try {
                    int rarity = Integer.parseInt(split[split.length - 1]);
                    this.recruitmentCostsWeights.add(new Tuple<Item, Integer>(item, rarity));
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Invalid recruitment weight for: " + item);
                }
            }
        }
        Log.getLogger().info("Finished discovering recruitment costs");
    }

    private void discoverDiseases() {
        if (this.diseases.isEmpty()) {
            for (String disease : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().diseases.get()) {
                String[] split = disease.split(",");
                if (split.length < 3) {
                    Log.getLogger().warn("Wrongly configured disease: " + disease);
                    continue;
                }
                try {
                    int i;
                    String name = split[0];
                    int rarity = Integer.parseInt(split[1]);
                    ArrayList<ItemStack> cure = new ArrayList<ItemStack>();
                    for (i = 2; i < split.length; ++i) {
                        String[] theItem = split[i].split(":");
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(theItem[0], theItem[1]));
                        if (item == null || item == Items.field_190931_a) {
                            Log.getLogger().warn("Invalid cure item: " + disease);
                            continue;
                        }
                        ItemStack stack = new ItemStack((IItemProvider)item, 1);
                        cure.add(stack);
                    }
                    this.diseases.put(name, new Disease(name, rarity, cure));
                    for (i = 0; i < rarity; ++i) {
                        this.diseaseList.add(name);
                    }
                }
                catch (NumberFormatException e) {
                    Log.getLogger().warn("Wrongly configured disease: " + disease);
                }
            }
        }
        Log.getLogger().info("Finished discovering diseases");
    }

    private static CompoundNBT writeLeafSaplingEntryToNBT(BlockState state, ItemStorage storage) {
        CompoundNBT compound = NBTUtil.func_190009_a((BlockState)state);
        storage.getItemStack().func_77955_b(compound);
        return compound;
    }

    private static Tuple<BlockState, ItemStorage> readLeafSaplingEntryFromNBT(CompoundNBT compound) {
        return new Tuple<BlockState, ItemStorage>(NBTUtil.func_190008_d((CompoundNBT)compound), new ItemStorage(ItemStack.func_199557_a((CompoundNBT)compound), false, true));
    }

    private void discoverFreeBlocksAndPos() {
        for (String s : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().freeToInteractBlocks.get()) {
            try {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null || block instanceof AirBlock) continue;
                this.freeBlocks.add(block);
            }
            catch (Exception ex) {
                BlockPos pos = BlockPosUtil.getBlockPosOfString(s);
                if (pos == null) continue;
                this.freePositions.add(pos);
            }
        }
    }

    private void discoverModCompat() {
        if (ModList.get().isLoaded("resourcefulbees")) {
            Compatibility.beeHiveCompat = new ResourcefulBeesCompat();
        }
        if (ModList.get().isLoaded("tconstruct")) {
            Compatibility.tinkersCompat = new TinkersToolHelper();
            Compatibility.tinkersSlimeCompat = new SlimeTreeCheck();
        }
        if (ModList.get().isLoaded("dynamictrees")) {
            Compatibility.dynamicTreesCompat = new DynamicTreeCompat();
        }
    }

    public static Set<ItemStorage> getAllBeekeeperFlowers() {
        HashSet<ItemStorage> flowers = new HashSet<ItemStorage>();
        for (Item item : ItemTags.field_226159_I_.func_230236_b_()) {
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(ItemGroup.field_78027_g, list);
            for (ItemStack stack : list) {
                flowers.add(new ItemStorage(stack));
            }
        }
        return flowers;
    }
}

