/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class PublicCrafting
extends AbstractCrafting {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(PublicCrafting.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());

    public PublicCrafting(@NotNull ItemStack stack, int count, IToken<?> recipeToken) {
        super(stack, count, count, recipeToken);
    }

    public static CompoundNBT serialize(IFactoryController controller, PublicCrafting input) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Stack", (INBT)input.getStack().serializeNBT());
        compound.func_74768_a("Count", input.getCount());
        CompoundNBT tokenCompound = StandardFactoryController.getInstance().serialize(input.getRecipeID());
        compound.func_218657_a("Token", (INBT)tokenCompound);
        return compound;
    }

    public static PublicCrafting deserialize(IFactoryController controller, CompoundNBT compound) {
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.func_74775_l("Stack"));
        int count = compound.func_74762_e("Count");
        IToken token = null;
        if (compound.func_74764_b("Token")) {
            token = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("Token"));
        }
        return new PublicCrafting(stack, count, token);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, PublicCrafting input) {
        buffer.func_150788_a(input.getStack());
        buffer.writeInt(input.getCount());
        StandardFactoryController.getInstance().serialize(buffer, input.getRecipeID());
    }

    public static PublicCrafting deserialize(IFactoryController controller, PacketBuffer buffer) {
        ItemStack stack = buffer.func_150791_c();
        int count = buffer.readInt();
        IToken token = (IToken)StandardFactoryController.getInstance().deserialize(buffer);
        return new PublicCrafting(stack, count, token);
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

