/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.factory.standard;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.ITypeOverrideHandler;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class TypeTokenFactory
implements IFactory<Class<?>, TypeToken<?>> {
    @Override
    @NotNull
    public TypeToken<? extends TypeToken<?>> getFactoryOutputType() {
        return TypeConstants.TYPETOKEN;
    }

    @Override
    @NotNull
    public TypeToken<? extends Class<?>> getFactoryInputType() {
        return TypeConstants.CLASS;
    }

    @Override
    @NotNull
    public TypeToken<?> getNewInstance(@NotNull IFactoryController factoryController, @NotNull Class<?> aClass, Object ... context) throws IllegalArgumentException {
        return TypeToken.of(aClass);
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull TypeToken<?> typeToken) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("Value", typeToken.getRawType().getName());
        return compound;
    }

    @Override
    @NotNull
    public TypeToken<?> deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) throws Throwable {
        try {
            return TypeToken.of(Class.forName(nbt.func_74779_i("Value")));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to create TypeToken", e);
        }
    }

    @Override
    public void serialize(IFactoryController controller, TypeToken<?> input, PacketBuffer packetBuffer) {
        packetBuffer.func_180714_a(input.getRawType().getName());
    }

    @Override
    public TypeToken<?> deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        try {
            return TypeToken.of(Class.forName(buffer.func_150789_c(Short.MAX_VALUE)));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to create TypeToken", e);
        }
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.TYPE_TOKEN_ID;
    }

    public static class TypeTokenSubTypeOverrideHandler
    implements ITypeOverrideHandler<TypeToken<?>> {
        @Override
        public boolean matches(TypeToken<?> inputType) {
            return ReflectionUtils.getSuperClasses(inputType).contains(TypeConstants.TYPETOKEN);
        }

        @Override
        public TypeToken<TypeToken<?>> getOutputType() {
            return TypeConstants.TYPETOKEN;
        }
    }
}

