/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.jobs.registry;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.IJobView;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public final class JobEntry
extends ForgeRegistryEntry<JobEntry> {
    private final Function<ICitizenData, IJob<?>> jobProducer;
    private final Supplier<BiFunction<IColonyView, ICitizenDataView, IJobView>> jobViewProducer;
    private final ResourceLocation key;

    private Function<ICitizenData, IJob<?>> getHandlerProducer() {
        return this.jobProducer;
    }

    public IJob<?> produceJob(ICitizenData data) {
        IJob<?> job = this.jobProducer.apply(data);
        job.setRegistryEntry(this);
        return job;
    }

    private JobEntry(Function<ICitizenData, IJob<?>> jobProducer, Supplier<BiFunction<IColonyView, ICitizenDataView, IJobView>> jobViewProducer, ResourceLocation key) {
        this.jobProducer = jobProducer;
        this.jobViewProducer = jobViewProducer;
        this.key = key;
    }

    public String getTranslationKey() {
        return "com." + this.key.func_110624_b() + ".job." + this.key.func_110623_a();
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JobEntry jobEntry = (JobEntry)((Object)o);
        return Objects.equals(this.key, jobEntry.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public Supplier<BiFunction<IColonyView, ICitizenDataView, IJobView>> getJobViewProducer() {
        return this.jobViewProducer;
    }

    public static final class Builder {
        private Function<ICitizenData, IJob<?>> jobProducer;
        private ResourceLocation registryName;
        private Supplier<BiFunction<IColonyView, ICitizenDataView, IJobView>> jobViewProducer;

        public Builder setJobProducer(Function<ICitizenData, IJob<?>> jobProducer) {
            this.jobProducer = jobProducer;
            return this;
        }

        public Builder setJobViewProducer(Supplier<BiFunction<IColonyView, ICitizenDataView, IJobView>> jobViewProducer) {
            this.jobViewProducer = jobViewProducer;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public JobEntry createJobEntry() {
            Validate.notNull(this.jobProducer);
            Validate.notNull((Object)this.registryName);
            Validate.notNull(this.jobViewProducer);
            return (JobEntry)new JobEntry(this.jobProducer, this.jobViewProducer, this.registryName).setRegistryName(this.registryName);
        }
    }
}

