/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.interactionhandling;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class InteractionValidatorRegistry {
    private static Map<ITextComponent, Predicate<ICitizenData>> map = new HashMap<ITextComponent, Predicate<ICitizenData>>();
    private static Map<ITextComponent, BiPredicate<ICitizenData, BlockPos>> posMap = new HashMap<ITextComponent, BiPredicate<ICitizenData, BlockPos>>();
    private static Map<ITextComponent, BiPredicate<ICitizenData, IToken<?>>> tokenMap = new HashMap();

    public static Predicate<ICitizenData> getStandardInteractionValidatorPredicate(ITextComponent key) {
        return map.get(key);
    }

    public static BiPredicate<ICitizenData, BlockPos> getPosBasedInteractionValidatorPredicate(ITextComponent key) {
        return posMap.get(key);
    }

    public static BiPredicate<ICitizenData, IToken<?>> getTokenBasedInteractionValidatorPredicate(ITextComponent key) {
        return tokenMap.get(key);
    }

    public static void registerStandardPredicate(ITextComponent key, Predicate<ICitizenData> predicate) {
        map.put(key, predicate);
    }

    public static void registerPosBasedPredicate(ITextComponent key, BiPredicate<ICitizenData, BlockPos> predicate) {
        posMap.put(key, predicate);
    }

    public static void registerTokenBasedPredicate(ITextComponent key, BiPredicate<ICitizenData, IToken<?>> predicate) {
        tokenMap.put(key, predicate);
    }

    public static boolean hasValidator(TranslationTextComponent component) {
        return map.containsKey(component) || posMap.containsKey(component) || tokenMap.containsKey(component);
    }

    private InteractionValidatorRegistry() {
    }
}

