/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.colonyEvents.registry;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.util.Log;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ColonyEventTypeRegistryEntry
extends ForgeRegistryEntry<ColonyEventTypeRegistryEntry> {
    private final BiFunction<IColony, CompoundNBT, IColonyEvent> eventCreator;

    public ColonyEventTypeRegistryEntry(@NotNull BiFunction<IColony, CompoundNBT, IColonyEvent> eventCreator, @NotNull ResourceLocation registryID) {
        if (registryID.func_110623_a().isEmpty()) {
            Log.getLogger().warn("Created empty registry empty for event, supply a name for it!");
        }
        this.eventCreator = eventCreator;
        this.setRegistryName(registryID);
    }

    public IColonyEvent deserializeEvent(@Nonnull IColony colony, @Nonnull CompoundNBT compound) {
        return this.eventCreator.apply(colony, compound);
    }
}

