/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.decorative;

import com.minecolonies.api.util.WorldUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlockGate
extends DoorBlock {
    public static final String IRON_GATE = "gate_iron";
    public static final String WOODEN_GATE = "gate_wood";
    private final int maxWidth;
    private final int maxHeight;
    private final float hardness;
    protected static final VoxelShape E_W_SHAPE = VoxelShapes.func_197873_a((double)0.3, (double)0.0, (double)0.0, (double)0.7, (double)1.0, (double)1.0);
    protected static final VoxelShape N_S_SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.3, (double)1.0, (double)1.0, (double)0.7);

    public AbstractBlockGate(String name, float hardness, int maxWidth, int maxHeight) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(hardness, hardness * 5.0f).func_226896_b_());
        this.setRegistryName(name);
        this.func_180632_j(this.func_176223_P());
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.hardness = hardness;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.field_149764_J == Material.field_151573_f) {
            return ActionResultType.PASS;
        }
        this.toggleGate(worldIn, pos, ((Direction)state.func_177229_b((Property)field_176520_a)).func_176746_e());
        worldIn.func_217378_a(player, (Boolean)state.func_177229_b((Property)field_176519_b) != false ? 1005 : 1011, pos, 0);
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        int count = this.removeGate(worldIn, pos, ((Direction)state.func_177229_b((Property)field_176520_a)).func_176746_e());
        for (int i = 0; i < count; ++i) {
            Block.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
        }
    }

    public int removeGate(World world, BlockPos startPos, Direction facing) {
        BlockPos current;
        BlockPos lowerLeftCorner = this.findLowerLeftCorner((IBlockReader)world, facing, startPos);
        int amount = 0;
        for (int hor = 0; hor < this.maxWidth && world.func_180495_p(current = lowerLeftCorner.func_177967_a(facing, hor)).func_177230_c() == this; ++hor) {
            BlockPos currentPos;
            for (int vert = 0; vert < this.maxHeight && world.func_180495_p(currentPos = current.func_177981_b(vert)).func_177230_c() == this; ++vert) {
                ++amount;
                world.func_180501_a(currentPos, Blocks.field_150350_a.func_176223_P(), 35);
            }
        }
        return amount;
    }

    @Deprecated
    public float getBlockHardness(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        BlockPos hPos;
        if (worldIn == null) {
            return 10.0f;
        }
        Direction facing = ((Direction)blockState.func_177229_b((Property)field_176520_a)).func_176746_e();
        BlockPos start = this.findLowerLeftCorner(worldIn, facing, pos);
        int count = 0;
        for (int hor = 0; hor < this.maxWidth && worldIn.func_180495_p(hPos = start.func_177967_a(facing, hor)).func_177230_c() == this; ++hor) {
            BlockPos worldPos;
            BlockState state;
            for (int vert = 0; vert < this.maxHeight && (state = worldIn.func_180495_p(worldPos = hPos.func_177982_a(0, vert, 0))).func_177230_c() == this; ++vert) {
                ++count;
            }
        }
        return (float)count * this.hardness;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos tPos = pos.func_177982_a(-1, -1, -1);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    if (worldIn.func_180495_p(tPos.func_177982_a(x, y, z)).func_177230_c() != this) continue;
                    return false;
                }
            }
        }
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP);
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos checkPos;
        BlockState checkState;
        int hor;
        Direction facing = ((Direction)state.func_177229_b((Property)field_176520_a)).func_176746_e();
        this.fillYStates(worldIn, pos, state, stack);
        int canPlace = this.maxWidth - 1;
        for (hor = 1; hor < this.maxWidth && (checkState = worldIn.func_180495_p(checkPos = pos.func_177967_a(facing.func_176734_d(), hor))).isAir((IBlockReader)worldIn, checkPos) && canPlace > 0 && worldIn.func_180495_p(checkPos.func_177972_a(facing.func_176734_d())).func_177230_c() != this; --canPlace, ++hor) {
            if (stack.func_190916_E() > 1) {
                stack.func_190920_e(stack.func_190916_E() - 1);
                worldIn.func_175656_a(checkPos, state);
            }
            this.fillYStates(worldIn, checkPos, state, stack);
        }
        if (canPlace <= 0) {
            return;
        }
        for (hor = 1; hor < this.maxWidth && (checkState = worldIn.func_180495_p(checkPos = pos.func_177967_a(facing, hor))).func_177230_c() != this && checkState.isAir((IBlockReader)worldIn, checkPos) && canPlace > 0 && worldIn.func_180495_p(checkPos.func_177972_a(facing)).func_177230_c() != this; --canPlace, ++hor) {
            if (stack.func_190916_E() > 1) {
                stack.func_190920_e(stack.func_190916_E() - 1);
                worldIn.func_175656_a(checkPos, state);
            }
            this.fillYStates(worldIn, checkPos, state, stack);
        }
    }

    private void fillYStates(World world, BlockPos base, BlockState state, ItemStack stack) {
        BlockPos checkPos;
        BlockState checkState;
        for (int vert = 1; vert < this.maxHeight && (checkState = world.func_180495_p(checkPos = base.func_177982_a(0, vert, 0))).isAir((IBlockReader)world, checkPos) && world.func_180495_p(checkPos.func_177984_a()).func_177230_c() != this; ++vert) {
            if (stack.func_190916_E() <= 1) continue;
            stack.func_190920_e(stack.func_190916_E() - 1);
            world.func_175656_a(checkPos, state);
        }
    }

    public AbstractBlockGate registerBlock(IForgeRegistry<Block> registry) {
        registry.register((IForgeRegistryEntry)this);
        return this;
    }

    @NotNull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeForState(state);
    }

    private VoxelShape getShapeForState(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)field_176520_a);
        switch (direction) {
            case EAST: 
            case WEST: {
                return E_W_SHAPE;
            }
        }
        return N_S_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)field_176519_b)).booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        return this.getShapeForState(state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.getShapeForState(state);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        if (((Boolean)state.func_177229_b((Property)field_176519_b)).booleanValue()) {
            return BlockRenderType.INVISIBLE;
        }
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176523_O, field_176520_a, field_176519_b, field_176521_M, field_176522_N, BlockStateProperties.field_208198_y});
    }

    private BlockPos findLowerLeftCorner(IBlockReader world, Direction facing, BlockPos blockPos) {
        BlockPos tePos = blockPos;
        for (int vert = 0; vert < this.maxHeight; ++vert) {
            BlockPos tempPos = tePos.func_177982_a(0, -vert, 0);
            if (world.func_180495_p(tempPos.func_177977_b()).func_177230_c() == this) continue;
            tePos = tempPos;
            break;
        }
        for (int hor = 0; hor < this.maxWidth; ++hor) {
            if (world.func_180495_p(tePos.func_177967_a(facing.func_176734_d(), hor + 1)).func_177230_c() == this) continue;
            tePos = tePos.func_177967_a(facing.func_176734_d(), hor);
            break;
        }
        return tePos;
    }

    public void func_242663_a(World worldIn, BlockState state, BlockPos pos, boolean open) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        if (blockstate.func_177230_c() == this && (Boolean)blockstate.func_177229_b((Property)field_176519_b) != open) {
            this.toggleGate(worldIn, pos, ((Direction)blockstate.func_177229_b((Property)field_176520_a)).func_176746_e());
        }
    }

    public void toggleGate(World world, BlockPos clickedBlock, Direction facing) {
        BlockPos hPos;
        BlockPos lowerLeftCorner = this.findLowerLeftCorner((IBlockReader)world, facing, clickedBlock);
        boolean opening = (Boolean)world.func_180495_p(lowerLeftCorner).func_177229_b((Property)BlockStateProperties.field_208193_t) == false;
        for (int hor = 0; hor < this.maxWidth && world.func_180495_p(hPos = lowerLeftCorner.func_177967_a(facing, hor)).func_177230_c() == this; ++hor) {
            BlockPos worldPos;
            BlockState state;
            for (int vert = 0; vert < this.maxHeight && (state = world.func_180495_p(worldPos = hPos.func_177982_a(0, vert, 0))).func_177230_c() == this; ++vert) {
                if (world.func_180495_p(worldPos.func_177984_a()).func_177230_c() != this) {
                    WorldUtil.setBlockState((IWorld)world, worldPos, (BlockState)state.func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)(opening ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT)), 2);
                    continue;
                }
                WorldUtil.setBlockState((IWorld)world, worldPos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208193_t, (Comparable)Boolean.valueOf(opening)), 2);
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, @NotNull BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered = worldIn.func_175640_z(pos);
        if (powered != (Boolean)state.func_177229_b((Property)field_176519_b)) {
            this.func_242663_a(worldIn, state, pos, powered);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)field_176520_a, (Comparable)context.func_195992_f());
        }
        return null;
    }
}

