/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.foundation.utility.outliner;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.mightyarchitect.foundation.utility.outliner.BlockClusterOutline;
import com.simibubi.mightyarchitect.foundation.utility.outliner.ChasingAABBOutline;
import com.simibubi.mightyarchitect.foundation.utility.outliner.LineOutline;
import com.simibubi.mightyarchitect.foundation.utility.outliner.Outline;
import com.simibubi.mightyarchitect.foundation.utility.outliner.OutlinedText;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class Outliner {
    Map<Object, OutlineEntry> outlines = new HashMap<Object, OutlineEntry>();

    public Outline.OutlineParams showLine(Object slot, Vector3d start, Vector3d end) {
        if (!this.outlines.containsKey(slot)) {
            LineOutline outline = new LineOutline();
            this.outlines.put(slot, new OutlineEntry(outline));
        }
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = 1;
        ((LineOutline)entry.outline).set(start, end);
        return entry.outline.getParams();
    }

    public Outline.OutlineParams chaseLine(Object slot, Vector3d start, Vector3d end) {
        if (!this.outlines.containsKey(slot)) {
            LineOutline.ChasingLineOutline outline = new LineOutline.ChasingLineOutline();
            outline.set(start, end);
            this.outlines.put(slot, new OutlineEntry(outline));
        }
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = 1;
        ((LineOutline.ChasingLineOutline)entry.outline).target(start, end);
        return entry.outline.getParams();
    }

    public Outline.OutlineParams chaseText(Object slot, Vector3d location, String text) {
        if (!this.outlines.containsKey(slot)) {
            OutlinedText outline = new OutlinedText();
            outline.set(location);
            this.outlines.put(slot, new OutlineEntry(outline));
        }
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = 1;
        OutlinedText outlinedText = (OutlinedText)entry.outline;
        outlinedText.target(location);
        outlinedText.setText(text);
        return entry.outline.getParams();
    }

    public Outline.OutlineParams endChasingLine(Object slot, Vector3d start, Vector3d end, float chasingProgress) {
        if (!this.outlines.containsKey(slot)) {
            LineOutline.EndChasingLineOutline outline = new LineOutline.EndChasingLineOutline();
            this.outlines.put(slot, new OutlineEntry(outline));
        }
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = 1;
        ((LineOutline.EndChasingLineOutline)entry.outline).setProgress(chasingProgress).set(start, end);
        return entry.outline.getParams();
    }

    public Outline.OutlineParams showAABB(Object slot, AxisAlignedBB bb) {
        this.createAABBOutlineIfMissing(slot, bb);
        ChasingAABBOutline outline = this.getAndRefreshAABB(slot);
        outline.prevBB = outline.targetBB = bb;
        return outline.getParams();
    }

    public Outline.OutlineParams chaseAABB(Object slot, AxisAlignedBB bb) {
        this.createAABBOutlineIfMissing(slot, bb);
        ChasingAABBOutline outline = this.getAndRefreshAABB(slot);
        outline.targetBB = bb;
        return outline.getParams();
    }

    public Outline.OutlineParams showCluster(Object slot, Iterable<BlockPos> selection) {
        BlockClusterOutline outline = new BlockClusterOutline(selection);
        OutlineEntry entry = new OutlineEntry(outline);
        this.outlines.put(slot, entry);
        return entry.getOutline().getParams();
    }

    public Outline.OutlineParams show(Object slot, Outline outline) {
        if (!this.outlines.containsKey(slot)) {
            this.outlines.put(slot, new OutlineEntry(outline));
        }
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = 1;
        return entry.outline.getParams();
    }

    public void keep(Object slot) {
        if (this.outlines.containsKey(slot)) {
            this.outlines.get(slot).ticksTillRemoval = 1;
        }
    }

    public void remove(Object slot) {
        this.outlines.remove(slot);
    }

    public Optional<Outline.OutlineParams> edit(Object slot) {
        this.keep(slot);
        if (this.outlines.containsKey(slot)) {
            return Optional.of(this.outlines.get(slot).getOutline().getParams());
        }
        return Optional.empty();
    }

    private void createAABBOutlineIfMissing(Object slot, AxisAlignedBB bb) {
        if (!this.outlines.containsKey(slot)) {
            ChasingAABBOutline outline = new ChasingAABBOutline(bb);
            this.outlines.put(slot, new OutlineEntry(outline));
        }
    }

    private ChasingAABBOutline getAndRefreshAABB(Object slot) {
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = 1;
        return (ChasingAABBOutline)entry.getOutline();
    }

    public void tickOutlines() {
        HashSet toClear = new HashSet();
        this.outlines.forEach((key, entry) -> {
            ((OutlineEntry)entry).ticksTillRemoval--;
            entry.getOutline().tick();
            if (entry.isAlive()) {
                return;
            }
            toClear.add(key);
        });
        toClear.forEach(this.outlines::remove);
    }

    public void renderOutlines(MatrixStack ms, IRenderTypeBuffer buffer) {
        this.outlines.forEach((key, entry) -> {
            Outline outline = entry.getOutline();
            outline.params.alpha = 1.0f;
            if (((OutlineEntry)entry).ticksTillRemoval < 0) {
                int prevTicks = ((OutlineEntry)entry).ticksTillRemoval + 1;
                float fadeticks = ((OutlineEntry)entry).outline.params.getFadeTicks();
                float lastAlpha = prevTicks >= 0 ? 1.0f : 1.0f + (float)prevTicks / fadeticks;
                float currentAlpha = 1.0f + (float)((OutlineEntry)entry).ticksTillRemoval / fadeticks;
                float alpha = MathHelper.func_219799_g((float)Minecraft.func_71410_x().func_184121_ak(), (float)lastAlpha, (float)currentAlpha);
                outline.params.alpha = alpha * alpha * alpha;
                if (outline.params.alpha < 0.125f) {
                    return;
                }
            }
            outline.render(ms, buffer);
        });
    }

    private class OutlineEntry {
        private Outline outline;
        private int ticksTillRemoval;

        public OutlineEntry(Outline outline) {
            this.outline = outline;
            this.ticksTillRemoval = 1;
        }

        public boolean isAlive() {
            return this.ticksTillRemoval >= -this.outline.params.getFadeTicks();
        }

        public Outline getOutline() {
            return this.outline;
        }
    }
}

