/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.foundation.utility;

import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignPicker;
import com.simibubi.mightyarchitect.control.design.DesignQuery;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.TemporaryDesignCache;
import com.simibubi.mightyarchitect.control.design.ThemeStorage;
import com.simibubi.mightyarchitect.control.design.partials.Corner;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.design.partials.FlatRoof;
import com.simibubi.mightyarchitect.control.design.partials.Roof;
import com.simibubi.mightyarchitect.control.design.partials.Tower;
import com.simibubi.mightyarchitect.control.design.partials.TowerFlatRoof;
import com.simibubi.mightyarchitect.control.design.partials.TowerRoof;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;

public class DesignHelper {
    public static Design pickRandom(DesignQuery query, Random rand) {
        Design design = DesignHelper.pickRandomNoFallback(query, rand);
        if (design == null && query.fallback) {
            return DesignHelper.pickRandomNoFallback(query.withTheme(ThemeStorage.IncludedThemes.Fallback.theme), rand);
        }
        return design;
    }

    private static Design pickRandomNoFallback(DesignQuery query, Random rand) {
        ArrayList<Design> remainingDesigns = new ArrayList<Design>(query.theme.getDesigns(query.layer, query.type));
        while (!remainingDesigns.isEmpty()) {
            int index = rand.nextInt(remainingDesigns.size());
            Design chosen = (Design)remainingDesigns.get(index);
            if ((query.isWidthIgnored() || chosen.fitsHorizontally(query.desiredWidth)) && (query.isHeightIgnored() || chosen.fitsVertically(query.desiredHeight))) {
                return chosen;
            }
            remainingDesigns.remove(index);
        }
        return null;
    }

    public static void addCuboid(TemporaryDesignCache designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, Room room) {
        boolean facadeAlongZ;
        Design facadeA = null;
        Design facadeB = null;
        BlockPos start = room.getOrigin();
        BlockPos size = room.getSize();
        int width = size.func_177958_n();
        int height = size.func_177956_o();
        int length = size.func_177952_p();
        Design wallA = null;
        Design wallB = null;
        Design corner = null;
        boolean facadeAlongX = width <= length;
        boolean bl = facadeAlongZ = width >= length;
        if (designProvider.hasCachedRoom(room)) {
            DesignPicker.RoomDesignMapping designs = designProvider.getCachedRoom(room);
            wallA = designs.wall1;
            wallB = designs.wall2;
            corner = designs.corner;
            if (wallA == null || !wallA.fitsHorizontally(width - 2) || !wallA.fitsVertically(height)) {
                wallA = null;
            }
            if (wallB == null || !wallB.fitsHorizontally(length - 2) || !wallB.fitsVertically(height)) {
                wallB = null;
            }
            if (corner == null || !corner.fitsVertically(height)) {
                corner = null;
            }
        }
        if (wallA == null || wallB == null || corner == null) {
            DesignQuery facadeQuery = new DesignQuery(theme, layer, DesignType.FACADE).withHeight(height).withoutFallback();
            DesignQuery wallQuery = new DesignQuery(theme, layer, DesignType.WALL).withHeight(height);
            DesignQuery cornerQuery = new DesignQuery(theme, layer, DesignType.CORNER).withHeight(height);
            if (wallA == null) {
                if (facadeAlongX) {
                    facadeA = designProvider.find(facadeQuery.withWidth(width - 2));
                }
                Design design = wallA = facadeA != null ? facadeA : designProvider.find(wallQuery.withWidth(width - 2));
            }
            if (wallB == null) {
                if (facadeAlongZ) {
                    facadeB = designProvider.find(facadeQuery.withWidth(length - 2));
                }
                Design design = wallB = facadeB != null ? facadeB : designProvider.find(wallQuery.withWidth(length - 2));
            }
            if (corner == null) {
                corner = designProvider.find(cornerQuery);
            }
            designProvider.cacheRoom(room, new DesignPicker.RoomDesignMapping(wallA, wallB, corner));
        }
        if (layer == DesignLayer.Open) {
            if (wallA.fitsHorizontally(length - 2)) {
                wallB = wallA;
            } else if (wallB.fitsHorizontally(width - 2)) {
                wallA = wallB;
            }
        }
        BlockPos cornerZ = start.func_177982_a(0, 0, length - 1);
        BlockPos cornerXZ = start.func_177982_a(width - 1, 0, length - 1);
        BlockPos cornerX = start.func_177982_a(width - 1, 0, 0);
        if (wallA != null && wallB != null && corner != null) {
            designList.add(DesignHelper.wall(wallA, cornerZ, cornerXZ, height));
            designList.add(DesignHelper.wall(wallB, cornerXZ, cornerX, height));
            designList.add(DesignHelper.wall(wallA, cornerX, start, height));
            designList.add(DesignHelper.wall(wallB, start, cornerZ, height));
            designList.add(DesignHelper.corner(corner, start, facadeAlongX ? 135 : 45, height, !facadeAlongX));
            designList.add(DesignHelper.corner(corner, cornerZ, facadeAlongX ? -45 : 45, height, facadeAlongX));
            designList.add(DesignHelper.corner(corner, cornerXZ, facadeAlongX ? -45 : -135, height, !facadeAlongX));
            designList.add(DesignHelper.corner(corner, cornerX, facadeAlongX ? 135 : -135, height, facadeAlongX));
        }
    }

    public static void addTower(TemporaryDesignCache designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, Room room) {
        BlockPos start = room.getOrigin();
        BlockPos size = room.getSize();
        int diameter = size.func_177958_n();
        int height = size.func_177956_o();
        Design tower = null;
        if (!(!designProvider.hasCachedRoom(room) || (tower = designProvider.getCachedRoom((Room)room).wall1).fitsHorizontally(diameter) && tower.fitsVertically(height))) {
            tower = null;
        }
        if (tower == null) {
            DesignQuery towerQuery = new DesignQuery(theme, layer, DesignType.TOWER).withWidth(diameter).withHeight(height);
            tower = designProvider.find(towerQuery);
            designProvider.cacheRoom(room, new DesignPicker.RoomDesignMapping(tower));
        }
        if (tower == null) {
            return;
        }
        designList.add(DesignHelper.tower(tower, start, height));
    }

    public static void addTowerRoof(TemporaryDesignCache designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, Stack stack, boolean flat) {
        Room highest = stack.highest();
        BlockPos start = highest.getOrigin().func_177981_b(highest.height);
        BlockPos size = highest.getSize();
        int diameter = size.func_177958_n();
        Design roof = null;
        if (designProvider.hasCachedRoof(stack)) {
            boolean typeChanged;
            roof = designProvider.getCachedRoof(stack);
            boolean bl = typeChanged = stack.getRoofType().getDesign().getClass() != roof.getClass();
            if (!roof.fitsHorizontally(diameter) || typeChanged) {
                roof = null;
            }
        }
        if (roof == null) {
            DesignType type = flat ? DesignType.TOWER_FLAT_ROOF : DesignType.TOWER_ROOF;
            DesignQuery roofQuery = new DesignQuery(theme, layer, type).withWidth(diameter);
            roof = designProvider.find(roofQuery);
            designProvider.cacheRoof(stack, roof);
        }
        if (roof == null) {
            return;
        }
        designList.add(flat ? DesignHelper.towerFlatRoof(roof, start) : DesignHelper.towerRoof(roof, start));
    }

    public static void addNormalRoof(TemporaryDesignCache designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, Stack stack) {
        Room highest = stack.highest();
        BlockPos start = highest.getOrigin().func_177981_b(highest.height);
        BlockPos size = highest.getSize();
        boolean south = size.func_177952_p() < size.func_177958_n();
        int depth = south ? size.func_177958_n() : size.func_177952_p();
        int width = south ? size.func_177952_p() : size.func_177958_n();
        BlockPos cornerZ = start.func_177982_a(0, 0, size.func_177952_p() - 1);
        BlockPos cornerXZ = start.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
        BlockPos cornerX = start.func_177982_a(size.func_177958_n() - 1, 0, 0);
        Design roof = null;
        if (designProvider.hasCachedRoof(stack) && (!(roof = designProvider.getCachedRoof(stack)).fitsHorizontally(width) || roof.getClass() != highest.roofType.getDesign().getClass())) {
            roof = null;
        }
        if (roof == null) {
            roof = designProvider.find(new DesignQuery(theme, layer, DesignType.ROOF).withWidth(width));
            designProvider.cacheRoof(stack, roof);
        }
        if (roof == null) {
            return;
        }
        designList.add(DesignHelper.roof(roof, south ? start : cornerX, south ? 90 : 180, depth - 4));
        designList.add(DesignHelper.roof(roof, south ? cornerXZ : cornerZ, south ? -90 : 0, depth - 4));
    }

    public static void addNormalCrossRoof(TemporaryDesignCache designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, Stack stack) {
        Room highest = stack.highest();
        BlockPos start = highest.getOrigin().func_177981_b(highest.height);
        BlockPos size = highest.getSize();
        boolean south = size.func_177952_p() < size.func_177958_n();
        int depth = south ? size.func_177958_n() : size.func_177952_p();
        int width = south ? size.func_177952_p() : size.func_177958_n();
        BlockPos cornerZ = start.func_177982_a(0, 0, size.func_177952_p() - 1);
        BlockPos cornerXZ = start.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
        BlockPos cornerX = start.func_177982_a(size.func_177958_n() - 1, 0, 0);
        Design roof = null;
        if (designProvider.hasCachedRoof(stack) && (!(roof = designProvider.getCachedRoof(stack)).fitsHorizontally(width) || roof.getClass() != highest.roofType.getDesign().getClass())) {
            roof = null;
        }
        if (roof == null) {
            roof = designProvider.find(new DesignQuery(theme, layer, DesignType.ROOF).withWidth(width));
            designProvider.cacheRoof(stack, roof);
        }
        if (roof == null) {
            return;
        }
        designList.add(DesignHelper.quadRoof(roof, start, 90, depth - 4));
        designList.add(DesignHelper.quadRoof(roof, cornerXZ, -90, depth - 4));
        designList.add(DesignHelper.quadRoof(roof, cornerX, 180, depth - 4));
        designList.add(DesignHelper.quadRoof(roof, cornerZ, 0, depth - 4));
    }

    public static void addFlatRoof(TemporaryDesignCache designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, Stack stack) {
        Room highest = stack.highest();
        BlockPos start = highest.getOrigin().func_177981_b(highest.height);
        BlockPos size = highest.getSize();
        boolean south = size.func_177952_p() < size.func_177958_n();
        int depth = south ? size.func_177958_n() : size.func_177952_p();
        int width = south ? size.func_177952_p() : size.func_177958_n();
        BlockPos cornerZ = start.func_177982_a(0, 0, size.func_177952_p() - 1);
        BlockPos cornerXZ = start.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
        BlockPos cornerX = start.func_177982_a(size.func_177958_n() - 1, 0, 0);
        Design flatroof = null;
        if (designProvider.hasCachedRoof(stack) && (!(flatroof = designProvider.getCachedRoof(stack)).fitsHorizontally(width) || flatroof.getClass() != highest.roofType.getDesign().getClass())) {
            flatroof = null;
        }
        if (flatroof == null) {
            flatroof = designProvider.find(new DesignQuery(theme, layer, DesignType.FLAT_ROOF).withWidth(width));
            designProvider.cacheRoof(stack, flatroof);
        }
        if (flatroof == null) {
            return;
        }
        designList.add(DesignHelper.flatroof(flatroof, south ? start : cornerX, south ? 90 : 180, width, depth));
        designList.add(DesignHelper.flatroof(flatroof, south ? cornerXZ : cornerZ, south ? -90 : 0, width, depth));
    }

    public static Design.DesignInstance wall(Design design, BlockPos corner1, BlockPos corner2, int height) {
        int xDiff = corner2.func_177958_n() - corner1.func_177958_n();
        int zDiff = corner2.func_177952_p() - corner1.func_177952_p();
        int xStep = (int)Math.signum(xDiff);
        int zStep = (int)Math.signum(zDiff);
        corner1 = corner1.func_177982_a(xStep, 0, zStep);
        int width = Math.abs(xDiff == 0 ? zDiff : xDiff) - 1;
        int rotation = xDiff == 0 ? (zDiff > 0 ? 90 : -90) : (xDiff > 0 ? 0 : 180);
        return design.create(corner1, rotation, width, height);
    }

    public static Design.DesignInstance corner(Design design, BlockPos pos, int angle, int height, boolean flip) {
        return ((Corner)design).create(pos, angle + 45, height, flip);
    }

    public static Design.DesignInstance trim(Design design, BlockPos pos, int angle, int height) {
        return design.create(pos, angle, height);
    }

    public static Design.DesignInstance roof(Design design, BlockPos pos, int angle, int depth) {
        return ((Roof)design).create(pos, angle, depth);
    }

    public static Design.DesignInstance quadRoof(Design design, BlockPos pos, int angle, int depth) {
        return ((Roof)design).createAsCross(pos, angle, depth);
    }

    public static Design.DesignInstance flatroof(Design design, BlockPos pos, int angle, int width, int depth) {
        return ((FlatRoof)design).create(pos, angle, width, depth);
    }

    public static Design.DesignInstance tower(Design design, BlockPos pos, int height) {
        return ((Tower)design).create(pos, height);
    }

    public static Design.DesignInstance towerRoof(Design design, BlockPos pos) {
        return ((TowerRoof)design).create(pos);
    }

    public static Design.DesignInstance towerFlatRoof(Design design, BlockPos pos) {
        return ((TowerFlatRoof)design).create(pos);
    }
}

