/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase;

import com.simibubi.mightyarchitect.control.design.DesignExporter;
import com.simibubi.mightyarchitect.control.phase.IArchitectPhase;
import com.simibubi.mightyarchitect.control.phase.PhaseComposing;
import com.simibubi.mightyarchitect.control.phase.PhaseCreatingPalette;
import com.simibubi.mightyarchitect.control.phase.PhaseEmpty;
import com.simibubi.mightyarchitect.control.phase.PhasePaused;
import com.simibubi.mightyarchitect.control.phase.PhasePreviewing;
import com.simibubi.mightyarchitect.control.phase.PrintingToMultiplayer;
import com.simibubi.mightyarchitect.control.phase.export.PhaseEditTheme;
import com.simibubi.mightyarchitect.control.phase.export.PhaseListThemesForEditing;
import com.simibubi.mightyarchitect.control.phase.export.PhaseManageThemes;

public enum ArchitectPhases {
    Empty(new PhaseEmpty(), "Choose a theme:"),
    Paused(new PhasePaused(), "Architect was Paused"),
    Composing(new PhaseComposing(), "Compose Mode"),
    Previewing(new PhasePreviewing(), "Preview Mode"),
    CreatingPalette(new PhaseCreatingPalette(), "Pallete Mode"),
    ManagingThemes(new PhaseManageThemes(), "Manage Themes"),
    ListForEdit(new PhaseListThemesForEditing(), "Edit a Theme"),
    EditingThemes(new PhaseEditTheme(), "Editing "),
    PrintingToMultiplayer(new PrintingToMultiplayer(), "Printing Blocks...");

    private IArchitectPhase handler;
    private String displayTitle;

    private ArchitectPhases(IArchitectPhase handler, String displayName) {
        this.handler = handler;
        this.displayTitle = displayName;
    }

    public IArchitectPhase getPhaseHandler() {
        return this.handler;
    }

    public String getDisplayTitle() {
        if (this == EditingThemes) {
            return this.displayTitle + DesignExporter.theme.getDisplayName();
        }
        return this.displayTitle;
    }
}

