/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.simibubi.mightyarchitect.AllSpecialTextures;
import com.simibubi.mightyarchitect.MightyClient;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.compose.planner.GroundPlanningToolBase;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.ThemeStatistics;
import com.simibubi.mightyarchitect.foundation.utility.Keyboard;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.commons.lang3.mutable.MutableObject;

public class RoomTool
extends GroundPlanningToolBase {
    protected BlockPos firstPosition;
    protected Stack lastAddedStack;
    protected Object textKey1 = new Object();
    protected Object textKey2 = new Object();
    protected Object textKey3 = new Object();
    protected Object textKey4 = new Object();
    static Object outlineKey = new Object();

    @Override
    public void init() {
        super.init();
        this.firstPosition = null;
        this.toolModeNoCtrl = "3-Grid";
        this.toolModeCtrl = "5-Grid";
        if (this.lastAddedStack != null && this.lastAddedStack.floors() == 0) {
            this.lastAddedStack = null;
        }
    }

    @Override
    public String handleRightClick() {
        super.handleRightClick();
        if (this.selectedPosition == null) {
            return null;
        }
        if (this.firstPosition == null) {
            this.firstPosition = this.selectedPosition;
            return "First position marked";
        }
        return this.createRoom(ArchitectManager.getModel().getGroundPlan());
    }

    protected String createRoom(GroundPlan groundPlan) {
        Room room = new Room(this.firstPosition, this.selectedPosition.func_177973_b((Vector3i)this.firstPosition));
        ++room.width;
        ++room.length;
        DesignTheme theme = groundPlan.theme;
        ThemeStatistics stats = theme.getStatistics();
        boolean hasFoundation = theme.getLayers().contains((Object)DesignLayer.Foundation);
        room.designLayer = hasFoundation ? DesignLayer.Foundation : DesignLayer.Regular;
        int facadeWidth = Math.min(room.width, room.length);
        if (facadeWidth % 2 == 0) {
            return "Facade cannot have even width: " + facadeWidth;
        }
        if (facadeWidth < stats.MinRoomLength) {
            return "Facade is too narrow (<" + stats.MinRoomLength + "): " + facadeWidth;
        }
        if (room.width > stats.MaxRoomLength) {
            return "Room is too large (>" + stats.MaxRoomLength + "): " + room.width;
        }
        if (room.length > stats.MaxRoomLength) {
            return "Room is too large (>" + stats.MaxRoomLength + "): " + room.length;
        }
        room.roofType = facadeWidth > stats.MaxGableRoof || !stats.hasGables ? (stats.hasFlatRoof ? DesignType.FLAT_ROOF : DesignType.NONE) : (stats.hasGables ? DesignType.ROOF : DesignType.NONE);
        this.lastAddedStack = new Stack(room);
        if (!this.adjustHeightForIntersection(groundPlan, room)) {
            room.height = theme.getDefaultHeightForFloor(0);
        }
        groundPlan.addStack(this.lastAddedStack);
        this.firstPosition = null;
        return "Scroll UP to add floors, DOWN to undo";
    }

    protected boolean adjustHeightForIntersection(GroundPlan groundPlan, Room room) {
        MutableObject biggestRoom = new MutableObject();
        if (room.height == 0) {
            room.height = 1;
        }
        groundPlan.forEachRoom(r -> {
            if (r.intersects(room) && r.y + r.height > room.y && room.y + room.height > r.y && (biggestRoom.getValue() == null || ((Room)biggestRoom.getValue()).width * ((Room)biggestRoom.getValue()).length < r.width * r.length)) {
                biggestRoom.setValue(r);
            }
        });
        if (biggestRoom.getValue() != null) {
            room.height = ((Room)biggestRoom.getValue()).y + ((Room)biggestRoom.getValue()).height - room.y;
            if (room.height > groundPlan.theme.getMaxFloorHeight()) {
                room.height -= ((Room)biggestRoom.getValue()).height;
            }
            return true;
        }
        return false;
    }

    public static void increaseMatchingOthers(GroundPlan groundPlan, Stack stack) {
        stack.increase();
        Room added = stack.highest();
        MutableObject biggestRoom = new MutableObject();
        groundPlan.forEachRoom(r -> {
            if (r == added) {
                return;
            }
            if (r.intersects(added) && r.y <= added.y && r.y + r.height > added.y && (biggestRoom.getValue() == null || ((Room)biggestRoom.getValue()).width * ((Room)biggestRoom.getValue()).length < r.width * r.length)) {
                biggestRoom.setValue(r);
            }
        });
        if (biggestRoom.getValue() != null) {
            added.height = ((Room)biggestRoom.getValue()).y + ((Room)biggestRoom.getValue()).height - added.y;
        }
    }

    @Override
    public boolean handleMouseWheel(int scroll) {
        if (this.lastAddedStack == null) {
            return false;
        }
        if (scroll > 0) {
            RoomTool.increaseMatchingOthers(ArchitectManager.getModel().getGroundPlan(), this.lastAddedStack);
        } else {
            this.lastAddedStack.decrease();
            if (this.lastAddedStack.floors() == 0) {
                ArchitectManager.getModel().getGroundPlan().remove(this.lastAddedStack);
                this.lastAddedStack = null;
            }
        }
        return true;
    }

    @Override
    public void updateSelection() {
        super.updateSelection();
        if (this.firstPosition == null) {
            return;
        }
        if (this.selectedPosition == null) {
            return;
        }
        BlockPos size = this.selectedPosition.func_177973_b((Vector3i)this.firstPosition);
        int xSize = size.func_177958_n();
        int zSize = size.func_177952_p();
        if (Keyboard.isKeyDown(341)) {
            int zr;
            int xr = (xSize + (xSize > 0 ? 2 : -2)) % 4;
            xr = xr < 0 ? (xr += 4) : 4 - xr;
            if (xr != 0) {
                this.selectedPosition = this.selectedPosition.func_177965_g(xSize > 0 ? xr : -xr);
            }
            zr = (zr = (zSize + (zSize > 0 ? 2 : -2)) % 4) < 0 ? (zr += 4) : 4 - zr;
            if (zr != 0) {
                this.selectedPosition = this.selectedPosition.func_177970_e(zSize > 0 ? zr : -zr);
            }
        } else {
            if (xSize % 2 != 0) {
                this.selectedPosition = this.selectedPosition.func_177965_g(xSize > 0 ? 1 : -1);
            }
            if (zSize % 2 != 0) {
                this.selectedPosition = this.selectedPosition.func_177970_e(zSize > 0 ? 1 : -1);
            }
        }
    }

    @Override
    public void tickToolOutlines() {
        if (this.selectedPosition == null) {
            return;
        }
        BlockPos anchor = ArchitectManager.getModel().getAnchor();
        BlockPos cursorPos = anchor != null ? this.selectedPosition.func_177971_a((Vector3i)anchor) : this.selectedPosition;
        BlockPos previouslySelectedPos = this.firstPosition != null ? this.firstPosition.func_177971_a((Vector3i)anchor) : cursorPos;
        BlockPos size = cursorPos.func_177973_b((Vector3i)previouslySelectedPos);
        Cuboid selection = new Cuboid(previouslySelectedPos, size.func_177958_n(), 1, size.func_177952_p());
        ++selection.width;
        ++selection.length;
        MightyClient.outliner.chaseAABB(outlineKey, selection.toAABB()).withFaceTexture(AllSpecialTextures.CHECKERED).colored(0);
        if (this.firstPosition == null) {
            return;
        }
        this.drawTextAroundBounds(selection);
    }

    protected void drawTextAroundBounds(Cuboid selection) {
        float hw = (float)selection.width / 2.0f;
        float hl = (float)selection.length / 2.0f;
        this.chaseText(this.textKey1, (float)selection.x + hw, (float)selection.y + 0.5f, selection.z - 1, "" + selection.width + "m");
        this.chaseText(this.textKey2, (float)selection.x + hw, (float)selection.y + 0.5f, selection.z + selection.length + 1, "" + selection.width + "m");
        this.chaseText(this.textKey3, selection.x + selection.width + 1, (float)selection.y + 0.5f, (float)selection.z + hl, "" + selection.length + "m");
        this.chaseText(this.textKey4, selection.x - 1, (float)selection.y + 0.5f, (float)selection.z + hl, "" + selection.length + "m");
    }

    private void chaseText(Object key, float x, float y, float z, String text) {
        MightyClient.outliner.chaseText(key, new Vector3d((double)x, (double)y, (double)z), text).colored(0).coloredFaces(0xFFFFFF).disableNormals().withFaceTexture(AllSpecialTextures.BLANK);
    }
}

