/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.planner.AbstractRoomFaceSelectionTool;
import com.simibubi.mightyarchitect.foundation.utility.Keyboard;
import net.minecraft.util.text.TextFormatting;

public class HeightTool
extends AbstractRoomFaceSelectionTool {
    @Override
    public void init() {
        super.init();
        this.toolModeNoCtrl = "Move Stack (Y)";
        this.toolModeCtrl = "Resize (Y)";
    }

    @Override
    public boolean handleMouseWheel(int scroll) {
        if (selectedRoom != null) {
            if (Keyboard.isKeyDown(341)) {
                if (HeightTool.selectedRoom.height + scroll > this.model.getTheme().getMaxFloorHeight()) {
                    HeightTool.selectedRoom.height = this.model.getTheme().getMaxFloorHeight();
                    this.status("Height: " + TextFormatting.AQUA + HeightTool.selectedRoom.height + TextFormatting.WHITE + "m (max)");
                    return true;
                }
                if (HeightTool.selectedRoom.height + scroll < 1) {
                    HeightTool.selectedRoom.height = 1;
                    this.status("Height: " + TextFormatting.AQUA + HeightTool.selectedRoom.height + TextFormatting.WHITE + "m (min)");
                    return true;
                }
                HeightTool.selectedRoom.height += scroll;
                selectedStack.forEachAbove(selectedRoom, room -> room.y += scroll);
                this.status("Height: " + TextFormatting.AQUA + HeightTool.selectedRoom.height + TextFormatting.WHITE + "m");
            } else {
                selectedStack.forRoomAndEachAbove(selectedStack.lowest(), room -> room.move(0, scroll, 0));
                this.status("Position: " + TextFormatting.AQUA + HeightTool.selectedStack.lowest().y);
            }
            return true;
        }
        return super.handleMouseWheel(scroll);
    }

    @Override
    protected boolean isRoomHighlighted(Room room) {
        return super.isRoomHighlighted(room) || !Keyboard.isKeyDown(341) && selectedStack != null && selectedStack.getRooms().contains(room);
    }

    @Override
    public void updateSelection() {
        super.updateSelection();
        this.highlightRoom = Keyboard.isKeyDown(341);
    }
}

