/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose;

import com.simibubi.mightyarchitect.control.compose.CylinderStack;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;

public class GroundPlan {
    public static final int MAX_LAYERS = 5;
    public DesignTheme theme;
    private List<Stack> stacks;
    private List<Room> interior;

    public GroundPlan(DesignTheme theme) {
        this.theme = theme;
        this.stacks = new ArrayList<Stack>();
        this.interior = new LinkedList<Room>();
    }

    public List<Room> getInterior() {
        this.interior.clear();
        this.forEachStack(stack -> {
            if (stack instanceof CylinderStack) {
                return;
            }
            stack.forEach(room -> this.interior.add(room.getInterior()));
        });
        return this.interior;
    }

    public void addStack(Stack stack) {
        this.stacks.add(stack);
    }

    public Stack getStackAtPos(BlockPos localPos) {
        for (Stack stack : this.stacks) {
            Room room = stack.getRoomAtPos(localPos);
            if (room == null) continue;
            return stack;
        }
        return null;
    }

    public Room getRoomAtPos(BlockPos localPos) {
        for (Stack stack : this.stacks) {
            Room room = stack.getRoomAtPos(localPos);
            if (room == null) continue;
            return room;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public void remove(Stack stack) {
        this.stacks.remove(stack);
    }

    public void forEachStack(Consumer<? super Stack> action) {
        this.stacks.forEach(action);
    }

    public void forEachRoom(Consumer<? super Room> action) {
        this.stacks.forEach(stack -> stack.forEach(action));
    }
}

