/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control;

import com.simibubi.mightyarchitect.control.TemplateBlockAccess;
import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.Sketch;
import com.simibubi.mightyarchitect.control.palette.PaletteBlockInfo;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.networking.InstantPrintPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;

public class Schematic {
    private BlockPos anchor;
    private GroundPlan groundPlan;
    private PaletteDefinition primaryPalette;
    private PaletteDefinition secondaryPalette;
    private Sketch sketch;
    private Vector<Map<BlockPos, PaletteBlockInfo>> assembledSketch;
    private TemplateBlockAccess materializedSketch;
    private Cuboid bounds;
    private PaletteDefinition editedPalette;
    private boolean editingPrimary;
    public int seed = new Random().nextInt(100000);

    public void setGroundPlan(GroundPlan groundPlan) {
        this.groundPlan = groundPlan;
    }

    public void setAnchor(BlockPos anchor) {
        this.anchor = anchor;
    }

    public void swapPrimaryPalette(PaletteDefinition newPalette) {
        this.primaryPalette = newPalette;
        this.materializeSketch();
    }

    public void swapSecondaryPalette(PaletteDefinition newPalette) {
        this.secondaryPalette = newPalette;
        this.materializeSketch();
    }

    public void setSketch(Sketch newSketch) {
        this.sketch = newSketch;
        this.assembleSketch();
        this.materializeSketch();
    }

    public Sketch getSketch() {
        return this.sketch;
    }

    public GroundPlan getGroundPlan() {
        return this.groundPlan;
    }

    public BlockPos getAnchor() {
        return this.anchor;
    }

    public PaletteDefinition getPrimary() {
        return this.primaryPalette;
    }

    public PaletteDefinition getSecondary() {
        return this.secondaryPalette;
    }

    public TemplateBlockAccess getMaterializedSketch() {
        return this.materializedSketch;
    }

    public void assembleSketch() {
        this.assembledSketch = this.sketch.assemble();
    }

    public Cuboid getLocalBounds() {
        return this.bounds;
    }

    public Cuboid getGlobalBounds() {
        Cuboid clone = this.bounds.clone();
        clone.move(this.anchor.func_177958_n(), this.anchor.func_177956_o(), this.anchor.func_177952_p());
        return clone;
    }

    public void startCreatingNewPalette(boolean primary) {
        this.editedPalette = (primary ? this.primaryPalette : this.secondaryPalette).clone();
        this.editedPalette.setName("");
        this.editingPrimary = primary;
    }

    public PaletteDefinition getCreatedPalette() {
        return this.editedPalette;
    }

    public void updatePalettePreview() {
        if (this.isEditingPrimary()) {
            this.materializeSketch(this.editedPalette, this.secondaryPalette);
        } else {
            this.materializeSketch(this.primaryPalette, this.editedPalette);
        }
    }

    public void stopPalettePreview() {
        this.materializeSketch();
    }

    public void applyCreatedPalette() {
        if (this.isEditingPrimary()) {
            this.primaryPalette = this.editedPalette;
        } else {
            this.secondaryPalette = this.editedPalette;
        }
        this.materializeSketch();
    }

    public void materializeSketch() {
        if (this.primaryPalette == null) {
            this.primaryPalette = this.groundPlan.theme.getDefaultPalette().clone();
            this.secondaryPalette = this.groundPlan.theme.getDefaultSecondaryPalette().clone();
        }
        this.materializeSketch(this.primaryPalette, this.secondaryPalette);
    }

    private void materializeSketch(PaletteDefinition primary, PaletteDefinition secondary) {
        this.bounds = null;
        HashMap<BlockPos, BlockState> blockMap = new HashMap<BlockPos, BlockState>();
        this.assembledSketch.get(0).forEach((pos, paletteInfo) -> {
            BlockState state = primary.get((PaletteBlockInfo)paletteInfo);
            blockMap.put((BlockPos)pos, state);
            this.checkBounds((BlockPos)pos);
        });
        this.assembledSketch.get(1).forEach((pos, paletteInfo) -> {
            if (!this.assembledSketch.get(0).containsKey(pos) || !this.assembledSketch.get((int)0).get((Object)pos).palette.isPrefferedOver(paletteInfo.palette)) {
                BlockState state = secondary.get((PaletteBlockInfo)paletteInfo);
                blockMap.put((BlockPos)pos, state);
                this.checkBounds((BlockPos)pos);
            }
        });
        this.materializedSketch = new TemplateBlockAccess(blockMap, this.bounds, this.anchor);
    }

    private void checkBounds(BlockPos pos) {
        BlockPos maxPos;
        if (this.bounds == null) {
            this.bounds = new Room(pos, BlockPos.field_177992_a);
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x < this.bounds.x) {
            this.bounds.width += this.bounds.x - x;
            this.bounds.x = x;
        }
        if (y < this.bounds.y) {
            this.bounds.height += this.bounds.y - y;
            this.bounds.y = y;
        }
        if (z < this.bounds.z) {
            this.bounds.length += this.bounds.z - z;
            this.bounds.z = z;
        }
        if (x >= (maxPos = this.bounds.getOrigin().func_177971_a((Vector3i)this.bounds.getSize())).func_177958_n()) {
            this.bounds.width = x - this.bounds.x + 1;
        }
        if (y >= maxPos.func_177956_o()) {
            this.bounds.height = y - this.bounds.y + 1;
        }
        if (z >= maxPos.func_177952_p()) {
            this.bounds.length = z - this.bounds.z + 1;
        }
    }

    public Template writeToTemplate() {
        Template template = new Template();
        template.func_186252_a(Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString());
        this.materializedSketch.localMode(true);
        template.func_186254_a((World)this.materializedSketch, this.materializedSketch.getBounds().getOrigin(), this.materializedSketch.getBounds().getSize(), false, null);
        this.materializedSketch.localMode(false);
        return template;
    }

    public List<InstantPrintPacket> getPackets() {
        return InstantPrintPacket.sendSchematic(this.materializedSketch.getBlockMap(), this.anchor);
    }

    public boolean isEditingPrimary() {
        return this.editingPrimary;
    }

    public DesignTheme getTheme() {
        return this.groundPlan.theme;
    }

    public boolean isEmpty() {
        return this.groundPlan == null;
    }
}

