/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.map;

import java.awt.image.BufferedImage;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.jukoz.me.utils.resources.FileUtils;
import net.jukoz.me.world.map.MiddleEarthMapConfigs;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector2i;

public class MiddleEarthMapUtils {
    private static MiddleEarthMapUtils single_instance = null;
    private final float ratioX;
    private final float ratioZ;
    private final int maxImageCoordinateX;
    private final int maxImageCoordinateZ;
    private MinecraftServer server;

    public static synchronized MiddleEarthMapUtils getInstance() {
        if (single_instance == null) {
            single_instance = new MiddleEarthMapUtils();
        }
        return single_instance;
    }

    public MiddleEarthMapUtils() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
        });
        BufferedImage initial = FileUtils.getInstance().getResourceImage(MiddleEarthMapConfigs.INITIAL_IMAGE);
        this.ratioX = (float)((double)(3000 / initial.getWidth()) * Math.pow(2.0, 3.0) * 4.0);
        this.ratioZ = (float)((double)(3000 / initial.getHeight()) * Math.pow(2.0, 3.0) * 4.0);
        this.maxImageCoordinateX = (int)((float)initial.getWidth() * this.ratioX);
        this.maxImageCoordinateZ = (int)((float)initial.getHeight() * this.ratioZ);
    }

    public List<class_3222> getPlayers() {
        return this.server.method_3760().method_14571();
    }

    public int getTick() {
        if (this.server == null) {
            return 1;
        }
        return this.server.method_3780();
    }

    public Vector2i getWorldCoordinateFromInitialMap(int x, int z) {
        return new Vector2i((int)((float)x * this.ratioX), (int)((float)z * this.ratioZ));
    }

    public Vector2i getRegionByWorldCoordinate(int x, int z) {
        Vector2i region = new Vector2i();
        region.x = ((x /= 4) - x % 3000) / 3000;
        region.y = ((z /= 4) - z % 3000) / 3000;
        return region;
    }

    public boolean isWorldCoordinateInBorder(int x, int z) {
        if (x < 0 || z < 0) {
            return false;
        }
        return x < this.maxImageCoordinateX && z < this.maxImageCoordinateZ;
    }
}

