/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.map;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.jukoz.me.utils.LoggerUtil;
import net.jukoz.me.world.biomes.surface.MEBiome;
import net.jukoz.me.world.biomes.surface.MEBiomesData;
import net.jukoz.me.world.map.MiddleEarthMapRegion;
import net.jukoz.me.world.map.MiddleEarthMapUtils;
import net.minecraft.class_3222;
import org.joml.Vector2i;

public class MiddleEarthMapRuntime {
    private static MiddleEarthMapRuntime single_instance = null;
    HashMap<Vector2i, MiddleEarthMapRegion> regions = new HashMap();
    HashMap<UUID, Vector2i> regionByUuids = new HashMap();
    private LoggerUtil loggerUtil = LoggerUtil.getInstance();
    private MiddleEarthMapUtils middleEarthMapUtils = MiddleEarthMapUtils.getInstance();
    private int latestValidationTick = 0;
    private int currentValidationBlockCount = 0;

    public static synchronized MiddleEarthMapRuntime getInstance() {
        if (single_instance == null) {
            single_instance = new MiddleEarthMapRuntime();
        }
        return single_instance;
    }

    public MEBiome getBiome(int posX, int posZ) {
        if (!this.middleEarthMapUtils.isWorldCoordinateInBorder(posX, posZ)) {
            return MEBiomesData.defaultBiome;
        }
        MiddleEarthMapRegion region = this.getRegionToUse(this.middleEarthMapUtils.getRegionByWorldCoordinate(posX, posZ));
        if (region == null) {
            return MEBiomesData.defaultBiome;
        }
        return region.getBiome(this.getImageCoordinates(posX, posZ));
    }

    public Color getHeight(int posX, int posZ) {
        if (!this.middleEarthMapUtils.isWorldCoordinateInBorder(posX, posZ)) {
            return null;
        }
        MiddleEarthMapRegion region = this.getRegionToUse(this.middleEarthMapUtils.getRegionByWorldCoordinate(posX, posZ));
        if (region == null) {
            return null;
        }
        return region.getHeightColor(this.getImageCoordinates(posX, posZ));
    }

    private Vector2i getImageCoordinates(int posX, int posZ) {
        return new Vector2i((int)((float)posX / 4.0f % 3000.0f), (int)((float)posZ / 4.0f % 3000.0f));
    }

    private MiddleEarthMapRegion getRegionToUse(Vector2i regionCoordinate) {
        this.purgeRegions();
        if (this.regions.get(regionCoordinate) != null) {
            return this.regions.get(regionCoordinate);
        }
        return this.regions.put(regionCoordinate, new MiddleEarthMapRegion(regionCoordinate));
    }

    private void purgeRegions() {
        ++this.currentValidationBlockCount;
        if (this.currentValidationBlockCount < 5000) {
            return;
        }
        this.currentValidationBlockCount = 0;
        int serverTick = this.middleEarthMapUtils.getTick();
        if (serverTick - this.latestValidationTick < 1000) {
            return;
        }
        this.latestValidationTick = serverTick;
        ArrayList toPurge = new ArrayList();
        ArrayList<Vector2i> playerCoordinates = new ArrayList<Vector2i>();
        for (class_3222 player : this.middleEarthMapUtils.getPlayers()) {
            playerCoordinates.add(new Vector2i(player.method_31477(), player.method_31479()));
        }
        try {
            this.middleEarthMapUtils.getPlayers();
            this.regions.forEach((key, value) -> {
                boolean hasPlayerInRange = false;
                for (Vector2i coordinate : playerCoordinates) {
                    if (!value.isInRange(coordinate)) continue;
                    hasPlayerInRange = true;
                    break;
                }
                if (!hasPlayerInRange) {
                    toPurge.add(key);
                }
            });
            for (Vector2i region : toPurge) {
                this.regions.remove(region);
            }
        }
        catch (Exception exception) {
            this.loggerUtil.logError("%s : %s".formatted(this.toString(), exception.getMessage()));
        }
    }
}

