/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.map;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import net.jukoz.me.utils.resources.FileUtils;
import net.jukoz.me.world.biomes.surface.MEBiome;
import net.jukoz.me.world.biomes.surface.MEBiomesData;
import net.jukoz.me.world.map.MiddleEarthMapConfigs;
import org.joml.Vector2i;

public class MiddleEarthMapRegion {
    public static final int CALC_REGION_SIZE = 12000;
    public final Vector2i coordinate;
    private final BufferedImage biomeImage;
    private final BufferedImage heightImage;

    public MiddleEarthMapRegion(Vector2i coordinate) {
        this.coordinate = coordinate;
        String biomePath = MiddleEarthMapConfigs.BIOME_PATH.formatted(3) + "/%s_%s.png".formatted(coordinate.x, coordinate.y);
        String heightPath = MiddleEarthMapConfigs.HEIGHT_PATH + "/%s_%s.png".formatted(coordinate.x, coordinate.y);
        this.biomeImage = FileUtils.getInstance().getRunImage(biomePath);
        this.heightImage = FileUtils.getInstance().getRunImage(heightPath);
    }

    public MEBiome getBiome(Vector2i imageCoordinates) {
        if (this.biomeImage != null) {
            return MEBiomesData.getBiomeByColor(this.biomeImage.getRGB(imageCoordinates.x, imageCoordinates.y));
        }
        return MEBiomesData.defaultBiome;
    }

    public Color getHeightColor(Vector2i imageCoordinates) {
        if (this.heightImage != null) {
            return new Color(this.heightImage.getRGB(imageCoordinates.x, imageCoordinates.y));
        }
        return new Color(Math.abs(MEBiomesData.defaultBiome.height), 1, 0);
    }

    public boolean isInRange(Vector2i playerCoord) {
        int middleCoordinateX = 12000 * (this.coordinate.x + 1) - 6000;
        int middleCoordinateZ = 12000 * (this.coordinate.y + 1) - 6000;
        double distance = this.calculateDistance(playerCoord.x, playerCoord.y, middleCoordinateX, middleCoordinateZ);
        return distance < 8000.0;
    }

    private double calculateDistance(double x1, double y1, double x2, double y2) {
        return Point2D.distance(x1, y1, x2, y2);
    }
}

