/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.map;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.jukoz.me.utils.LoggerUtil;
import net.jukoz.me.utils.resources.FileType;
import net.jukoz.me.utils.resources.FileUtils;
import net.jukoz.me.world.biomes.surface.MEBiomesData;
import net.jukoz.me.world.chunkgen.map.ImageUtils;
import net.jukoz.me.world.map.MiddleEarthMapConfigs;

public class MiddleEarthMapGeneration {
    private FileUtils fileUtils = FileUtils.getInstance();
    private LoggerUtil loggerUtil = LoggerUtil.getInstance();
    private static final int WATER_BUFFER = 28;
    private static final float WATER_HEIGHT_MULTIPLIER = 1.0f;

    public MiddleEarthMapGeneration() throws Exception {
        this.generate();
    }

    public void generate() throws Exception {
        this.loggerUtil.logInfoMsg("");
        this.loggerUtil.logInfoMsg("================ MiddleEarthMapGeneration ================");
        BufferedImage initialMap = this.getInitialImage();
        if (initialMap == null) {
            throw new Exception(this + " : The image of the map in resource has created an error and operation cannot continue.");
        }
        this.loggerUtil.logInfoMsg("Validating BIOME generation availability;");
        int iterationToGenerate = this.findAmountOfIterationToGenerate(initialMap);
        if (iterationToGenerate > 0) {
            this.loggerUtil.logInfoMsg("Begin BIOME generation;");
            this.generateBiomes(initialMap, iterationToGenerate);
        }
        this.loggerUtil.logInfoMsg("Validating HEIGHT generation availability;");
        if (!this.validateHeightDatas(initialMap)) {
            this.loggerUtil.logInfoMsg("Begin HEIGHT generation;");
            this.generateHeight(initialMap);
        }
    }

    private BufferedImage getInitialImage() {
        this.loggerUtil.logInfoMsg("Validating ORIGINAL image existence;");
        BufferedImage initialImage = this.fileUtils.getResourceImage(MiddleEarthMapConfigs.INITIAL_IMAGE);
        if (initialImage == null) {
            this.loggerUtil.logError("Initial map image couldn't be found!");
            return null;
        }
        this.loggerUtil.logInfoMsg("Validating ORIGINAL image size;");
        if (initialImage.getWidth() % 3000 != 0 || initialImage.getHeight() % 3000 != 0) {
            this.loggerUtil.logError("Initial map image has the wrong size!");
            return null;
        }
        return initialImage;
    }

    private int findAmountOfIterationToGenerate(BufferedImage initialMap) {
        int currentRegionAmountX = initialMap.getWidth() / 3000;
        int currentRegionAmountY = initialMap.getHeight() / 3000;
        int absoluteMapIteration = 4;
        for (int i = 0; i < absoluteMapIteration; ++i) {
            if (i > 0) {
                currentRegionAmountX *= 2;
                currentRegionAmountY *= 2;
            }
            for (int x = 0; x < currentRegionAmountX; ++x) {
                for (int y = 0; y < currentRegionAmountY; ++y) {
                    String path = MiddleEarthMapConfigs.BIOME_PATH.formatted(i) + "/%s_%s.png".formatted(x, y);
                    if (this.fileUtils.getRunImage(path) != null) continue;
                    this.loggerUtil.logError("TO REMOVE - Lacking biome file at : [%s]".formatted(path));
                    return absoluteMapIteration - i;
                }
            }
        }
        return 0;
    }

    private BufferedImage[][][] generateBiomes(BufferedImage initialImage, int missingIterationAmount) {
        int startingIteration = 4 - missingIterationAmount;
        if (startingIteration == 0) {
            this.generateInitialBiomes(initialImage);
            ++startingIteration;
        }
        for (int i = startingIteration; i < 4; ++i) {
            ExecutorService executorService = Executors.newFixedThreadPool(8);
            int regionAmountX = (int)((double)(initialImage.getWidth() / 3000) * Math.pow(2.0, i - 1));
            int regionAmountY = (int)((double)(initialImage.getHeight() / 3000) * Math.pow(2.0, i - 1));
            for (int x = 0; x < regionAmountX; ++x) {
                int y = 0;
                while (y < regionAmountY) {
                    int finalI = i;
                    int finalX = x;
                    int finalY = y++;
                    executorService.submit(() -> {
                        String path = MiddleEarthMapConfigs.BIOME_PATH.formatted(finalI - 1) + "/%s_%s.png".formatted(finalX, finalY);
                        BufferedImage[][] subidivedRegions = ImageUtils.subdivide(this.fileUtils.getRunImage(path));
                        for (int j = 0; j < 2; ++j) {
                            for (int k = 0; k < 2; ++k) {
                                this.fileUtils.saveImage(subidivedRegions[j][k], MiddleEarthMapConfigs.BIOME_PATH.formatted(finalI), "/%s_%s.png".formatted(finalX * 2 + j, finalY * 2 + k), FileType.Png);
                            }
                        }
                    });
                }
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                continue;
            }
            catch (Exception e) {
                this.loggerUtil.logError("Error while generating biomes");
            }
        }
        return new BufferedImage[0][][];
    }

    private void generateInitialBiomes(BufferedImage initialImage) {
        if (initialImage.getWidth() != 3000 || initialImage.getWidth() != 3000) {
            this.loggerUtil.logError("TO REMOVE - Need splitting for the initial image!");
            for (int i = 0; i < initialImage.getWidth() / 3000; ++i) {
                for (int j = 0; j < initialImage.getHeight() / 3000; ++j) {
                    BufferedImage newImage = initialImage.getSubimage(3000 * i, 3000 * j, 3000, 3000);
                    this.fileUtils.saveImage(newImage, MiddleEarthMapConfigs.BIOME_PATH.formatted(0), "/%s_%s.png".formatted(i, j), FileType.Png);
                }
            }
        } else {
            this.fileUtils.saveImage(initialImage, MiddleEarthMapConfigs.BIOME_PATH.formatted(0), "/%s_%s.png".formatted(0, 0), FileType.Png);
        }
    }

    private boolean validateHeightDatas(BufferedImage initialImage) {
        int regionAmountX = (int)((double)(initialImage.getWidth() / 3000) * Math.pow(2.0, 3.0));
        int regionAmountY = (int)((double)(initialImage.getHeight() / 3000) * Math.pow(2.0, 3.0));
        for (int x = 0; x < regionAmountX; ++x) {
            for (int y = 0; y < regionAmountY; ++y) {
                String path = MiddleEarthMapConfigs.HEIGHT_PATH + "/%s_%s.png".formatted(x, y);
                if (this.fileUtils.getRunImage(path) != null) continue;
                return false;
            }
        }
        return true;
    }

    private void generateHeight(BufferedImage initialImage) {
        ExecutorService executorService = Executors.newFixedThreadPool(8);
        int regionAmountX = (int)((double)(initialImage.getWidth() / 3000) * Math.pow(2.0, 3.0));
        int regionAmountY = (int)((double)(initialImage.getHeight() / 3000) * Math.pow(2.0, 3.0));
        for (int x = 0; x < regionAmountX; ++x) {
            int y = 0;
            while (y < regionAmountY) {
                int finalX = x;
                int finalY = y++;
                executorService.submit(() -> {
                    String path = MiddleEarthMapConfigs.BIOME_PATH.formatted(3) + "/%s_%s.png".formatted(finalX, finalY);
                    this.fileUtils.saveImage(FileUtils.blur(MiddleEarthMapGeneration.processHeightRegion(this.fileUtils.getRunImage(path), 3000), 16, 0.00390625f), MiddleEarthMapConfigs.HEIGHT_PATH, "/%s_%s.png".formatted(finalX, finalY), FileType.Png);
                });
            }
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (Exception e) {
            this.loggerUtil.logError("Error while generating biomes");
        }
    }

    private static BufferedImage processHeightRegion(BufferedImage biomeImage, int size) {
        BufferedImage newHeightRegion = new BufferedImage(size, size, 1);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                try {
                    int height = MEBiomesData.getBiomeByColor((Integer)Integer.valueOf((int)biomeImage.getRGB((int)x, (int)y))).height;
                    if (height > 255) {
                        height = 255;
                    }
                    int water = 0;
                    if (height < 0) {
                        water = (int)Math.abs((float)height * 1.0f - 28.0f);
                        height = 0;
                    }
                    int decimal = 0;
                    newHeightRegion.setRGB(x, y, new Color(Math.abs(height), decimal, water).getRGB());
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("MiddleEarthMapGeneration.processHeightRegion : Failed to create color for the height [%s]".formatted(e));
                }
            }
        }
        return newHeightRegion;
    }
}

