/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.features.tree.trunks;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.jukoz.me.world.gen.ModTreeGeneration;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class LargeTrunkPlacer
extends class_5141 {
    protected final int baseHeight;
    protected final int randomHeight;
    protected final float baseRadius;
    protected final float tipRadius;
    protected final float velocity;
    protected final int iterations;
    protected final float iterationPercentage;
    public static final Codec<LargeTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)90).fieldOf("base_height").forGetter(trunkPlacer -> trunkPlacer.baseHeight), (App)Codec.intRange((int)0, (int)16).fieldOf("random_height").forGetter(trunkPlacer -> trunkPlacer.randomHeight), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("base_hadius").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.baseRadius)), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("tip_hadius").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.tipRadius)), (App)Codec.floatRange((float)0.0f, (float)8.0f).fieldOf("velocity").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.velocity)), (App)Codec.intRange((int)1, (int)8).fieldOf("iteration").forGetter(trunkPlacer -> trunkPlacer.iterations), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("iteration_percentage").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.iterationPercentage))).apply((Applicative)instance, LargeTrunkPlacer::new));

    public LargeTrunkPlacer(int baseHeight, int randomHeight, float baseRadius, float tipRadius, float velocity, int iterations, float iterationPercentage) {
        super(baseHeight, randomHeight, 0);
        this.baseHeight = baseHeight;
        this.randomHeight = randomHeight;
        this.baseRadius = baseRadius;
        this.tipRadius = tipRadius;
        this.velocity = velocity;
        this.iterations = iterations;
        this.iterationPercentage = iterationPercentage;
    }

    protected class_5142<?> method_28903() {
        return ModTreeGeneration.LARGE_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        class_2338 blockPos = startPos.method_10074();
        LargeTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)blockPos, (class_4643)config);
        LargeTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)blockPos.method_10078(), (class_4643)config);
        LargeTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)blockPos.method_10072(), (class_4643)config);
        LargeTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)blockPos.method_10072().method_10078(), (class_4643)config);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        List<class_4647.class_5208> treeNodes = this.createBranches(world, replacer, random, mutable, config, startPos, this.method_26993(random), this.baseRadius, this.tipRadius);
        this.createRoots(world, replacer, random, mutable, config, startPos, (int)((float)this.method_26993(random) / 3.5f), this.baseRadius * 0.9f, this.tipRadius);
        return ImmutableList.copyOf(treeNodes);
    }

    private List<class_4647.class_5208> createBranches(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 mutable, class_4643 config, class_2338 startPos, int height, float radiusA, float radiusB) {
        ArrayList<class_4647.class_5208> treeNodes = new ArrayList<class_4647.class_5208>();
        float heightProgress = 0.0f;
        List<class_2338> currentTopBranches = List.of(startPos);
        for (int i = 0; i < this.iterations; ++i) {
            int currentHeight = (int)((float)height * heightProgress);
            float currentRadiusA = class_3532.method_16439((float)heightProgress, (float)radiusA, (float)radiusB);
            float step = (float)(i + 1) / (float)this.iterations;
            heightProgress = (float)Math.pow(step, this.iterationPercentage);
            currentHeight = (int)((float)height * heightProgress) - currentHeight;
            float currentRadiusB = class_3532.method_16439((float)(1.0f - heightProgress), (float)radiusB, (float)radiusA);
            ArrayList<class_2338> newTopBranches = new ArrayList<class_2338>();
            for (class_2338 currentTopBranch : currentTopBranches) {
                double angle = Math.random() * 114.59155902616465;
                double angle2 = angle + 80.0 + Math.random() * 31.830988618379067;
                int tempHeight = currentHeight;
                if (i == this.iterations - 1) {
                    tempHeight = (int)((double)tempHeight + ((double)(-this.randomHeight) + Math.random() * (double)(this.randomHeight * 2)));
                }
                newTopBranches.add(this.createBranch(world, replacer, random, mutable, config, currentTopBranch, tempHeight, angle, currentRadiusA, currentRadiusB));
                newTopBranches.add(this.createBranch(world, replacer, random, mutable, config, currentTopBranch, tempHeight, angle2, currentRadiusA, currentRadiusB));
                if (i <= 0 || i >= this.iterations - 1 || !(Math.random() < (double)0.45f)) continue;
                int index = newTopBranches.size() - 1;
                treeNodes.add(new class_4647.class_5208((class_2338)newTopBranches.get(index), 0, false));
                newTopBranches.remove(index);
            }
            currentTopBranches = newTopBranches;
        }
        for (class_2338 pos : currentTopBranches) {
            treeNodes.add(new class_4647.class_5208(pos, 0, false));
        }
        return treeNodes;
    }

    protected void createRoots(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 mutable, class_4643 config, class_2338 startPos, int height, float radiusA, float radiusB) {
        int rootsNb = 4 + (int)(Math.random() * 3.0);
        startPos = startPos.method_10069(0, (int)((float)height * 0.6f), 0);
        double angle = Math.random() * 114.59155902616465;
        for (int i = 0; i < rootsNb; ++i) {
            this.createBranch(world, replacer, random, mutable, config, startPos, -height, angle, radiusA, radiusB);
            angle = angle + (double)(360 / (rootsNb + 1)) - 5.0 + Math.random() * 10.0;
        }
    }

    protected class_2338 createBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 mutable, class_4643 config, class_2338 startPos, int height, double direction, float radiusA, float radiusB) {
        int multiplier = 1;
        if (height < 0) {
            multiplier = -1;
            height *= -1;
        }
        float radius = radiusA;
        int ceilRadius = (int)Math.ceil(radiusA);
        float offsetX = 0.0f;
        float offsetZ = 0.0f;
        for (int i = 0; i < height; ++i) {
            float percentage = (float)Math.pow((float)i / (float)height, 1.2);
            offsetX = class_3532.method_16439((float)percentage, (float)0.0f, (float)((float)Math.cos(direction))) * this.velocity;
            offsetZ = class_3532.method_16439((float)percentage, (float)0.0f, (float)((float)Math.sin(direction))) * this.velocity;
            for (int x = -ceilRadius; x <= ceilRadius; ++x) {
                for (int z = -ceilRadius; z <= ceilRadius; ++z) {
                    double dx = x;
                    double dz = z;
                    double distanceSquared = x * x + z * z;
                    if (!((distanceSquared += Math.random() * (double)-0.51f) <= (double)(radius * radius))) continue;
                    this.setLog(world, replacer, random, mutable, config, startPos, (int)(dx += (double)offsetX), i * multiplier, (int)(dz += (double)offsetZ));
                }
            }
            radius = class_3532.method_16439((float)((float)i / (float)height), (float)radiusA, (float)radiusB);
        }
        return new class_2338((class_2382)startPos).method_10069((int)offsetX, multiplier * height, (int)offsetZ);
    }

    protected void setLog(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 tmpPos, class_4643 config, class_2338 startPos, int dx, int dy, int dz) {
        tmpPos.method_25504((class_2382)startPos, dx, dy, dz);
        this.method_27401(world, replacer, random, tmpPos, config);
    }
}

