/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.features.tree.trunks;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import net.jukoz.me.world.gen.ModTreeGeneration;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class CanopyTrunkPlacer
extends class_5141 {
    protected final int baseHeight;
    protected final int randomHeight;
    protected final float baseRadius;
    protected final float tipRadius;
    protected final float velocity;
    protected final int iterations;
    protected final float iteration_percentage;
    protected final float trunk_noise;
    protected final int roots_offset;
    protected final int straight_trunk;
    public static final Codec<CanopyTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)90).fieldOf("base_height").forGetter(trunkPlacer -> trunkPlacer.baseHeight), (App)Codec.intRange((int)0, (int)16).fieldOf("random_height").forGetter(trunkPlacer -> trunkPlacer.randomHeight), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("base_radius").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.baseRadius)), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("tip_radius").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.tipRadius)), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("velocity").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.velocity)), (App)Codec.intRange((int)1, (int)8).fieldOf("iteration").forGetter(trunkPlacer -> trunkPlacer.iterations), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("iteration_percentage").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.iteration_percentage)), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("trunk_noise").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.trunk_noise)), (App)Codec.intRange((int)-8, (int)8).fieldOf("roots_offset").forGetter(trunkPlacer -> trunkPlacer.roots_offset), (App)Codec.intRange((int)0, (int)1).fieldOf("straight_trunk").forGetter(trunkPlacer -> trunkPlacer.straight_trunk)).apply((Applicative)instance, CanopyTrunkPlacer::new));

    public CanopyTrunkPlacer(int baseHeight, int randomHeight, float baseRadius, float tipRadius, float velocity, int iterations, float iteration_percentage, float trunk_noise, int roots_offset, int straight_trunk) {
        super(baseHeight, randomHeight, 0);
        this.baseHeight = baseHeight;
        this.randomHeight = randomHeight;
        this.baseRadius = baseRadius;
        this.tipRadius = tipRadius;
        this.velocity = velocity;
        this.iterations = iterations;
        this.iteration_percentage = iteration_percentage;
        this.trunk_noise = trunk_noise;
        this.roots_offset = roots_offset;
        this.straight_trunk = straight_trunk;
    }

    protected class_5142<?> method_28903() {
        return ModTreeGeneration.CANOPY_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        class_2338 blockPos = startPos.method_10074();
        CanopyTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)blockPos, (class_4643)config);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        float heightProgress = (float)Math.pow(1.0f / (float)this.iterations, this.iteration_percentage);
        class_2338 newPos = new class_2338((class_2382)startPos).method_10069(0, (int)((float)height * heightProgress), 0);
        List<class_4647.class_5208> treeNodes = this.createCircleBranches(world, replacer, random, mutable, config, newPos, (int)((float)this.method_26993(random) - (float)height * heightProgress), class_3532.method_16439((float)heightProgress, (float)this.baseRadius, (float)this.tipRadius), this.tipRadius);
        float direction = 0.0f;
        float velocity = 0.0f;
        if (this.straight_trunk == 0) {
            direction = (float)(Math.random() * 114.59155902616465);
            velocity = this.velocity;
        }
        class_4647.class_5208 treeNode = new class_4647.class_5208(this.createBranch(world, replacer, random, mutable, config, startPos, height, direction, velocity, this.baseRadius, this.tipRadius), 1, false);
        treeNodes.add(treeNode);
        this.createRoots(world, replacer, random, mutable, config, startPos.method_10069(0, this.roots_offset, 0), (int)((float)this.method_26993(random) / 2.5f), this.baseRadius * 0.95f, this.tipRadius);
        return ImmutableList.copyOf(treeNodes);
    }

    private List<class_4647.class_5208> createCircleBranches(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 mutable, class_4643 config, class_2338 startPos, int height, float radiusA, float radiusB) {
        ArrayList<class_4647.class_5208> treeNodes = new ArrayList<class_4647.class_5208>();
        List<class_2338> lastTopBranches = List.of(startPos);
        float heightProgress = 0.0f;
        for (int i = 0; i < this.iterations; ++i) {
            ArrayList<class_2338> currentTopBranches = new ArrayList<class_2338>();
            int currentHeight = (int)((float)height * heightProgress);
            float currentRadiusA = class_3532.method_16439((float)heightProgress, (float)radiusA, (float)radiusB);
            float step = (float)(i + 1) / (float)this.iterations;
            heightProgress = (float)Math.pow(step, this.iteration_percentage);
            currentHeight = (int)((float)height * heightProgress) - currentHeight;
            float currentRadiusB = class_3532.method_16439((float)(1.0f - heightProgress), (float)radiusB, (float)radiusA);
            Iterator<class_2338> iterator = lastTopBranches.iterator();
            while (iterator.hasNext()) {
                class_2338 topBranchBlock;
                class_2338 newTopPos = topBranchBlock = iterator.next();
                int count = 2;
                double angle = 360 / count;
                double offsetAngle = Math.random() * 180.0;
                if (i == 0) {
                    count = Math.max(1, 5 + (int)(Math.random() * 2.0));
                }
                for (int k = 0; k < count; ++k) {
                    if (i == 0) {
                        newTopPos = new class_2338((class_2382)topBranchBlock).method_10069(0, (int)(-2.0 + Math.random() * 5.0), 0);
                    }
                    double angle2 = angle * (double)k + offsetAngle;
                    if (currentRadiusA <= 1.0f) {
                        currentTopBranches.add(this.createLinearBranch(world, replacer, random, mutable, config, newTopPos, currentHeight, angle2, this.velocity, currentRadiusA, currentRadiusB));
                    } else {
                        currentTopBranches.add(this.createBranch(world, replacer, random, mutable, config, newTopPos, currentHeight, angle2, this.velocity, currentRadiusA, currentRadiusB));
                    }
                    if (!(Math.random() < (double)0.4f)) continue;
                    int index = currentTopBranches.size() - 1;
                    treeNodes.add(new class_4647.class_5208((class_2338)currentTopBranches.get(index), 0, false));
                    currentTopBranches.remove(index);
                }
            }
            lastTopBranches = currentTopBranches;
        }
        for (class_2338 pos : lastTopBranches) {
            treeNodes.add(new class_4647.class_5208(pos, 0, false));
        }
        return treeNodes;
    }

    protected void createRoots(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 mutable, class_4643 config, class_2338 startPos, int height, float radiusA, float radiusB) {
        int rootsNb = 5 + (int)(Math.random() * 2.0);
        startPos = startPos.method_10069(0, (int)((float)height * 0.6f), 0);
        double direction = Math.random() * 114.59155902616465;
        for (int i = 0; i < rootsNb; ++i) {
            this.createBranch(world, replacer, random, mutable, config, startPos, -height, direction, this.velocity / 2.0f, radiusA, radiusB);
            direction = direction + (double)(360 / (rootsNb + 1)) - 5.0 + Math.random() * 10.0;
        }
    }

    protected class_2338 createLinearBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 mutable, class_4643 config, class_2338 startPos, int height, double angle, float velocity, float radiusA, float radiusB) {
        if (height < 0) {
            height *= -1;
        }
        class_243 dir = new class_243(Math.cos(angle), 1.0, Math.sin(angle));
        class_243 currentPos = new class_243((double)startPos.method_10263(), (double)startPos.method_10264(), (double)startPos.method_10260());
        int iterations = (int)((double)height / dir.field_1351);
        for (int i = 0; i < iterations; ++i) {
            this.setLog(world, replacer, random, mutable, config, new class_2338((int)currentPos.field_1352, (int)currentPos.field_1351, (int)currentPos.field_1350), 0, 0, 0);
            currentPos = currentPos.method_1019(dir);
        }
        return new class_2338((int)currentPos.field_1352, (int)currentPos.field_1351, (int)currentPos.field_1350);
    }

    protected class_2338 createBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 mutable, class_4643 config, class_2338 startPos, int height, double direction, float velocity, float radiusA, float radiusB) {
        int multiplier = 1;
        if (height < 0) {
            multiplier = -1;
            height *= -1;
        }
        float radius = radiusA;
        int ceilRadius = (int)Math.ceil(radiusA);
        float offsetX = 0.0f;
        float offsetZ = 0.0f;
        for (int i = 0; i < height; ++i) {
            float percentage = (float)Math.pow((float)i / (float)height, 1.2);
            offsetX = class_3532.method_16439((float)percentage, (float)0.0f, (float)((float)Math.cos(direction))) * velocity;
            offsetZ = class_3532.method_16439((float)percentage, (float)0.0f, (float)((float)Math.sin(direction))) * velocity;
            for (int x = -ceilRadius; x <= ceilRadius; ++x) {
                for (int z = -ceilRadius; z <= ceilRadius; ++z) {
                    double dx = x;
                    double dz = z;
                    double distanceSquared = x * x + z * z;
                    if (!((distanceSquared += Math.random() * (double)this.trunk_noise) <= (double)(radius * radius))) continue;
                    this.setLog(world, replacer, random, mutable, config, startPos, (int)(dx += (double)offsetX), i * multiplier, (int)(dz += (double)offsetZ));
                }
            }
            radius = class_3532.method_16439((float)((float)i / (float)height), (float)radiusA, (float)radiusB);
        }
        return new class_2338((class_2382)startPos).method_10069((int)offsetX, multiplier * height, (int)offsetZ);
    }

    protected void setLog(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 tmpPos, class_4643 config, class_2338 startPos, int dx, int dy, int dz) {
        tmpPos.method_25504((class_2382)startPos, dx, dy, dz);
        this.method_27401(world, replacer, random, tmpPos, config);
    }
}

