/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.features.tree.trunks;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.jukoz.me.world.gen.ModTreeGeneration;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class ArcTrunkPlacer
extends class_5141 {
    protected final int baseHeight;
    protected final int randomHeight;
    protected final float minAcceleration;
    protected final float maxAcceleration;
    protected final float velocity;
    public static final Codec<ArcTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)90).fieldOf("base_height").forGetter(trunkPlacer -> trunkPlacer.baseHeight), (App)Codec.intRange((int)0, (int)16).fieldOf("random_height").forGetter(trunkPlacer -> trunkPlacer.randomHeight), (App)Codec.floatRange((float)0.0f, (float)0.2f).fieldOf("min_acceleration").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.minAcceleration)), (App)Codec.floatRange((float)0.0f, (float)0.2f).fieldOf("max_acceleration").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.maxAcceleration)), (App)Codec.floatRange((float)0.0f, (float)0.2f).fieldOf("velocity").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.velocity))).apply((Applicative)instance, ArcTrunkPlacer::new));

    public ArcTrunkPlacer(int baseHeight, int randomHeight, float minAcceleration, float maxAcceleration, float velocity) {
        super(baseHeight, randomHeight, 0);
        this.baseHeight = baseHeight;
        this.randomHeight = randomHeight;
        this.minAcceleration = minAcceleration;
        this.maxAcceleration = maxAcceleration;
        this.velocity = velocity;
    }

    protected class_5142<?> method_28903() {
        return ModTreeGeneration.ARC_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        class_2338 blockPos = startPos.method_10074();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        double angle = Math.random() * 180.0;
        float acceleration = (float)(Math.random() * (double)(this.maxAcceleration - this.minAcceleration) + (double)this.minAcceleration);
        List<class_4647.class_5208> treeNodes = this.createArcBranch(world, replacer, random, mutable, config, startPos, this.method_26993(random), angle, acceleration, this.velocity);
        return ImmutableList.copyOf(treeNodes);
    }

    protected List<class_4647.class_5208> createArcBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 mutable, class_4643 config, class_2338 startPos, int height, double angle, float acceleration, float velocity) {
        if (height < 0) {
            height *= -1;
        }
        class_243 dir = new class_243(Math.cos(angle), 1.0, Math.sin(angle)).method_1029();
        class_243 currentPos = new class_243((double)startPos.method_10263(), (double)(startPos.method_10264() - 1), (double)startPos.method_10260());
        float currentVel = velocity;
        int topHeight = (int)(currentPos.field_1351 + (double)height);
        while (currentPos.method_10214() < (double)topHeight) {
            currentPos = currentPos.method_1019(new class_243(dir.field_1352 * (double)currentVel, dir.field_1351, dir.field_1350 * (double)currentVel));
            this.setLog(world, replacer, random, mutable, config, new class_2338((int)currentPos.field_1352, (int)currentPos.field_1351, (int)currentPos.field_1350), 0, 0, 0);
            currentVel += acceleration;
        }
        ArrayList<class_4647.class_5208> treeNodes = new ArrayList<class_4647.class_5208>();
        treeNodes.add(new class_4647.class_5208(new class_2338((int)currentPos.field_1352, (int)currentPos.field_1351, (int)currentPos.field_1350), 0, false));
        return treeNodes;
    }

    protected void setLog(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 tmpPos, class_4643 config, class_2338 startPos, int dx, int dy, int dz) {
        tmpPos.method_25504((class_2382)startPos, dx, dy, dz);
        this.method_27401(world, replacer, random, tmpPos, config);
    }
}

