/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.features.tree.roots;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.jukoz.me.world.features.tree.ModRootPlacerType;
import net.jukoz.me.world.features.tree.roots.MirkwoodRootPlacement;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4651;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_7387;
import net.minecraft.class_7388;
import net.minecraft.class_7398;

public class MirkwoodRootPlacer
extends class_7387 {
    public static final int field_38769 = 8;
    public static final int field_38770 = 15;
    public static final Codec<MirkwoodRootPlacer> CODEC = RecordCodecBuilder.create(instance -> MirkwoodRootPlacer.method_43182((RecordCodecBuilder.Instance)instance).and((App)MirkwoodRootPlacement.CODEC.fieldOf("mirkwood_root_placement").forGetter(rootPlacer -> rootPlacer.mirkwoodRootPlacement)).apply((Applicative)instance, MirkwoodRootPlacer::new));
    private final MirkwoodRootPlacement mirkwoodRootPlacement;

    public MirkwoodRootPlacer(class_6017 trunkOffsetY, class_4651 rootProvider, Optional<class_7398> aboveRootPlacement, MirkwoodRootPlacement mirkwoodRootPlacement) {
        super(trunkOffsetY, rootProvider, aboveRootPlacement);
        this.mirkwoodRootPlacement = mirkwoodRootPlacement;
    }

    public boolean method_43168(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 pos, class_2338 trunkPos, class_4643 config) {
        ArrayList list = Lists.newArrayList();
        class_2338.class_2339 mutable = pos.method_25503();
        while (mutable.method_10264() < trunkPos.method_10264()) {
            if (!this.method_43167(world, (class_2338)mutable)) {
                return false;
            }
            mutable.method_10098(class_2350.field_11036);
        }
        list.add(trunkPos.method_10074());
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            ArrayList list2;
            class_2338 blockPos = trunkPos.method_10093(direction);
            if (!this.canGrow(world, random, blockPos, direction, trunkPos, list2 = Lists.newArrayList(), 0)) {
                return false;
            }
            list.addAll(list2);
            list.add(trunkPos.method_10093(direction));
        }
        for (class_2338 blockPos2 : list) {
            this.method_43172(world, replacer, random, blockPos2, config);
        }
        return true;
    }

    private boolean canGrow(class_3746 world, class_5819 random, class_2338 pos, class_2350 direction, class_2338 origin, List<class_2338> offshootPositions, int rootLength) {
        int i = this.mirkwoodRootPlacement.maxRootLength();
        if (rootLength != i && offshootPositions.size() <= i) {
            List<class_2338> list = this.getOffshootPositions(pos, direction, random, origin);
            for (class_2338 blockPos : list) {
                if (!this.method_43167(world, blockPos)) continue;
                offshootPositions.add(blockPos);
                if (this.canGrow(world, random, blockPos, direction, origin, offshootPositions, rootLength + 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<class_2338> getOffshootPositions(class_2338 pos, class_2350 direction, class_5819 random, class_2338 origin) {
        class_2338 blockPos = pos.method_10074();
        class_2338 blockPos2 = pos.method_10093(direction);
        int i = pos.method_19455((class_2382)origin);
        int j = this.mirkwoodRootPlacement.maxRootWidth();
        float f = this.mirkwoodRootPlacement.randomSkewChance();
        if (i > j - 3 && i <= j) {
            return random.method_43057() < f ? List.of(blockPos, blockPos2.method_10074()) : List.of(blockPos);
        }
        if (i > j) {
            return List.of(blockPos);
        }
        if (random.method_43057() < f) {
            return List.of(blockPos);
        }
        return random.method_43056() ? List.of(blockPos2) : List.of(blockPos);
    }

    protected boolean method_43167(class_3746 world, class_2338 pos) {
        return super.method_43167(world, pos) || world.method_16358(pos, state -> state.method_40143(this.mirkwoodRootPlacement.canGrowThrough()));
    }

    protected void method_43172(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 pos, class_4643 config) {
        if (world.method_16358(pos, state -> state.method_40143(this.mirkwoodRootPlacement.muddyRootsIn()))) {
            class_2680 blockState = this.mirkwoodRootPlacement.muddyRootsProvider().method_23455(random, pos);
            replacer.accept(pos, this.method_43181(world, pos, blockState));
        } else {
            super.method_43172(world, replacer, random, pos, config);
        }
    }

    protected class_7388<?> method_43165() {
        return ModRootPlacerType.MIRKWOOD_ROOT_PLACER;
    }
}

