/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.chunkgen.map;

import java.awt.Color;
import java.util.ArrayList;
import net.jukoz.me.utils.noises.BlendedNoise;
import net.jukoz.me.world.biomes.surface.MEBiomesData;
import net.jukoz.me.world.map.MiddleEarthMapRuntime;
import net.jukoz.me.world.map.MiddleEarthMapUtils;

public class MiddleEarthHeightMap {
    public static final int SMOOTH_BRUSH_SIZE = 2;
    public static final int PERLIN_STRETCH_X = 210;
    public static final int PERLIN_STRETCH_Y = 180;
    public static final int PERLIN_STRETCH_X2 = 37;
    public static final int PERLIN_STRETCH_Y2 = 37;
    public static final int PERLIN_HEIGHT_RANGE = 33;
    public static final float MOUNTAIN_HEIGHT_RANGE = 8.6f;
    public static final float MOUNTAIN_HEIGHT_MULTIPLIER = 1.87f;
    public static final float MOUNTAIN_EXPONENTIAL_HEIGHT = 1.107f;
    public static final int MOUNTAIN_START_HEIGHT = 16;
    public static final int PERLIN_HEIGHT_OFFSET = 8;
    public static final int STONE_HEIGHT = 54;
    public static final int HEIGHT = 62;
    public static final int DIRT_HEIGHT = 65;
    public static final int WATER_MAX = 16;
    public static final float WATER_MULTIPLIER = 1.31f;
    public static final float WATER_PERLIN_DIVIDER = 2.2f;
    private static final int PIXEL_WEIGHT = 4;
    public static final ArrayList<Float> percentages = new ArrayList();
    private static MiddleEarthMapRuntime middleEarthMapRuntime;
    private static Float defaultWeightHeight;

    public MiddleEarthHeightMap() {
        middleEarthMapRuntime = MiddleEarthMapRuntime.getInstance();
    }

    private static float getImageHeight(int xWorld, int zWorld) {
        Color color;
        if (middleEarthMapRuntime == null) {
            middleEarthMapRuntime = MiddleEarthMapRuntime.getInstance();
        }
        if ((color = middleEarthMapRuntime.getHeight(xWorld, zWorld)) != null) {
            float red = color.getRed();
            float blue = color.getBlue();
            float height = red;
            if (blue > 0.0f) {
                float percentage = (16.0f - blue) / 16.0f;
                percentage = Math.max(0.0f, Math.min(1.0f, percentage));
                height *= percentage;
                height -= blue * 1.31f;
            }
            return height;
        }
        return (float)MEBiomesData.defaultBiome.height * 1.31f;
    }

    public static double getPerlinHeight(int x, int z) {
        double perlin = 1.0 * BlendedNoise.noise((double)x / 210.0, (double)z / 180.0);
        perlin += 0.5 * BlendedNoise.noise((double)x * 2.0 / 210.0, (double)z * 2.0 / 180.0);
        perlin += 0.25 * BlendedNoise.noise((double)x * 4.0 / 210.0, (double)z * 4.0 / 180.0);
        perlin += 0.125 * BlendedNoise.noise((double)x * 8.0 / 210.0, (double)z * 8.0 / 180.0);
        perlin /= 1.875;
        perlin *= 33.0;
        return perlin += 8.0;
    }

    private static float getPerlinMapHeight(int x, int z) {
        double perlin = MiddleEarthHeightMap.getPerlinHeight(x, z);
        float biomeHeight = 0.0f;
        biomeHeight = MiddleEarthMapUtils.getInstance().isWorldCoordinateInBorder(x, z) ? MiddleEarthHeightMap.getBiomeWeightHeight(x, z) : MiddleEarthHeightMap.getDefaultWeightHeight();
        if (biomeHeight < 0.0f) {
            perlin /= (double)Math.max(1.0f, Math.min(5.0f, Math.abs(biomeHeight / 2.2f)));
        }
        if (biomeHeight >= 16.0f) {
            float multiplier = biomeHeight / 16.0f - 1.0f;
            biomeHeight += biomeHeight * multiplier * 1.107f;
            multiplier = 1.87f * multiplier;
            perlin += (double)(multiplier * 1.107f * 8.6f) * BlendedNoise.noise((double)x / 37.0, (double)z / 37.0);
            perlin += (double)(multiplier * 4.3f) * BlendedNoise.noise((double)(2 * x) / 37.0, (double)(2 * z) / 37.0);
        }
        double additionalHeight = (double)biomeHeight + perlin;
        return (float)additionalHeight;
    }

    private static float getBiomeWeightHeight(int x, int z) {
        float topLeft = MiddleEarthHeightMap.getImageHeight(x, z);
        float topRight = MiddleEarthHeightMap.getImageHeight(x + 4, z);
        float bottomLeft = MiddleEarthHeightMap.getImageHeight(x, z + 4);
        float bottomRight = MiddleEarthHeightMap.getImageHeight(x + 4, z + 4);
        return MiddleEarthHeightMap.getHeightBetween(new float[]{topLeft, topRight, bottomLeft, bottomRight}, (float)(x % 4) / 4.0f, (float)(z % 4) / 4.0f);
    }

    private static float getDefaultWeightHeight() {
        if (defaultWeightHeight == null) {
            int x = 0;
            int z = 0;
            float topLeft = MiddleEarthHeightMap.getImageHeight(x, z);
            float topRight = MiddleEarthHeightMap.getImageHeight(x + 4, z);
            float bottomLeft = MiddleEarthHeightMap.getImageHeight(x, z + 4);
            float bottomRight = MiddleEarthHeightMap.getImageHeight(x + 4, z + 4);
            defaultWeightHeight = Float.valueOf(MiddleEarthHeightMap.getHeightBetween(new float[]{topLeft, topRight, bottomLeft, bottomRight}, (float)(x % 4) / 4.0f, (float)(z % 4) / 4.0f));
        }
        return defaultWeightHeight.floatValue();
    }

    private static float getHeightBetween(float[] heights, float xPercent, float zPercent) {
        float h1 = MiddleEarthHeightMap.getMiddleHeight(heights[0], heights[1], xPercent);
        float h2 = MiddleEarthHeightMap.getMiddleHeight(heights[2], heights[3], xPercent);
        return MiddleEarthHeightMap.getMiddleHeight(h1, h2, zPercent);
    }

    private static float getMiddleHeight(float a, float b, float percentage) {
        if (!percentages.contains(Float.valueOf(percentage))) {
            percentages.add(Float.valueOf(percentage));
        }
        float percentage2 = 1.0f - percentage;
        return a * percentage2 + b * percentage;
    }

    private static float getSmoothHeight(int x, int z) {
        float total = 0.0f;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (MiddleEarthMapUtils.getInstance().isWorldCoordinateInBorder(x + i, z + j)) {
                    total += (float)MEBiomesData.defaultBiome.height;
                    continue;
                }
                total += MiddleEarthHeightMap.getBiomeWeightHeight(x, z);
            }
        }
        return total / 25.0f;
    }

    public static float getHeight(int x, int z) {
        return MiddleEarthHeightMap.getPerlinMapHeight(x, z);
    }

    static float getPointOnBezierCurve(float h0, float h1, float h2, float t) {
        float a = MiddleEarthHeightMap.lerp(h0, h1, t);
        float b = MiddleEarthHeightMap.lerp(h1, h2, t);
        float d = MiddleEarthHeightMap.lerp(a, b, t);
        return d;
    }

    public static float lerp(float a, float b, float interpolation) {
        return a + interpolation * (b - a);
    }

    static {
        defaultWeightHeight = null;
    }
}

