/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.chunkgen.map;

import com.google.common.base.Stopwatch;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageUtils {
    private static byte[] SEED = ImageUtils.generateSeed(50);
    private static int SEED_INDEX = 0;
    public static int BRUSH_SIZE = 16;
    public static float RATIO = 1.0f / (float)(BRUSH_SIZE * BRUSH_SIZE);

    public static BufferedImage fetchResourceImage(ClassLoader classLoader, String path) throws IOException {
        URL resource = classLoader.getResource(path);
        BufferedImage img = ImageIO.read(resource);
        return img;
    }

    public static BufferedImage fetchRunImage(String path) throws Exception {
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        BufferedImage img = ImageIO.read(f);
        return img;
    }

    public static void saveImage(BufferedImage bufferedImage, String path, String fileName) throws Exception {
        new File(path).mkdirs();
        File f = new File(path + fileName);
        ImageIO.write((RenderedImage)bufferedImage, "png", f);
    }

    public static BufferedImage blur(BufferedImage image) {
        int y;
        int x;
        int width = image.getWidth();
        int height = image.getHeight();
        int newWidth = width + 2 * BRUSH_SIZE;
        int newHeight = height + 2 * BRUSH_SIZE;
        BufferedImage expendedImage = new BufferedImage(newWidth, newHeight, image.getType());
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                expendedImage.setRGB(x + BRUSH_SIZE, y + BRUSH_SIZE, image.getRGB(x, y));
            }
        }
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < BRUSH_SIZE; ++x2) {
                expendedImage.setRGB(x2, y2 + BRUSH_SIZE, image.getRGB(0, y2));
                expendedImage.setRGB(width + BRUSH_SIZE + x2, y2 + BRUSH_SIZE, image.getRGB(width - 1, y2));
            }
        }
        for (x = 0; x < width + 2 * BRUSH_SIZE; ++x) {
            for (y = 0; y < BRUSH_SIZE; ++y) {
                expendedImage.setRGB(x, y, expendedImage.getRGB(x, BRUSH_SIZE));
                expendedImage.setRGB(x, height + BRUSH_SIZE + y, expendedImage.getRGB(x, height + BRUSH_SIZE - 1));
            }
        }
        float[] blurKernel = new float[BRUSH_SIZE * BRUSH_SIZE];
        Arrays.fill(blurKernel, RATIO);
        Kernel kernel = new Kernel(BRUSH_SIZE, BRUSH_SIZE, blurKernel);
        ConvolveOp op = new ConvolveOp(kernel, 1, null);
        expendedImage = op.filter(expendedImage, null);
        return expendedImage.getSubimage(BRUSH_SIZE, BRUSH_SIZE, width, height);
    }

    public static BufferedImage[][] subdivide(BufferedImage parent) {
        BufferedImage[][] subidivedImages = new BufferedImage[2][2];
        int width = parent.getWidth();
        int height = parent.getHeight();
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                subidivedImages[x][y] = ImageUtils.createChildFromParentImage(new BufferedImage(width, height, 2), parent, width / 2, x, y);
            }
        }
        return subidivedImages;
    }

    private static BufferedImage createChildFromParentImage(BufferedImage child, BufferedImage parent, int halfRegionSize, int xIndex, int yIndex) {
        for (int x = halfRegionSize * xIndex; x < halfRegionSize * (xIndex + 1); ++x) {
            for (int y = halfRegionSize * yIndex; y < halfRegionSize * (yIndex + 1); ++y) {
                child.setRGB((x - halfRegionSize * xIndex) * 2, (y - halfRegionSize * yIndex) * 2, parent.getRGB(x, y));
            }
        }
        return ImageUtils.fillImage(child);
    }

    private static BufferedImage fillImage(BufferedImage image) {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        int width = image.getWidth();
        int height = image.getHeight();
        ArrayList<Integer> biomeColors = new ArrayList<Integer>();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                boolean yIsUneven;
                boolean xIsUneven = x % 2 == 1;
                boolean bl = yIsUneven = y % 2 == 1;
                if (xIsUneven ^ yIsUneven) {
                    if (xIsUneven) {
                        if (x < width - 1) {
                            biomeColors.add(image.getRGB(x + 1, y));
                        }
                        biomeColors.add(image.getRGB(x - 1, y));
                    }
                    if (yIsUneven) {
                        if (y < height - 1) {
                            biomeColors.add(image.getRGB(x, y + 1));
                        }
                        biomeColors.add(image.getRGB(x, y - 1));
                    }
                    image.setRGB(x, y, ImageUtils.getRandomInteger(biomeColors));
                    biomeColors.clear();
                    if (!yIsUneven || x <= 1) continue;
                    biomeColors.add(image.getRGB(x, y));
                    biomeColors.add(image.getRGB(x - 2, y));
                    if (y < height - 1) {
                        biomeColors.add(image.getRGB(x - 1, y + 1));
                    }
                    biomeColors.add(image.getRGB(x - 1, y - 1));
                    image.setRGB(x - 1, y, ImageUtils.getRandomInteger(biomeColors));
                    biomeColors.clear();
                    continue;
                }
                if (x != width - 1) continue;
                image.setRGB(x, y, image.getRGB(x - 1, y));
            }
        }
        stopwatch.reset();
        return image;
    }

    private static Integer getRandomInteger(List<Integer> list) {
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (ImageUtils.getNextSeed() < 5) continue;
            index = (byte)(index + 1);
        }
        if (index == -1) {
            index = 0;
        }
        return list.get(index);
    }

    public static byte[] generateSeed(int bound) {
        String piString = "31415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679";
        byte[] piBytes = new byte[piString.length()];
        for (int i = 0; i < piString.length(); ++i) {
            piBytes[i] = Byte.parseByte(String.valueOf(piString.charAt(i)));
        }
        SEED = piBytes;
        SEED_INDEX = bound % piBytes.length;
        return SEED;
    }

    public static byte getNextSeed() {
        if (++SEED_INDEX >= SEED.length) {
            SEED_INDEX = 0;
        }
        return SEED[SEED_INDEX];
    }
}

