/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.chunkgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.jukoz.me.block.StoneBlockSets;
import net.jukoz.me.utils.noises.BlendedNoise;
import net.jukoz.me.utils.noises.SimplexNoise;
import net.jukoz.me.world.biomes.MEBiomeKeys;
import net.jukoz.me.world.biomes.surface.MEBiome;
import net.jukoz.me.world.biomes.surface.MEBiomesData;
import net.jukoz.me.world.biomes.surface.ModBiomeSource;
import net.jukoz.me.world.chunkgen.map.MiddleEarthHeightMap;
import net.jukoz.me.world.map.MiddleEarthMapRuntime;
import net.jukoz.me.world.map.MiddleEarthMapUtils;
import net.minecraft.class_1923;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6673;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7138;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class MiddleEarthChunkGenerator
extends class_2794 {
    public static final int EPMOSTO_LEVEL = -32;
    public static final int DIFTOMIN_LEVEL = 0;
    public static final int DEEPSLATE_LEVEL = 32;
    public static final int STONE_HEIGHT = 36;
    public static final int WATER_HEIGHT = 64;
    public static final int LAVA_HEIGHT = -60;
    public static final int HEIGHT = 63;
    public static final int DIRT_HEIGHT = 66;
    public static final int CAVE_NOISE = 5;
    MiddleEarthMapUtils middleEarthMapUtils;
    MiddleEarthMapRuntime middleEarthMapRuntime;
    private static final int CAVE_STRETCH_H = 60;
    private static final int CAVE_STRETCH_V = 50;
    private static float minNoise = 10000.0f;
    private static float maxNoise = -10000.0f;
    class_7871<class_1959> biomeRegistry;
    public static final Codec<MiddleEarthChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_46636((class_5321)class_7924.field_41236)).apply((Applicative)instance, instance.stable(MiddleEarthChunkGenerator::new)));

    public MiddleEarthChunkGenerator(class_7871<class_1959> biomeRegistry) {
        super((class_1966)new ModBiomeSource(new ArrayList<class_6880.class_6883>(Arrays.asList(biomeRegistry.method_46747(MEBiomeKeys.OCEAN), biomeRegistry.method_46747(MEBiomeKeys.ANDUIN_VALES), biomeRegistry.method_46747(MEBiomeKeys.ANORIEN), biomeRegistry.method_46747(MEBiomeKeys.BARROW_DOWNS), biomeRegistry.method_46747(MEBiomeKeys.BELFALAS), biomeRegistry.method_46747(MEBiomeKeys.BELFALAS_HILLS), biomeRegistry.method_46747(MEBiomeKeys.BLUE_MOUNTAINS), biomeRegistry.method_46747(MEBiomeKeys.BLUE_MOUNTAINS_FOOTHILLS), biomeRegistry.method_46747(MEBiomeKeys.CORSAIR_COASTS), biomeRegistry.method_46747(MEBiomeKeys.DALE), biomeRegistry.method_46747(MEBiomeKeys.DARK_MIRKWOOD), biomeRegistry.method_46747(MEBiomeKeys.DARK_MIRKWOOD_EDGE), biomeRegistry.method_46747(MEBiomeKeys.DARK_ANDUIN_VALES), biomeRegistry.method_46747(MEBiomeKeys.DOL_GULDUR), biomeRegistry.method_46747(MEBiomeKeys.DORWINION), biomeRegistry.method_46747(MEBiomeKeys.DORWINION_HILLS), biomeRegistry.method_46747(MEBiomeKeys.DUNLAND_FOOTHILLS), biomeRegistry.method_46747(MEBiomeKeys.EASTERN_RHOVANION), biomeRegistry.method_46747(MEBiomeKeys.EMYN_MUIL), biomeRegistry.method_46747(MEBiomeKeys.ENEDWAITH), biomeRegistry.method_46747(MEBiomeKeys.LONELY_MOUNTAIN), biomeRegistry.method_46747(MEBiomeKeys.LONELY_MOUNTAIN_FOOTHILLS), biomeRegistry.method_46747(MEBiomeKeys.LONELY_MOUNTAIN_PEAKS), biomeRegistry.method_46747(MEBiomeKeys.EREGION), biomeRegistry.method_46747(MEBiomeKeys.ERIADOR), biomeRegistry.method_46747(MEBiomeKeys.ETHIR_ANDUIN), biomeRegistry.method_46747(MEBiomeKeys.FANGORN), biomeRegistry.method_46747(MEBiomeKeys.FORODWAITH), biomeRegistry.method_46747(MEBiomeKeys.FROZEN_OCEAN), biomeRegistry.method_46747(MEBiomeKeys.FROZEN_POND), biomeRegistry.method_46747(MEBiomeKeys.GONDOR), biomeRegistry.method_46747(MEBiomeKeys.GREY_MOUNTAINS), biomeRegistry.method_46747(MEBiomeKeys.GREY_PLAINS), biomeRegistry.method_46747(MEBiomeKeys.HARAD), biomeRegistry.method_46747(MEBiomeKeys.HARAD_DESERT), biomeRegistry.method_46747(MEBiomeKeys.HARONDOR), biomeRegistry.method_46747(MEBiomeKeys.HILLS_OF_ELVENDIM), biomeRegistry.method_46747(MEBiomeKeys.IRON_HILLS), biomeRegistry.method_46747(MEBiomeKeys.IRON_HILLS_FOOTHILLS), biomeRegistry.method_46747(MEBiomeKeys.IRON_HILLS_FRONTIER), biomeRegistry.method_46747(MEBiomeKeys.ITHILIEN), biomeRegistry.method_46747(MEBiomeKeys.ITHILIEN_WASTES), biomeRegistry.method_46747(MEBiomeKeys.LAMEDON), biomeRegistry.method_46747(MEBiomeKeys.LEBENNIN), biomeRegistry.method_46747(MEBiomeKeys.LINDON), biomeRegistry.method_46747(MEBiomeKeys.LONG_LAKE), biomeRegistry.method_46747(MEBiomeKeys.LORIEN_EDGE), biomeRegistry.method_46747(MEBiomeKeys.LOTHLORIEN), biomeRegistry.method_46747(MEBiomeKeys.OASIS), biomeRegistry.method_46747(MEBiomeKeys.POND), biomeRegistry.method_46747(MEBiomeKeys.MINHIRIATH), biomeRegistry.method_46747(MEBiomeKeys.MIRKWOOD), biomeRegistry.method_46747(MEBiomeKeys.MIRKWOOD_EDGE), biomeRegistry.method_46747(MEBiomeKeys.MIRKWOOD_FOOTHILLS), biomeRegistry.method_46747(MEBiomeKeys.MIRKWOOD_MOUNTAINS), biomeRegistry.method_46747(MEBiomeKeys.MIRKWOOD_SWAMP), biomeRegistry.method_46747(MEBiomeKeys.MISTY_FOOTHILLS), biomeRegistry.method_46747(MEBiomeKeys.MISTY_MOUNTAINS), biomeRegistry.method_46747(MEBiomeKeys.MORDOR), biomeRegistry.method_46747(MEBiomeKeys.MORDOR_MOUNTAINS), biomeRegistry.method_46747(MEBiomeKeys.MORDOR_MOUNTAINS_FOOTHILLS), biomeRegistry.method_46747(MEBiomeKeys.MORDOR_WASTES), biomeRegistry.method_46747(MEBiomeKeys.NINDALF), biomeRegistry.method_46747(MEBiomeKeys.NORTH_DOWNS), biomeRegistry.method_46747(MEBiomeKeys.NORTHERN_DUNLAND), biomeRegistry.method_46747(MEBiomeKeys.NORTHERN_WASTELANDS), biomeRegistry.method_46747(MEBiomeKeys.NURN), biomeRegistry.method_46747(MEBiomeKeys.NURN_RIVER), biomeRegistry.method_46747(MEBiomeKeys.NURN_SEA), biomeRegistry.method_46747(MEBiomeKeys.OCEAN_COAST), biomeRegistry.method_46747(MEBiomeKeys.OLD_ANGMAR), biomeRegistry.method_46747(MEBiomeKeys.OLD_ARTHEDAIN), biomeRegistry.method_46747(MEBiomeKeys.OLD_CARDOLAN), biomeRegistry.method_46747(MEBiomeKeys.OLD_RHUDAUR), biomeRegistry.method_46747(MEBiomeKeys.RHUN), biomeRegistry.method_46747(MEBiomeKeys.RIVENDELL), biomeRegistry.method_46747(MEBiomeKeys.RIVENDELL_FOOTHILLS), biomeRegistry.method_46747(MEBiomeKeys.RIVER), biomeRegistry.method_46747(MEBiomeKeys.ROHAN), biomeRegistry.method_46747(MEBiomeKeys.SEA_OF_RHUN), biomeRegistry.method_46747(MEBiomeKeys.SHIRE), biomeRegistry.method_46747(MEBiomeKeys.SHIRE_EDGE), biomeRegistry.method_46747(MEBiomeKeys.SHIRE_WOODS), biomeRegistry.method_46747(MEBiomeKeys.SOUTHEAST_RHOVANION), biomeRegistry.method_46747(MEBiomeKeys.SOUTHERN_DUNLAND), biomeRegistry.method_46747(MEBiomeKeys.SOUTHERN_FOROCHEL), biomeRegistry.method_46747(MEBiomeKeys.THE_ANGLE), biomeRegistry.method_46747(MEBiomeKeys.THE_OLD_FOREST), biomeRegistry.method_46747(MEBiomeKeys.THE_WOLD), biomeRegistry.method_46747(MEBiomeKeys.TOLFALAS), biomeRegistry.method_46747(MEBiomeKeys.TROLLSHAWS), biomeRegistry.method_46747(MEBiomeKeys.UMBAR), biomeRegistry.method_46747(MEBiomeKeys.WASTE_POND), biomeRegistry.method_46747(MEBiomeKeys.WHITE_MOUNTAINS), biomeRegistry.method_46747(MEBiomeKeys.WHITE_MOUNTAINS_FOOTHILLS), biomeRegistry.method_46747(MEBiomeKeys.WOODLAND_REALM), biomeRegistry.method_46747(MEBiomeKeys.BASIC_CAVE), biomeRegistry.method_46747(MEBiomeKeys.LUSH_CAVE), biomeRegistry.method_46747(MEBiomeKeys.DRIPSTONE_CAVE), biomeRegistry.method_46747(MEBiomeKeys.MUD_CAVE), biomeRegistry.method_46747(MEBiomeKeys.FUNGUS_CAVE), biomeRegistry.method_46747(MEBiomeKeys.MITHRIL_CAVE), biomeRegistry.method_46747(MEBiomeKeys.BASALT_CAVE), biomeRegistry.method_46747(MEBiomeKeys.MAGMA_CAVE), biomeRegistry.method_46747(MEBiomeKeys.DRY_CAVE), biomeRegistry.method_46747(MEBiomeKeys.ICE_CAVE)))));
        this.biomeRegistry = biomeRegistry;
        this.middleEarthMapUtils = MiddleEarthMapUtils.getInstance();
        this.middleEarthMapRuntime = MiddleEarthMapRuntime.getInstance();
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk2, class_2893.class_2894 carverStep) {
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
        int bottomY = chunk.method_31607();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int posX = chunk.method_12004().field_9181 * 16 + x;
                int posZ = chunk.method_12004().field_9180 * 16 + z;
                MEBiome meBiome = null;
                if (this.middleEarthMapUtils.isWorldCoordinateInBorder(posX, posZ)) {
                    class_6880 biome = region.method_23753(new class_2338(posX, chunk.method_31600(), posZ));
                    meBiome = MEBiomesData.getBiomeByKey((class_6880<class_1959>)biome);
                    if (meBiome == null) {
                        meBiome = MEBiomesData.defaultBiome;
                    }
                } else {
                    meBiome = MEBiomesData.defaultBiome;
                }
                float height = MiddleEarthHeightMap.getHeight(posX, posZ);
                float caveBlendNoise = (float)(10.0 * BlendedNoise.noise((double)posX / 24.0, (double)posZ / 24.0) - 5.0);
                chunk.method_12010(chunk.method_12004().method_35231(x, bottomY, z), class_2246.field_9987.method_9564(), false);
                for (y = bottomY + 1; y <= -60; ++y) {
                    chunk.method_12010(chunk.method_12004().method_35231(x, y, z), class_2246.field_10164.method_9564(), false);
                }
                y = bottomY + 1;
                while ((float)y < -32.0f + caveBlendNoise) {
                    this.trySetBlock(chunk, chunk.method_12004().method_35231(x, y, z), StoneBlockSets.EPMOSTO.base().method_9564());
                    ++y;
                }
                if (Math.random() < 0.5) {
                    chunk.method_12010(chunk.method_12004().method_35231(x, chunk.method_31607() + 1, z), class_2246.field_9987.method_9564(), false);
                }
                y = -32 + (int)caveBlendNoise;
                while ((float)y < 0.0f + caveBlendNoise) {
                    this.trySetBlock(chunk, chunk.method_12004().method_35231(x, y, z), StoneBlockSets.DIFTOMIN.base().method_9564());
                    ++y;
                }
                y = 0 + (int)caveBlendNoise;
                while ((float)y < 32.0f + caveBlendNoise) {
                    this.trySetBlock(chunk, chunk.method_12004().method_35231(x, y, z), class_2246.field_28888.method_9564());
                    ++y;
                }
                float dirtHeight = 63.0f + height - 1.0f;
                int y2 = 32 + (int)caveBlendNoise;
                while ((float)y2 < dirtHeight / 2.0f) {
                    this.trySetBlock(chunk, chunk.method_12004().method_35231(x, y2, z), meBiome.stoneBlock.method_9564());
                    ++y2;
                }
                y2 = (int)(dirtHeight / 2.0f);
                while ((float)y2 < dirtHeight) {
                    this.trySetBlock(chunk, chunk.method_12004().method_35231(x, y2, z), meBiome.upperStoneBlock.method_9564());
                    ++y2;
                }
                chunk.method_12010(chunk.method_12004().method_35231(x, (int)(63.0f + height - 1.0f), z), meBiome.stoneBlock.method_9564(), false);
                y2 = (int)(63.0f + height);
                while ((float)y2 < 66.0f + height) {
                    chunk.method_12010(chunk.method_12004().method_35231(x, y2, z), meBiome.underSurfaceBlock.method_9564(), false);
                    ++y2;
                }
                class_2680 surfaceBlock = meBiome.surfaceBlock.method_9564();
                if (66.0f + height < 64.0f && meBiome.surfaceBlock == class_2246.field_10219) {
                    surfaceBlock = class_2246.field_10566.method_9564();
                }
                chunk.method_12010(chunk.method_12004().method_35231(x, (int)(66.0f + height), z), surfaceBlock, false);
                for (int y3 = (int)(66.0f + height + 1.0f); y3 <= 64; ++y3) {
                    chunk.method_12010(chunk.method_12004().method_35231(x, y3, z), class_2246.field_10382.method_9564(), false);
                }
            }
        }
    }

    private void trySetBlock(class_2791 chunk, class_2338 blockPos, class_2680 blockState) {
        float noise = 0.0f;
        if (blockPos.method_10264() < 64) {
            noise = (float)SimplexNoise.noise((float)blockPos.method_10263() / 60.0f, Math.tan((float)blockPos.method_10264() / 50.0f), (float)blockPos.method_10260() / 60.0f);
            noise += 0.5f * (float)SimplexNoise.noise((float)blockPos.method_10263() / 30.0f, (float)blockPos.method_10264() / 25.0f, (float)blockPos.method_10260() / 30.0f);
            noise /= 1.5f;
        }
        float noise3 = (float)SimplexNoise.noise((float)blockPos.method_10263() / 90.0f, (float)blockPos.method_10264() / 60.0f, (float)blockPos.method_10260() / 90.0f);
        float miniNoise = (float)SimplexNoise.noise((float)blockPos.method_10263() / 40.0f, (float)blockPos.method_10264() / 30.0f, (float)blockPos.method_10260() / 40.0f);
        if (noise < 0.4f && noise3 < 0.75f && miniNoise < 0.8f) {
            chunk.method_12010(blockPos, blockState, false);
        }
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        super.method_12102(world, chunk, structureAccessor);
    }

    public void method_12107(class_3233 region) {
        class_1923 chunkPos = region.method_33561();
        class_6880 registryEntry = region.method_23753(chunkPos.method_8323().method_33096(region.method_31600() - 1));
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(class_6673.method_39001()));
        chunkRandom.method_12661(region.method_8412(), chunkPos.method_8326(), chunkPos.method_8328());
        class_1948.method_8661((class_5425)region, (class_6880)registryEntry, (class_1923)chunkPos, (class_5819)chunkRandom);
    }

    public int method_12104() {
        return 384;
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int method_16398() {
        return 64;
    }

    public int method_33730() {
        return -4;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        float worldHeight = 67.0f + MiddleEarthHeightMap.getHeight(x, z);
        return (int)worldHeight;
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        return new class_4966(0, new class_2680[0]);
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }
}

