/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.biomes.surface;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.jukoz.me.world.biomes.BiomeColorsDTO;
import net.jukoz.me.world.biomes.MEBiomeKeys;
import net.jukoz.me.world.biomes.surface.ModBiomeFeatures;
import net.jukoz.me.world.spawners.ModSpawnSettingsBuilder;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_3864;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6796;
import net.minecraft.class_6811;
import net.minecraft.class_6812;
import net.minecraft.class_6816;
import net.minecraft.class_6819;
import net.minecraft.class_7891;
import net.minecraft.class_7924;

public class ModBiomes {
    public static final int defaultSky = 7907327;
    public static final int defaultFog = 12638463;
    public static final int defaultWater = 4159204;
    public static final int defaultWaterFog = 329011;
    public static final int hillySky = 8233727;
    public static final int waterSky = 8103167;
    public static final int nearHaradSky = 7254527;
    public static final int nearHaradSkyFog = 12902399;
    private static List<class_5321<class_6796>> vegetation = new ArrayList<class_5321<class_6796>>();
    private static ArrayList<class_5321<class_6796>> undergroundOres = new ArrayList();

    public static void bootstrap(class_7891<class_1959> context) {
        context.method_46838(MEBiomeKeys.ANDUIN_VALES, (Object)ModBiomes.createAnduinBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 8703593, 8703593)));
        context.method_46838(MEBiomeKeys.ANORIEN, (Object)ModBiomes.createAnorienBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 6799458, 6662221)));
        context.method_46838(MEBiomeKeys.BARROW_DOWNS, (Object)ModBiomes.createBarrowDownsBiome(context, new BiomeColorsDTO(5993621, 7635851, 4812936, 3034721, 6721389, 6525545)));
        context.method_46838(MEBiomeKeys.BELFALAS, (Object)ModBiomes.createBelfalasBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 5951101, 5485154), false));
        context.method_46838(MEBiomeKeys.BELFALAS_HILLS, (Object)ModBiomes.createBelfalasBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 6011255, 5614178), true));
        context.method_46838(MEBiomeKeys.BLUE_MOUNTAINS, (Object)ModBiomes.createBlueMountainsBiome(context, new BiomeColorsDTO(7903952, 12241898, 4159204, 329011, 6791282, 7773545), false));
        context.method_46838(MEBiomeKeys.BLUE_MOUNTAINS_FOOTHILLS, (Object)ModBiomes.createBlueMountainsBiome(context, new BiomeColorsDTO(7905261, 12241911, 4159204, 329011, 7125373, 8703593), true));
        context.method_46838(MEBiomeKeys.CORSAIR_COASTS, (Object)ModBiomes.createCorsairCoastBiome(context, new BiomeColorsDTO(7254527, 12638463, 5212644, 333363, 12107900, 10860366)));
        context.method_46838(MEBiomeKeys.DALE, (Object)ModBiomes.createDaleBiome(context, new BiomeColorsDTO(8230911, 12178175, 4159204, 329011, 6400105, 8703593)));
        context.method_46838(MEBiomeKeys.DARK_ANDUIN_VALES, (Object)ModBiomes.createAnduinBiome(context, new BiomeColorsDTO(7246271, 8951443, 4354703, 1128527, 8032632, 7901046)));
        context.method_46838(MEBiomeKeys.DARK_MIRKWOOD, (Object)ModBiomes.createMirkwoodBiome(context, new BiomeColorsDTO(5269900, 4806731, 4544130, 338483, 4151612, 3823415), true, true));
        context.method_46838(MEBiomeKeys.DARK_MIRKWOOD_EDGE, (Object)ModBiomes.createMirkwoodBiome(context, new BiomeColorsDTO(5861275, 8293250, 4551554, 467756, 4083260, 3690038), false, true));
        context.method_46838(MEBiomeKeys.DOL_GULDUR, (Object)ModBiomes.createMirkwoodBiome(context, new BiomeColorsDTO(3684976, 5065045, 2503248, 462892, 3554356, 3424049), false, true));
        context.method_46838(MEBiomeKeys.DORWINION, (Object)ModBiomes.createDorwinionBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 4631895, 4431186)));
        context.method_46838(MEBiomeKeys.DORWINION_HILLS, (Object)ModBiomes.createDorwinionHillsBiome(context, new BiomeColorsDTO(8233727, 12638463, 4159204, 329011, 9084547, 8427113)));
        context.method_46838(MEBiomeKeys.DUNLAND_FOOTHILLS, (Object)ModBiomes.createDunlandFoothillsBiome(context, new BiomeColorsDTO(7508201, 10863086, 4159204, 329011, 6722387, 6198343)));
        context.method_46838(MEBiomeKeys.EASTERN_RHOVANION, (Object)ModBiomes.createRhunBiome(context, new BiomeColorsDTO(7571933, 12638463, 12440052, 591663, 8627523, 7052347)));
        context.method_46838(MEBiomeKeys.EMYN_MUIL, (Object)ModBiomes.createEmynMuilBiome(context, new BiomeColorsDTO(11715292, 10924223, 4159204, 329011, 8229209, 7899480)));
        context.method_46838(MEBiomeKeys.ENEDWAITH, (Object)ModBiomes.createEnedwaithBiome(context, new BiomeColorsDTO(7181795, 10731509, 4618461, 329011, 8761449, 7842644)));
        context.method_46838(MEBiomeKeys.LONELY_MOUNTAIN, (Object)ModBiomes.createLonelyMountainBiome(context, new BiomeColorsDTO(8233727, 13031679, 4159204, 329011, 7188600, 6529388), 0));
        context.method_46838(MEBiomeKeys.LONELY_MOUNTAIN_FOOTHILLS, (Object)ModBiomes.createLonelyMountainBiome(context, new BiomeColorsDTO(8233727, 12637183, 4159204, 329011, 6927733, 6005862), 1));
        context.method_46838(MEBiomeKeys.LONELY_MOUNTAIN_PEAKS, (Object)ModBiomes.createLonelyMountainBiome(context, new BiomeColorsDTO(8233727, 13031679, 4159204, 329011, 8106628, 6987890), 2));
        context.method_46838(MEBiomeKeys.EREGION, (Object)ModBiomes.createEregionBiome(context, new BiomeColorsDTO(7908853, 11393279, 5077445, 331050, 6858575, 6198343)));
        context.method_46838(MEBiomeKeys.ERIADOR, (Object)ModBiomes.createEriadorBiome(context, new BiomeColorsDTO(7907327, 12637429, 4615389, 658236, 7582562, 6592327)));
        context.method_46838(MEBiomeKeys.ETHIR_ANDUIN, (Object)ModBiomes.createSwampAnduin(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 6400102, 6137428)));
        context.method_46838(MEBiomeKeys.FANGORN, (Object)ModBiomes.createFangornBiome(context, new BiomeColorsDTO(7972607, 12638463, 4293787, 338483, 3559947, 1789719)));
        context.method_46838(MEBiomeKeys.FORODWAITH, (Object)ModBiomes.createForodwaithBiome(context, new BiomeColorsDTO(8364543, 10335206, 3823818, 66852, 0x355343, 0x445548)));
        context.method_46838(MEBiomeKeys.FROZEN_OCEAN, (Object)ModBiomes.createOceanBiome(context, new BiomeColorsDTO(8628223, 10599910, 3750089, 263470, 0x355343, 0x445548)));
        context.method_46838(MEBiomeKeys.FROZEN_POND, (Object)ModBiomes.createFrozenPond(context, new BiomeColorsDTO(8628223, 10599910, 3750089, 263470, 0x355343, 0x445548)));
        context.method_46838(MEBiomeKeys.GONDOR, (Object)ModBiomes.createGondorBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 7582562, 6592327)));
        context.method_46838(MEBiomeKeys.GREY_MOUNTAINS, (Object)ModBiomes.createGreyMountainsBiome(context, new BiomeColorsDTO(8098794, 12701936, 4159204, 329011, 8823414, 9022583)));
        context.method_46838(MEBiomeKeys.GREY_PLAINS, (Object)ModBiomes.createGreyPlainsBiome(context, new BiomeColorsDTO(8233727, 12637179, 4159204, 329011, 5939024, 8566393)));
        context.method_46838(MEBiomeKeys.HARAD, (Object)ModBiomes.createHaradBiome(context, new BiomeColorsDTO(7254527, 12902399, 5407446, 1120828, 12301405, 13356379)));
        context.method_46838(MEBiomeKeys.HARAD_DESERT, (Object)ModBiomes.createHaradDesertBiome(context, new BiomeColorsDTO(7254527, 12902399, 5407446, 1120828, 13419633, 9615182)));
        context.method_46838(MEBiomeKeys.HARONDOR, (Object)ModBiomes.createHarondorBiome(context, new BiomeColorsDTO(7254527, 12902399, 5406149, 1120828, 12305028, 10860366)));
        context.method_46838(MEBiomeKeys.HILLS_OF_ELVENDIM, (Object)ModBiomes.createHillsOfElvendim(context, new BiomeColorsDTO(8233727, 12638463, 4159204, 329011, 9087338, 9218155)));
        context.method_46838(MEBiomeKeys.IRON_HILLS, (Object)ModBiomes.createIronHillsBiome(context, new BiomeColorsDTO(10140415, 13031679, 4159204, 329011, 6922099, 7119988), false));
        context.method_46838(MEBiomeKeys.IRON_HILLS_FOOTHILLS, (Object)ModBiomes.createIronHillsBiome(context, new BiomeColorsDTO(8761343, 12638463, 4159204, 329011, 7187321, 6793328), true));
        context.method_46838(MEBiomeKeys.IRON_HILLS_FRONTIER, (Object)ModBiomes.createIronHillsFrontierBiome(context, new BiomeColorsDTO(8233727, 12637183, 4159204, 329011, 7253882, 7580788)));
        context.method_46838(MEBiomeKeys.ITHILIEN, (Object)ModBiomes.createIthilienBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 5152072, 4889668), false));
        context.method_46838(MEBiomeKeys.ITHILIEN_WASTES, (Object)ModBiomes.createIthilienBiome(context, new BiomeColorsDTO(9085388, 11254223, 4944318, 723757, 5733716, 5537108), true));
        context.method_46838(MEBiomeKeys.LAMEDON, (Object)ModBiomes.createLamedonBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 9162899, 8043898)));
        context.method_46838(MEBiomeKeys.LEBENNIN, (Object)ModBiomes.createLebennin(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 5883985, 7449969)));
        context.method_46838(MEBiomeKeys.LINDON, (Object)ModBiomes.createLindonBiome(context, new BiomeColorsDTO(8827134, 12771327, 4159204, 329011, 6929025, 5157703)));
        context.method_46838(MEBiomeKeys.LONG_LAKE, (Object)ModBiomes.createLakeBiome(context, new BiomeColorsDTO(8103167, 12638463, 4352228, 525619, 7576434, 6588506)));
        context.method_46838(MEBiomeKeys.LORIEN_EDGE, (Object)ModBiomes.createLorienEdgeBiome(context, new BiomeColorsDTO(7907327, 11455105, 4159204, 329011, 10601262, 6202980)));
        context.method_46838(MEBiomeKeys.LOTHLORIEN, (Object)ModBiomes.createLothlorienBiome(context, new BiomeColorsDTO(7907327, 13748853, 4159204, 329011, 12961832, 0x6AA664)));
        context.method_46838(MEBiomeKeys.MINHIRIATH, (Object)ModBiomes.createMinhiriathBiome(context, new BiomeColorsDTO(7907327, 12637429, 4615389, 658236, 8626526, 8231005)));
        context.method_46838(MEBiomeKeys.MIRKWOOD, (Object)ModBiomes.createMirkwoodBiome(context, new BiomeColorsDTO(6849446, 6780008, 4949147, 338483, 4151612, 3823415), true, false));
        context.method_46838(MEBiomeKeys.MIRKWOOD_EDGE, (Object)ModBiomes.createMirkwoodBiome(context, new BiomeColorsDTO(7578800, 7897724, 4293787, 338483, 4546876, 4284215), false, false));
        context.method_46838(MEBiomeKeys.MIRKWOOD_FOOTHILLS, (Object)ModBiomes.createMirkwoodMountainsBiome(context, new BiomeColorsDTO(7575984, 7897724, 4293787, 338483, 4546876, 4284215), true));
        context.method_46838(MEBiomeKeys.MIRKWOOD_MOUNTAINS, (Object)ModBiomes.createMirkwoodMountainsBiome(context, new BiomeColorsDTO(7972607, 9873053, 4293787, 338483, 0x476444, 0x446442), false));
        context.method_46838(MEBiomeKeys.MIRKWOOD_SWAMP, (Object)ModBiomes.createMirkwoodSwampBiome(context, new BiomeColorsDTO(6981536, 8821922, 5080729, 1458241, 4546876, 4284215)));
        context.method_46838(MEBiomeKeys.MISTY_FOOTHILLS, (Object)ModBiomes.createMistyMountainsBiome(context, new BiomeColorsDTO(8233727, 12638463, 4159204, 329011, 7777673, 7316862), true));
        context.method_46838(MEBiomeKeys.MISTY_MOUNTAINS, (Object)ModBiomes.createMistyMountainsBiome(context, new BiomeColorsDTO(9745151, 13426943, 4159204, 329011, 7643011, 7709826), false));
        context.method_46838(MEBiomeKeys.MORDOR, (Object)ModBiomes.createMordorBiome(context, new BiomeColorsDTO(2695203, 1905947, 6450777, 1513734, 3550502, 2169880)));
        context.method_46838(MEBiomeKeys.MORDOR_MOUNTAINS, (Object)ModBiomes.createMordorBiome(context, new BiomeColorsDTO(0x3F3636, 0x2F2727, 6450777, 1513734, 3550502, 2169880)));
        context.method_46838(MEBiomeKeys.MORDOR_MOUNTAINS_FOOTHILLS, (Object)ModBiomes.createMordorBiome(context, new BiomeColorsDTO(3747117, 2629407, 6450777, 1513734, 5129527, 3486247)));
        context.method_46838(MEBiomeKeys.MORDOR_WASTES, (Object)ModBiomes.createMordorWastesBiome(context, new BiomeColorsDTO(0x535050, 0x4C4848, 5860962, 731161, 6252369, 0x484141)));
        context.method_46838(MEBiomeKeys.NINDALF, (Object)ModBiomes.createSwampAnduin(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 6263143, 5869915)));
        context.method_46838(MEBiomeKeys.NORTH_DOWNS, (Object)ModBiomes.createNorthDowns(context, new BiomeColorsDTO(8233727, 12638463, 4159204, 329011, 9414008, 9018483)));
        context.method_46838(MEBiomeKeys.NORTHERN_DUNLAND, (Object)ModBiomes.createNorthDunlandBiome(context, new BiomeColorsDTO(7508201, 12964294, 4159204, 329011, 6722387, 6198343), true));
        context.method_46838(MEBiomeKeys.NORTHERN_WASTELANDS, (Object)ModBiomes.createNorthernWastelands(context, new BiomeColorsDTO(8233727, 12638463, 4159204, 329011, 5932658, 7973008)));
        context.method_46838(MEBiomeKeys.NURN, (Object)ModBiomes.createNurnBiome(context, new BiomeColorsDTO(8954077, 11781331, 5860970, 1321760, 7443043, 6982236)));
        context.method_46838(MEBiomeKeys.NURN_RIVER, (Object)ModBiomes.createNurnWaterBiome(context, new BiomeColorsDTO(8952797, 11779800, 5860963, 863008, 5465422, 0x566B55)));
        context.method_46838(MEBiomeKeys.NURN_SEA, (Object)ModBiomes.createNurnWaterBiome(context, new BiomeColorsDTO(8952797, 11779800, 5860963, 863008, 5465422, 0x566B55)));
        context.method_46838(MEBiomeKeys.OCEAN, (Object)ModBiomes.createOceanBiome(context, new BiomeColorsDTO(8103167, 12638463, 4157145, 329011, 7576434, 6588506)));
        context.method_46838(MEBiomeKeys.OCEAN_COAST, (Object)ModBiomes.createOceanCoastBiome(context, new BiomeColorsDTO(8104447, 12638463, 5145060, 330291, 7971954, 6590810)));
        context.method_46838(MEBiomeKeys.OLD_ANGMAR, (Object)ModBiomes.createOldAngmarBiome(context, new BiomeColorsDTO(8954077, 11781343, 4814544, 460593, 7443043, 6982236)));
        context.method_46838(MEBiomeKeys.OLD_ARTHEDAIN, (Object)ModBiomes.createOldArthedainBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 12508275, 11652468)));
        context.method_46838(MEBiomeKeys.OLD_CARDOLAN, (Object)ModBiomes.createOldCardolanBiome(context, new BiomeColorsDTO(7907327, 12637429, 4615389, 658236, 9154400, 9154400)));
        context.method_46838(MEBiomeKeys.OLD_RHUDAUR, (Object)ModBiomes.createOldRhudaurBiome(context, new BiomeColorsDTO(7508201, 10863086, 4618461, 329011, 6722387, 6198343)));
        context.method_46838(MEBiomeKeys.OASIS, (Object)ModBiomes.createOasisBiome(context, new BiomeColorsDTO(7254527, 12902399, 5407446, 1120828, 7253092, 6592350)));
        context.method_46838(MEBiomeKeys.POND, (Object)ModBiomes.createPondBiome(context, new BiomeColorsDTO(8103167, 12638463, 4290786, 329011, 7583083, 6592339)));
        context.method_46838(MEBiomeKeys.RHUN, (Object)ModBiomes.createRhunBiome(context, new BiomeColorsDTO(8041727, 12773631, 4618980, 329011, 10995507, 7181907)));
        context.method_46838(MEBiomeKeys.RIVENDELL, (Object)ModBiomes.createRivendellBiome(context, new BiomeColorsDTO(9090047, 13426943, 4159204, 329011, 0x78C877, 6858340)));
        context.method_46838(MEBiomeKeys.RIVENDELL_FOOTHILLS, (Object)ModBiomes.createRivendellFoothillsBiome(context, new BiomeColorsDTO(8695029, 12637426, 4159204, 329011, 8569732, 7644782)));
        context.method_46838(MEBiomeKeys.RIVER, (Object)ModBiomes.createRiverBiome(context, new BiomeColorsDTO(8103167, 12638463, 4290790, 329011, 7583083, 6592339)));
        context.method_46838(MEBiomeKeys.ROHAN, (Object)ModBiomes.createRohanBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 10342513, 6918471)));
        context.method_46838(MEBiomeKeys.SEA_OF_RHUN, (Object)ModBiomes.createLakeBiome(context, new BiomeColorsDTO(8103167, 12638463, 4159204, 329011, 10995507, 7181907)));
        context.method_46838(MEBiomeKeys.SHIRE, (Object)ModBiomes.createShireBiome(context, new BiomeColorsDTO(8695029, 12637426, 4159204, 329011, 8704848, 5804821), 0));
        context.method_46838(MEBiomeKeys.SHIRE_EDGE, (Object)ModBiomes.createShireBiome(context, new BiomeColorsDTO(8695029, 12637426, 4159204, 329011, 7978571, 6132766), 1));
        context.method_46838(MEBiomeKeys.SHIRE_WOODS, (Object)ModBiomes.createShireBiome(context, new BiomeColorsDTO(8695029, 12637426, 4159204, 329011, 6662455, 5803292), 2));
        context.method_46838(MEBiomeKeys.SOUTHEAST_RHOVANION, (Object)ModBiomes.createRhunBiome(context, new BiomeColorsDTO(7905517, 11055575, 4159204, 329011, 8950352, 7836758)));
        context.method_46838(MEBiomeKeys.SOUTHERN_DUNLAND, (Object)ModBiomes.createNorthDunlandBiome(context, new BiomeColorsDTO(7508201, 10863086, 4159204, 329011, 8302697, 7252827), false));
        context.method_46838(MEBiomeKeys.SOUTHERN_FOROCHEL, (Object)ModBiomes.createSouthernForochelBiome(context, new BiomeColorsDTO(8233727, 12638463, 4159204, 329011, 7177842, 7971216)));
        context.method_46838(MEBiomeKeys.THE_ANGLE, (Object)ModBiomes.createTheAngleBiome(context, new BiomeColorsDTO(7907327, 12638463, 4615389, 658236, 9878641, 8431193)));
        context.method_46838(MEBiomeKeys.THE_OLD_FOREST, (Object)ModBiomes.createTheOldForestBiome(context, new BiomeColorsDTO(6785744, 10004675, 4421513, 402733, 2311707, 2050588)));
        context.method_46838(MEBiomeKeys.THE_WOLD, (Object)ModBiomes.createRohanBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 12309403, 12242068)));
        context.method_46838(MEBiomeKeys.TOLFALAS, (Object)ModBiomes.createTolfalasBiome(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 10927716, 9615182)));
        context.method_46838(MEBiomeKeys.TROLLSHAWS, (Object)ModBiomes.createTrollshawsBiome(context, new BiomeColorsDTO(6980296, 10402016, 4618461, 329011, 9666387, 9731143)));
        context.method_46838(MEBiomeKeys.UMBAR, (Object)ModBiomes.createUmbarBiome(context, new BiomeColorsDTO(7254527, 12638463, 5212644, 333363, 11059059, 9284946)));
        context.method_46838(MEBiomeKeys.WASTE_POND, (Object)ModBiomes.createWastePondBiome(context, new BiomeColorsDTO(8163746, 10926783, 5860963, 863008, 4020033, 2371608)));
        context.method_46838(MEBiomeKeys.WHITE_MOUNTAINS, (Object)ModBiomes.createWhiteMountainsBiome(context, new BiomeColorsDTO(8233727, 12638463, 4159204, 329011, 7183466, 7513204), false));
        context.method_46838(MEBiomeKeys.WHITE_MOUNTAINS_FOOTHILLS, (Object)ModBiomes.createWhiteMountainsBiome(context, new BiomeColorsDTO(8233727, 12638463, 4159204, 329011, 7185769, 6857066), true));
        context.method_46838(MEBiomeKeys.WOODLAND_REALM, (Object)ModBiomes.createWoodlandRealmBiome(context, new BiomeColorsDTO(8497918, 10666932, 4492967, 471355, 2780195, 2713634)));
    }

    public static class_1959 createAnduinBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addDefaultVegetation(generationSettings);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addFlowerGreenJewel(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addVeryRareBirchTrees(vegetation);
        ModBiomeFeatures.addSparseLarchTrees(vegetation);
        ModBiomeFeatures.addMapleTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createAnorienBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addGondorVegetation(generationSettings);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addTuftGrass(vegetation);
        ModBiomeFeatures.addDioriteBoulder(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        ModBiomeFeatures.addRareLebethronTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createBarrowDownsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addDisks(undergroundOres);
        ModBiomeFeatures.addGravelOre(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createBelfalasBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, boolean hills) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addSwan(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addCornflower(vegetation);
        ModBiomeFeatures.addTuftGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addCalciteBoulder(vegetation);
        ModBiomeFeatures.addWhiteSand(vegetation);
        if (hills) {
            ModBiomes.addNordicVegetation(generationSettings);
            ModBiomeFeatures.addCalciteOre(vegetation);
            ModBiomeFeatures.addDioriteOre(vegetation);
            ModBiomeFeatures.addTuffOre(vegetation);
            ModBiomeFeatures.addGrassStoneOre(vegetation);
            ModBiomeFeatures.addLarchTrees(vegetation);
            ModBiomeFeatures.addPineTrees(vegetation);
            ModBiomeFeatures.addRareSpruceTrees(vegetation);
            ModBiomeFeatures.addSpruceBushes(vegetation);
        } else {
            ModBiomes.addGondorVegetation(generationSettings);
            vegetation.add((class_5321<class_6796>)class_6819.field_36135);
            ModBiomeFeatures.addRareBirchTrees(vegetation);
            ModBiomeFeatures.addRareLebethronTrees(vegetation);
        }
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createBlueMountainsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, boolean foothills) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        float temperature = 0.3f;
        if (foothills) {
            ModBiomes.addNordicVegetation(generationSettings);
            ModBiomeFeatures.addCornflower(vegetation);
            ModBiomeFeatures.addStoneGrassAbundantOre(vegetation);
            ModBiomeFeatures.addCommonLarchTrees(vegetation);
            ModBiomeFeatures.addAbundantPineTrees(vegetation);
            ModBiomeFeatures.addAbundantSpruceTrees(vegetation);
            ModBiomeFeatures.addCommonSpruceBushes(vegetation);
        } else {
            ModBiomeFeatures.addFrozenStone(vegetation);
            temperature = 0.0f;
        }
        ModBiomeFeatures.addBlueTuff(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, temperature, true);
    }

    public static class_1959 createCorsairCoastBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addHaradMobs(spawnSettings);
        ModSpawnSettingsBuilder.addLlama(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addHaradVegetation(generationSettings);
        ModBiomeFeatures.addCoastalFoliage(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36184);
        ModBiomeFeatures.addGraniteBoulder(vegetation);
        ModBiomeFeatures.addSandStoneBoulder(vegetation);
        ModBiomeFeatures.addStoneBoulder(vegetation);
        ModBiomeFeatures.addSandOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addPalmTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createDaleBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addDefaultVegetation(generationSettings);
        ModBiomeFeatures.addCornflower(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomes.addNordicTrees(generationSettings);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createDorwinionBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addGoose(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addFlowerDorwinion(vegetation);
        ModBiomeFeatures.addCornflower(vegetation);
        ModBiomeFeatures.addTuftGrass(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addRareHeather(vegetation);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addWildBeetroot(vegetation);
        ModBiomeFeatures.addWildFlax(vegetation);
        ModBiomeFeatures.addWildLettuce(vegetation);
        ModBiomeFeatures.addWildOnion(vegetation);
        ModBiomeFeatures.addCalciteBoulder(vegetation);
        ModBiomeFeatures.addLimestoneBoulder(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addSparseBirchTrees(vegetation);
        ModBiomeFeatures.addVeryRareMegaOakTrees(vegetation);
        ModBiomeFeatures.addMegaBirchTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createDorwinionHillsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomeFeatures.addTuffOre(vegetation);
        ModBiomeFeatures.addCalciteOre(vegetation);
        ModBiomeFeatures.addDioriteOre(vegetation);
        ModBiomeFeatures.addLimestoneOre(vegetation);
        ModBiomeFeatures.addStoneGrassAbundantOre(vegetation);
        ModBiomeFeatures.addCommonOakBush(vegetation);
        ModBiomeFeatures.addBirchTrees(vegetation);
        ModBiomeFeatures.addLarchTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createDunlandFoothillsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addDolomiteOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addPodzolOre(vegetation);
        ModBiomeFeatures.addStoneGrassOre(vegetation);
        ModBiomeFeatures.addTuffOre(vegetation);
        ModBiomeFeatures.addCommonLarchTrees(vegetation);
        ModBiomeFeatures.addAbundantPineTrees(vegetation);
        ModBiomeFeatures.addAbundantSpruceTrees(vegetation);
        ModBiomeFeatures.addCommonSpruceBushes(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createEmynMuilBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addRabbits(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        ModBiomeFeatures.addStoneBoulder(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addStoneGrassOre(vegetation);
        ModBiomeFeatures.addTerracottaOre(vegetation);
        ModBiomeFeatures.addTuffOre(vegetation);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addTuftGrass(vegetation);
        ModBiomeFeatures.addCommonOakBush(vegetation);
        ModBiomeFeatures.addGraniteBoulder(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createEnedwaithBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addEriadorMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addDefaultVegetation(generationSettings);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addRareHeather(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createLonelyMountainBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, int step) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        float temperature = 0.4f;
        if (step == 0) {
            ModBiomeFeatures.addStoneGrassAbundantOre(vegetation);
            ModBiomeFeatures.addCoarseDirtOre(vegetation);
            ModBiomes.addNordicVegetation(generationSettings);
            ModBiomeFeatures.addCommonLarchTrees(vegetation);
            ModBiomeFeatures.addAbundantPineTrees(vegetation);
            ModBiomeFeatures.addAbundantSpruceTrees(vegetation);
            ModBiomeFeatures.addCommonSpruceBushes(vegetation);
        } else if (step == 1) {
            ModBiomeFeatures.addStoneGrassOre(vegetation);
            ModBiomeFeatures.addDolomiteOre(vegetation);
            ModBiomeFeatures.addLarchTrees(vegetation);
            ModBiomeFeatures.addPineTrees(vegetation);
            ModBiomeFeatures.addCommonSpruceTrees(vegetation);
            vegetation.add((class_5321<class_6796>)class_6819.field_36183);
            vegetation.add((class_5321<class_6796>)class_6819.field_36171);
            vegetation.add((class_5321<class_6796>)class_6819.field_36179);
        } else {
            ModBiomeFeatures.addDolomiteOre(vegetation);
            ModBiomeFeatures.addFrozenStone(vegetation);
            temperature = 0.0f;
        }
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addAbundantTuffOre(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, temperature, true);
    }

    public static class_1959 createEregionBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        ModSpawnSettingsBuilder.addDeer(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addDefaultVegetation(generationSettings);
        ModBiomeFeatures.addForestMoss(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addPodzolOre(vegetation);
        ModBiomeFeatures.addBirchTrees(vegetation);
        ModBiomeFeatures.addBeechTrees(vegetation);
        ModBiomeFeatures.addLarchTrees(vegetation);
        ModBiomeFeatures.addOakTrees(vegetation);
        ModBiomeFeatures.addRareMegaOakTrees(vegetation);
        ModBiomeFeatures.addPineTrees(vegetation);
        ModBiomeFeatures.addSpruceTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createEriadorBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addEriadorMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addEriadorVegetation(generationSettings);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addRareHeather(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addRareBirchTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createSwampAnduin(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        vegetation.add((class_5321<class_6796>)class_6819.field_36131);
        vegetation.add((class_5321<class_6796>)class_6819.field_36114);
        ModBiomeFeatures.addWaterDelta(vegetation);
        ModBiomeFeatures.addAbundantMudOre(vegetation);
        ModBiomeFeatures.addPackedMudOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addReedsFoliage(vegetation);
        ModBiomeFeatures.addWheatGrass(vegetation);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addOakVinesTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createFangornBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addDefaultVegetation(generationSettings);
        vegetation.add((class_5321<class_6796>)class_6819.field_36181);
        ModBiomeFeatures.addMossyBoulder(vegetation);
        ModBiomeFeatures.addForestMoss(vegetation);
        ModBiomeFeatures.addForestBlockMoss(vegetation);
        ModBiomeFeatures.addOldPodzolOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addRareMorsel(vegetation);
        ModBiomeFeatures.addRareWhiteMushroom(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addMegaBirchCommonTrees(vegetation);
        ModBiomeFeatures.addMegaDarkOakCommonTrees(vegetation);
        ModBiomeFeatures.addMegaOakCommonTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createForodwaithBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addForochelMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addForodwaithVegetation(generationSettings);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, -0.8f, true);
    }

    public static class_1959 createGondorBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addGondorVegetation(generationSettings);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addDioriteBoulder(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addRareLebethronTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createGreyMountainsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addStoneGrassOre(vegetation);
        ModBiomeFeatures.addAshBlockOre(vegetation);
        ModBiomeFeatures.addSmoothBasaltOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addAbundantTuffOre(vegetation);
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomes.addNordicTrees(generationSettings);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createGreyPlainsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addRareForestMoss(vegetation);
        ModBiomeFeatures.addSparseLarchTrees(vegetation);
        ModBiomeFeatures.addSparsePineTrees(vegetation);
        ModBiomeFeatures.addRareSpruceTrees(vegetation);
        ModBiomeFeatures.addSpruceBushes(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createHaradBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addHaradMobs(spawnSettings);
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addHaradVegetation(generationSettings);
        ModBiomeFeatures.addSandOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addAcaciaTrees(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36175);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createHarondorBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addHaradMobs(spawnSettings);
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addHaradVegetation(generationSettings);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addSandOre(vegetation);
        ModBiomeFeatures.addSandStoneBoulder(vegetation);
        ModBiomeFeatures.addStoneBoulder(vegetation);
        ModBiomeFeatures.addWildFlax(vegetation);
        ModBiomeFeatures.addVeryRareBirchTrees(vegetation);
        ModBiomeFeatures.addVeryRareBeechTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createHaradDesertBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addHaradMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addHaradDesertVegetation(generationSettings);
        vegetation.add((class_5321<class_6796>)class_6819.field_36174);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.8f, false);
    }

    public static class_1959 createHillsOfElvendim(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addGrassStoneOre(vegetation);
        ModBiomeFeatures.addAbundantTuffOre(vegetation);
        ModBiomes.addArthedainVegetation(generationSettings);
        ModBiomeFeatures.addCommonLarchTrees(vegetation);
        ModBiomeFeatures.addPineTrees(vegetation);
        ModBiomeFeatures.addSpruceTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createIronHillsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, boolean foothills) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        if (foothills) {
            ModBiomeFeatures.addGrassStoneOre(vegetation);
            ModBiomeFeatures.addCornflower(vegetation);
        } else {
            ModBiomeFeatures.addStoneGrassOre(vegetation);
        }
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addAbundantTuffOre(vegetation);
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomes.addNordicTrees(generationSettings);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createIronHillsFrontierBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addCornflower(vegetation);
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomes.addNordicTrees(generationSettings);
        ModBiomeFeatures.addSpruceBushes(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createIthilienBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, boolean wastes) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addDeer(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addForestMoss(vegetation);
        ModBiomeFeatures.addForestBlockMoss(vegetation);
        ModBiomeFeatures.addRareMorsel(vegetation);
        ModBiomeFeatures.addRareWhiteMushroom(vegetation);
        ModBiomeFeatures.addMossyBoulder(vegetation);
        ModBiomeFeatures.addCommonOakBush(vegetation);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addDioriteBoulder(vegetation);
        ModBiomeFeatures.addOakTrees(vegetation);
        ModBiomes.addGondorVegetation(generationSettings);
        if (!wastes) {
            ModBiomeFeatures.addFlowerGreenJewel(vegetation);
            ModBiomeFeatures.addWilderGrass(vegetation);
            ModBiomeFeatures.addBeechTrees(vegetation);
            ModBiomeFeatures.addBirchTrees(vegetation);
            ModBiomeFeatures.addCommonLebethronTrees(vegetation);
            ModBiomeFeatures.addMegaOakTrees(vegetation);
            ModBiomeFeatures.addSparsePineTrees(vegetation);
        } else {
            ModBiomeFeatures.addCommonToughBerries(undergroundOres);
            ModBiomeFeatures.addAshenDirtOre(undergroundOres);
            ModBiomeFeatures.addRareBeechTrees(vegetation);
            ModBiomeFeatures.addRareBirchTrees(vegetation);
            ModBiomeFeatures.addLebethronTrees(vegetation);
            ModBiomeFeatures.addDeadPineTrees(vegetation);
        }
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createLamedonBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addGondorVegetation(generationSettings);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addRareCalciteOre(vegetation);
        ModBiomeFeatures.addCalciteBoulder(vegetation);
        ModBiomeFeatures.addDioriteBoulder(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addVeryRareBirchTrees(vegetation);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addRareLebethronTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createLebennin(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addGondorVegetation(generationSettings);
        ModBiomeFeatures.addLebenninFlowers(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addCalciteBoulder(vegetation);
        ModBiomeFeatures.addDioriteBoulder(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addVeryRareBirchTrees(vegetation);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addRareOakTrees(vegetation);
        ModBiomeFeatures.addRareLebethronTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createLindonBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addDefaultVegetation(generationSettings);
        ModBiomeFeatures.addCornflower(vegetation);
        ModBiomeFeatures.addRareForestMoss(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addLimestoneBoulder(vegetation);
        ModBiomeFeatures.addWhiteSand(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addRareBirchTrees(vegetation);
        ModBiomeFeatures.addMegaBirchTrees(vegetation);
        ModBiomeFeatures.addRareMegaOakTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createLorienEdgeBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        ModSpawnSettingsBuilder.addSwan(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addLothlorienVegetation(generationSettings);
        ModBiomeFeatures.addMallornTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createLothlorienBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        ModSpawnSettingsBuilder.addSwan(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addLothlorienVegetation(generationSettings);
        ModBiomeFeatures.addSmallMallornTress(vegetation);
        ModBiomeFeatures.addOakTrees(vegetation);
        ModBiomeFeatures.addSparseBirchTrees(vegetation);
        ModBiomeFeatures.addMegaMallornTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createMinhiriathBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addEriadorMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addEriadorVegetation(generationSettings);
        ModBiomeFeatures.addAndesiteBoulder(vegetation);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addTuftGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addWheatGrass(vegetation);
        ModBiomeFeatures.addCommonOakBush(vegetation);
        ModBiomeFeatures.addWildCarrot(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createMirkwoodBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, boolean bigTrees, boolean dark) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addWolves(spawnSettings);
        if (!dark) {
            ModSpawnSettingsBuilder.addDeer(spawnSettings);
        }
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addMirkwoodVegetation(generationSettings);
        ModBiomeFeatures.addMirkwoodRoots(vegetation);
        ModBiomeFeatures.addMudOre(vegetation);
        ModBiomeFeatures.addRareMorsel(vegetation);
        ModBiomeFeatures.addRareWhiteMushroom(vegetation);
        if (bigTrees) {
            ModBiomes.addMegaMirkwoodTrees(generationSettings);
            ModBiomeFeatures.addSmallMirkwoodTrees(vegetation);
            ModBiomeFeatures.addCorruptedMoss(vegetation);
        } else {
            ModBiomes.addMirkwoodTrees(generationSettings);
            if (!dark) {
                ModBiomeFeatures.addForestMoss(vegetation);
                ModBiomeFeatures.addForestBlockMoss(vegetation);
            }
        }
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createMirkwoodMountainsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, boolean foothill) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addGraniteBoulder(vegetation);
        float temperature = 0.3f;
        if (foothill) {
            ModBiomes.addMirkwoodVegetation(generationSettings);
            ModBiomeFeatures.addSmallMirkwoodTrees(vegetation);
            ModBiomeFeatures.addGrassStoneOre(vegetation);
            ModBiomeFeatures.addGravelOre(vegetation);
            ModBiomeFeatures.addForestMoss(vegetation);
            ModBiomeFeatures.addMirkwoodRoots(vegetation);
            ModBiomeFeatures.addMudOre(vegetation);
            ModBiomeFeatures.addRareMorsel(vegetation);
            ModBiomeFeatures.addRareWhiteMushroom(vegetation);
        } else {
            temperature = 0.0f;
            ModBiomeFeatures.addGraniteOre(vegetation);
            ModBiomeFeatures.addDripstoneOre(vegetation);
            ModBiomeFeatures.addTuffOre(vegetation);
        }
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, temperature, true);
    }

    public static class_1959 createMirkwoodSwampBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addSwampMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addMirkwoodVegetation(generationSettings);
        ModBiomeFeatures.addWaterDelta(vegetation);
        ModBiomeFeatures.addForestMoss(vegetation);
        ModBiomeFeatures.addReedsFoliage(vegetation);
        ModBiomeFeatures.addWheatGrass(vegetation);
        ModBiomeFeatures.addMudOre(vegetation);
        ModBiomes.addMirkwoodTrees(generationSettings);
        ModBiomeFeatures.addWillowTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createMistyMountainsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, boolean foothills) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        float temperature = -0.6f;
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomeFeatures.addDolomiteOre(vegetation);
        ModBiomeFeatures.addTuffOre(vegetation);
        if (foothills) {
            temperature = 0.2f;
            ModBiomeFeatures.addCoarseDirtOre(vegetation);
            ModBiomeFeatures.addGravelOre(vegetation);
            ModBiomeFeatures.addStoneGrassOre(vegetation);
            ModBiomeFeatures.addCommonLarchTrees(vegetation);
            ModBiomeFeatures.addAbundantPineTrees(vegetation);
            ModBiomeFeatures.addAbundantSpruceTrees(vegetation);
            ModBiomeFeatures.addCommonSpruceBushes(vegetation);
        } else {
            ModBiomeFeatures.addPowderSnowOre(vegetation);
        }
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, temperature, true);
    }

    public static class_1959 createMordorBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addMordorVegetation(generationSettings);
        ModBiomeFeatures.addAshenDirtStoneOre(vegetation);
        ModBiomeFeatures.addLavaMagmaLake(generationSettings);
        ModBiomeFeatures.addBasaltPile(vegetation);
        ModBiomeFeatures.addBlackStonePile(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.7f, false);
    }

    public static class_1959 createMordorWastesBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addMordorVegetation(generationSettings);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addMudOre(vegetation);
        ModBiomeFeatures.addAshenDirtOre(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createNorthDowns(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addGrassStoneOre(vegetation);
        ModBiomeFeatures.addAbundantTuffOre(vegetation);
        ModBiomes.addEriadorVegetation(generationSettings);
        ModBiomeFeatures.addLarchTrees(vegetation);
        ModBiomeFeatures.addPineTrees(vegetation);
        ModBiomeFeatures.addSpruceTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createNorthDunlandBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, boolean trees) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        ModSpawnSettingsBuilder.addWolves(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addSpruceBushes(vegetation);
        if (trees) {
            ModBiomeFeatures.addForestMoss(vegetation);
            ModBiomeFeatures.addBirchTrees(vegetation);
            ModBiomeFeatures.addLarchTrees(vegetation);
            ModBiomeFeatures.addOakTrees(vegetation);
            ModBiomeFeatures.addCommonPineTrees(vegetation);
            ModBiomeFeatures.addSpruceTrees(vegetation);
        } else {
            ModBiomeFeatures.addLarchTrees(vegetation);
            ModBiomeFeatures.addSparsePineTrees(vegetation);
            ModBiomeFeatures.addRareSpruceTrees(vegetation);
        }
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createNorthernWastelands(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        vegetation.add((class_5321<class_6796>)class_6819.field_36171);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36179);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addAndesiteBoulder(vegetation);
        ModBiomeFeatures.addSparseLarchTrees(vegetation);
        ModBiomeFeatures.addSparsePineTrees(vegetation);
        ModBiomeFeatures.addRareSpruceTrees(vegetation);
        ModBiomeFeatures.addSpruceBushes(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, -0.1f, true);
    }

    public static class_1959 createNurnBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addDefaultVegetation(generationSettings);
        ModBiomeFeatures.addToughBerries(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addAshenDirtOre(vegetation);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addDyingGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        ModBiomeFeatures.addVeryRareBeechTrees(vegetation);
        ModBiomeFeatures.addRareBirchTrees(vegetation);
        ModBiomeFeatures.addVeryRareMegaOakTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createNurnWaterBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addSwampMobs(spawnSettings);
        ModSpawnSettingsBuilder.addRiverAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addOceanVegetation(generationSettings);
        ModBiomeFeatures.addMudOre(vegetation);
        ModBiomeFeatures.addWillowTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createOldAngmarBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36183);
        vegetation.add((class_5321<class_6796>)class_6819.field_36171);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36179);
        ModBiomeFeatures.addAndesiteBoulder(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addBrownBolete(vegetation);
        ModBiomeFeatures.addMorsel(vegetation);
        ModBiomeFeatures.addWhiteMushroom(vegetation);
        ModBiomeFeatures.addToughBerriesRare(vegetation);
        ModBiomeFeatures.addAshBlockOre(vegetation);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addDyingGrass(vegetation);
        ModBiomeFeatures.addRareForestMoss(vegetation);
        ModBiomeFeatures.addDeadPineTrees(vegetation);
        ModBiomeFeatures.addSparsePineTrees(vegetation);
        ModBiomeFeatures.addScarceSpruceTrees(vegetation);
        ModBiomeFeatures.addSpruceBushes(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.35f, true);
    }

    public static class_1959 createOldArthedainBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addEriadorMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addArthedainVegetation(generationSettings);
        ModBiomeFeatures.addOakBushes(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        ModBiomeFeatures.addVeryRareBeechTrees(vegetation);
        ModBiomeFeatures.addVeryRareBirchTrees(vegetation);
        ModBiomeFeatures.addVeryRareMegaOakTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createOldCardolanBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addEriadorMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addEriadorVegetation(generationSettings);
        vegetation.add((class_5321<class_6796>)class_6819.field_36179);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addRareHeather(vegetation);
        ModBiomeFeatures.addRedHeather(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addStoneBoulder(vegetation);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addRareBirchTrees(vegetation);
        ModBiomeFeatures.addOakTrees(vegetation);
        ModBiomeFeatures.addSparsePineTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createOldRhudaurBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addWolves(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomeFeatures.addForestMoss(vegetation);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addPodzolOre(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addSparseLarchTrees(vegetation);
        ModBiomeFeatures.addDeadPineTrees(vegetation);
        ModBiomeFeatures.addSparsePineTrees(vegetation);
        ModBiomeFeatures.addSpruceTrees(vegetation);
        ModBiomeFeatures.addSpruceBushes(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createRhunBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addRhunVegetation(generationSettings);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addRareBirchTrees(vegetation);
        ModBiomeFeatures.addOakTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createRivendellBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addRivendellVegetation(generationSettings);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addSparseBirchTrees(vegetation);
        ModBiomeFeatures.addVeryRareMegaOakTrees(vegetation);
        ModBiomeFeatures.addMegaBirchTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createRivendellFoothillsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomeFeatures.addDolomiteOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addLimestoneOre(vegetation);
        ModBiomeFeatures.addStoneGrassAbundantOre(vegetation);
        ModBiomeFeatures.addTuffOre(vegetation);
        ModBiomeFeatures.addSparseBirchTrees(vegetation);
        ModBiomeFeatures.addLarchTrees(vegetation);
        ModBiomeFeatures.addCommonPineTrees(vegetation);
        ModBiomeFeatures.addCommonSpruceTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.4f, true);
    }

    public static class_1959 createRohanBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addPlainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addDefaultVegetation(generationSettings);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addGraniteBoulder(vegetation);
        ModBiomeFeatures.addFlowerGreenJewel(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createShireBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, int step) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addShireVegetation(generationSettings);
        if (step < 2) {
            ModSpawnSettingsBuilder.addEriadorMobs(spawnSettings);
            ModSpawnSettingsBuilder.addGoose(spawnSettings);
            ModBiomeFeatures.addFlowerGreenJewel(vegetation);
            ModBiomeFeatures.addRareBeechTrees(vegetation);
            ModBiomeFeatures.addRareBirchTrees(vegetation);
            vegetation.add((class_5321<class_6796>)class_6819.field_36135);
            if (step == 1) {
                ModBiomeFeatures.addOakTrees(vegetation);
            } else {
                ModBiomeFeatures.addStrawberries(vegetation);
            }
            ModBiomeFeatures.addVeryRareMegaOakTrees(vegetation);
        } else {
            ModSpawnSettingsBuilder.addDeer(spawnSettings);
            ModBiomeFeatures.addMossyBoulder(vegetation);
            ModBiomeFeatures.addForestMoss(vegetation);
            ModBiomeFeatures.addForestBlockMoss(vegetation);
            ModBiomeFeatures.addCoarseDirtOre(vegetation);
            ModBiomeFeatures.addPodzolOre(vegetation);
            ModBiomeFeatures.addRareMorsel(vegetation);
            vegetation.add((class_5321<class_6796>)class_6819.field_36135);
            ModBiomeFeatures.addBeechTrees(vegetation);
            ModBiomeFeatures.addBirchTrees(vegetation);
            ModBiomeFeatures.addMegaDarkOakTrees(vegetation);
            ModBiomeFeatures.addOakBushes(vegetation);
            ModBiomeFeatures.addOakTrees(vegetation);
            ModBiomeFeatures.addPineTrees(vegetation);
            ModBiomeFeatures.addVeryRareSpruceTrees(vegetation);
            ModBiomeFeatures.addMegaBirchTrees(vegetation);
            ModBiomeFeatures.addMegaOakCommonTrees(vegetation);
        }
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createSouthernForochelBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addNordicMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addSparsePineTrees(vegetation);
        ModBiomeFeatures.addRareSpruceTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, -0.4f, true);
    }

    public static class_1959 createTheAngleBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addEriadorMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addEriadorVegetation(generationSettings);
        ModBiomeFeatures.addRareHeather(vegetation);
        ModBiomeFeatures.addRareForestMoss(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addRareBeechTrees(vegetation);
        ModBiomeFeatures.addVeryRareBirchTrees(vegetation);
        ModBiomeFeatures.addSparseLarchTrees(vegetation);
        ModBiomeFeatures.addVeryRareSpruceTrees(vegetation);
        ModBiomeFeatures.addMapleTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createTheOldForestBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addDeer(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addEriadorVegetation(generationSettings);
        vegetation.add((class_5321<class_6796>)class_6819.field_36181);
        vegetation.add((class_5321<class_6796>)class_6819.field_36165);
        ModBiomeFeatures.addMossyBoulder(vegetation);
        ModBiomeFeatures.addForestMoss(vegetation);
        ModBiomeFeatures.addForestBlockMoss(vegetation);
        ModBiomeFeatures.addOldPodzolOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addRareMorsel(vegetation);
        ModBiomeFeatures.addRareWhiteMushroom(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addMegaBirchCommonTrees(vegetation);
        ModBiomeFeatures.addMegaDarkOakCommonTrees(vegetation);
        ModBiomeFeatures.addMegaOakCommonTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createTolfalasBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addDefaultVegetation(generationSettings);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addGrassStoneOre(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addSparseLarchTrees(vegetation);
        ModBiomeFeatures.addRareLebethronTrees(vegetation);
        ModBiomeFeatures.addSparsePineTrees(vegetation);
        ModBiomeFeatures.addRareSpruceTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createTrollshawsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        ModSpawnSettingsBuilder.addDeer(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addEriadorVegetation(generationSettings);
        vegetation.add((class_5321<class_6796>)class_6819.field_36183);
        vegetation.add((class_5321<class_6796>)class_6819.field_36171);
        ModBiomeFeatures.addDyingGrass(vegetation);
        ModBiomeFeatures.addForestMoss(vegetation);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addPodzolOre(vegetation);
        ModBiomeFeatures.addRareMorsel(vegetation);
        ModBiomeFeatures.addCommonOakBush(vegetation);
        ModBiomeFeatures.addCommonBeechTrees(vegetation);
        ModBiomeFeatures.addCommonOakTrees(vegetation);
        ModBiomeFeatures.addRareMegaOakTrees(vegetation);
        ModBiomeFeatures.addPineTrees(vegetation);
        ModBiomeFeatures.addSpruceTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createUmbarBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addHaradMobs(spawnSettings);
        ModSpawnSettingsBuilder.addFarmAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addHaradVegetation(generationSettings);
        ModBiomeFeatures.addGraniteBoulder(vegetation);
        ModBiomeFeatures.addWildFlax(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createRiverBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addRiverAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addRiverDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6811.field_35977);
        vegetation.add((class_5321<class_6796>)class_6811.field_35968);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addReedsFoliage(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createLakeBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addRiverAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addOceanVegetation(generationSettings);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createOasisBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addRiverAnimals(spawnSettings);
        ModSpawnSettingsBuilder.addCamel(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addOasisVegetation(generationSettings);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createWastePondBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addRiverAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6811.field_35978);
        vegetation.add((class_5321<class_6796>)class_6811.field_35968);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        ModBiomeFeatures.addReedsFoliage(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createWhiteMountainsBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors, boolean foothills) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addMountainsMobs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addNordicVegetation(generationSettings);
        ModBiomeFeatures.addCalciteOre(vegetation);
        ModBiomeFeatures.addDioriteOre(vegetation);
        ModBiomeFeatures.addTuffOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        float temperature = 0.1f;
        if (foothills) {
            temperature = 0.35f;
            ModBiomeFeatures.addGrassStoneOre(vegetation);
            ModBiomeFeatures.addLarchTrees(vegetation);
            ModBiomeFeatures.addPineTrees(vegetation);
            ModBiomeFeatures.addScarceSpruceTrees(vegetation);
            ModBiomeFeatures.addSpruceBushes(vegetation);
        } else {
            ModBiomeFeatures.addSnowOre(vegetation);
            ModBiomeFeatures.addCalciteStoneOre(vegetation);
        }
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, temperature, true);
    }

    public static class_1959 createWoodlandRealmBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addWolves(spawnSettings);
        ModSpawnSettingsBuilder.addDeer(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addMirkwoodVegetation(generationSettings);
        ModBiomeFeatures.addForestMoss(vegetation);
        ModBiomeFeatures.addFlowerGreenJewel(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addLimestoneBoulder(vegetation);
        vegetation.add((class_5321<class_6796>)class_6819.field_36137);
        ModBiomeFeatures.addRareMorsel(vegetation);
        ModBiomes.addMirkwoodTrees(generationSettings);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createOceanBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addOceanAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addOceanVegetation(generationSettings);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createOceanCoastBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addOceanAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addOceanVegetation(generationSettings);
        ModBiomeFeatures.addCoastalFoliage(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createPondBiome(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addRiverAnimals(spawnSettings);
        ModSpawnSettingsBuilder.addDuck(spawnSettings);
        ModSpawnSettingsBuilder.addGoose(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomes.addOceanVegetation(generationSettings);
        ModBiomeFeatures.addRiverSand(undergroundOres);
        ModBiomeFeatures.addWillowTrees(vegetation);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings);
    }

    public static class_1959 createFrozenPond(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModSpawnSettingsBuilder.addOceanAnimals(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6811.field_35977);
        vegetation.add((class_5321<class_6796>)class_6811.field_35968);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, -0.1f, true);
    }

    public static void addNordicTrees(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addLarchTrees(vegetation);
        ModBiomeFeatures.addSparsePineTrees(vegetation);
        ModBiomeFeatures.addRareSpruceTrees(vegetation);
    }

    public static void addMirkwoodTrees(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addMirkwoodTrees(vegetation);
    }

    public static void addMegaMirkwoodTrees(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addMegaMirkwoodTrees(vegetation);
    }

    public static void addDefaultVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addStoneBoulder(vegetation);
        ModBiomeFeatures.addWildBeetroot(vegetation);
        ModBiomeFeatures.addWildCucumber(vegetation);
        ModBiomeFeatures.addWildFlax(vegetation);
        ModBiomeFeatures.addWildGarlic(vegetation);
    }

    public static void addArthedainVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36169);
        vegetation.add((class_5321<class_6796>)class_6819.field_36181);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addHeather(vegetation);
        ModBiomeFeatures.addHeatherBush(vegetation);
        ModBiomeFeatures.addWheatGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addWildGarlic(vegetation);
        ModBiomeFeatures.addWildLeek(vegetation);
        ModBiomeFeatures.addWildLettuce(vegetation);
        ModBiomeFeatures.addWildPotato(vegetation);
        ModBiomeFeatures.addStoneBoulder(vegetation);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
    }

    public static void addEriadorVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        ModBiomeFeatures.addFlowerGreenJewel(vegetation);
        ModBiomeFeatures.addWildFlax(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addWildLeek(vegetation);
        ModBiomeFeatures.addWildLettuce(vegetation);
        ModBiomeFeatures.addWildOnion(vegetation);
        ModBiomeFeatures.addGraniteBoulder(vegetation);
    }

    public static void addForodwaithVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        ModBiomeFeatures.addToughBerriesRare(vegetation);
    }

    public static void addGondorVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addWildCarrot(vegetation);
        ModBiomeFeatures.addWildOnion(vegetation);
        ModBiomeFeatures.addWildGarlic(vegetation);
        ModBiomeFeatures.addWildFlax(vegetation);
    }

    public static void addHaradVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36168);
        vegetation.add((class_5321<class_6796>)class_6819.field_36182);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        ModBiomeFeatures.addHaradFoliage(vegetation);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addWildBellPepper(vegetation);
        ModBiomeFeatures.addWildTomato(vegetation);
    }

    public static void addHaradDesertVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36168);
        ModBiomeFeatures.addDryGrass(vegetation);
        ModBiomeFeatures.addSandStoneBoulder(vegetation);
    }

    public static void addLothlorienVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36133);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addDryDirtOre(vegetation);
        ModBiomeFeatures.addLimestoneBoulder(vegetation);
        ModBiomeFeatures.addTuftGrass(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addMallornBushes(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addMallos(vegetation);
        ModBiomeFeatures.addWildCarrot(vegetation);
        ModBiomeFeatures.addWildFlax(vegetation);
        ModBiomeFeatures.addWildLettuce(vegetation);
        ModBiomeFeatures.addWildOnion(vegetation);
    }

    public static void addMirkwoodVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36181);
        vegetation.add((class_5321<class_6796>)class_6819.field_36183);
        vegetation.add((class_5321<class_6796>)class_6819.field_36171);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36179);
        ModBiomeFeatures.addCoarseDirtOre(vegetation);
        ModBiomeFeatures.addOldPodzolOre(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addOakBushes(vegetation);
        ModBiomeFeatures.addWildFlax(vegetation);
        ModBiomeFeatures.addWildGarlic(vegetation);
        ModBiomeFeatures.addWildOnion(vegetation);
        ModBiomeFeatures.addMossyBoulder(vegetation);
    }

    public static void addMordorVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        ModBiomeFeatures.addMordorLichen(vegetation);
        ModBiomeFeatures.addAshBlockOre(vegetation);
        ModBiomeFeatures.addBasaltOre(vegetation);
        ModBiomeFeatures.addBlackSand(vegetation);
        ModBiomeFeatures.addCommonToughBerries(vegetation);
    }

    public static void addNordicVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36183);
        vegetation.add((class_5321<class_6796>)class_6819.field_36171);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36179);
        ModBiomeFeatures.addAndesiteBoulder(vegetation);
        ModBiomeFeatures.addWildGrass(vegetation);
        ModBiomeFeatures.addBrownBolete(vegetation);
        ModBiomeFeatures.addMorsel(vegetation);
        ModBiomeFeatures.addWhiteMushroom(vegetation);
        ModBiomeFeatures.addWildBeetroot(vegetation);
        ModBiomeFeatures.addWildPotato(vegetation);
    }

    public static void addOasisVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6811.field_35978);
        vegetation.add((class_5321<class_6796>)class_6811.field_35967);
        vegetation.add((class_5321<class_6796>)class_6819.field_36168);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addHaradFoliage(vegetation);
        ModBiomeFeatures.addWildBellPepper(vegetation);
        ModBiomeFeatures.addWildTomato(vegetation);
    }

    public static void addOceanVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6811.field_35977);
        vegetation.add((class_5321<class_6796>)class_6811.field_35968);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addReedsFoliage(vegetation);
    }

    public static void addRivendellVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addFlowerMeadow(vegetation);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addWhiteSand(vegetation);
        ModBiomeFeatures.addWildLeek(vegetation);
        ModBiomeFeatures.addWildLettuce(vegetation);
        ModBiomeFeatures.addWildOnion(vegetation);
        ModBiomeFeatures.addLimestoneBoulder(vegetation);
    }

    public static void addRhunVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36135);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addWildCarrot(vegetation);
        ModBiomeFeatures.addWildBellPepper(vegetation);
        ModBiomeFeatures.addWildFlax(vegetation);
        ModBiomeFeatures.addWildLettuce(vegetation);
        ModBiomeFeatures.addWildOnion(vegetation);
        ModBiomeFeatures.addStoneBoulder(vegetation);
    }

    public static void addShireVegetation(class_5485.class_5495 generationSettings) {
        ModBiomeFeatures.addDisks(undergroundOres);
        vegetation.add((class_5321<class_6796>)class_6819.field_36166);
        vegetation.add((class_5321<class_6796>)class_6819.field_36129);
        vegetation.add((class_5321<class_6796>)class_6819.field_36120);
        vegetation.add((class_5321<class_6796>)class_6819.field_36121);
        vegetation.add((class_5321<class_6796>)class_6819.field_36117);
        vegetation.add((class_5321<class_6796>)class_6819.field_36164);
        ModBiomeFeatures.addWilderGrass(vegetation);
        ModBiomeFeatures.addGravelOre(vegetation);
        ModBiomeFeatures.addWildBeetroot(vegetation);
        ModBiomeFeatures.addWildCarrot(vegetation);
        ModBiomeFeatures.addWildCucumber(vegetation);
        ModBiomeFeatures.addWildGarlic(vegetation);
        ModBiomeFeatures.addWildLeek(vegetation);
        ModBiomeFeatures.addWildLettuce(vegetation);
        ModBiomeFeatures.addWildOnion(vegetation);
        ModBiomeFeatures.addWildPipeweed(vegetation);
        ModBiomeFeatures.addWildPotato(vegetation);
        ModBiomeFeatures.addStoneBoulder(vegetation);
    }

    public static class_1959 createBiome(BiomeColorsDTO biomeColors, class_5483.class_5496 spawnSettings, class_5485.class_5495 generationSettings) {
        return ModBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, true);
    }

    public static class_1959 createBiome(BiomeColorsDTO biomeColors, class_5483.class_5496 spawnSettings, class_5485.class_5495 generationSettings, float temperature, boolean precipitation) {
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36060);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36061);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36062);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36063);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36064);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36065);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36066);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36067);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36068);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36069);
        vegetation.add((class_5321<class_6796>)class_6812.field_35988);
        class_3864.method_16999((class_5485.class_5495)generationSettings);
        vegetation = vegetation.stream().sorted(Comparator.comparing(a -> a.method_29177().toString())).toList();
        for (class_5321<class_6796> class_53212 : vegetation) {
            generationSettings.method_30992(class_2893.class_2895.field_13178, class_53212);
        }
        for (class_5321<class_6796> class_53213 : undergroundOres.stream().sorted(Comparator.comparing(a -> a.method_29177().toString())).toList()) {
            generationSettings.method_30992(class_2893.class_2895.field_13176, class_53213);
        }
        class_1959 biome = new class_1959.class_1960().method_48164(precipitation).method_8747(temperature).method_8727(0.5f).method_24379(new class_4763.class_4764().method_30820(biomeColors.skyColor).method_24392(biomeColors.fogColor).method_24395(biomeColors.waterColor).method_24397(biomeColors.waterFogColor).method_30822(biomeColors.grassColor).method_30821(biomeColors.foliageColor).method_24391()).method_30974(spawnSettings.method_31007()).method_30973(generationSettings.method_46671()).method_30972();
        vegetation = new ArrayList<class_5321<class_6796>>();
        undergroundOres = new ArrayList();
        return biome;
    }
}

