/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.biomes.surface;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.jukoz.me.utils.noises.SimplexNoise;
import net.jukoz.me.world.biomes.MEBiomeKeys;
import net.jukoz.me.world.biomes.caves.CaveType;
import net.jukoz.me.world.biomes.caves.ModCaveBiomes;
import net.jukoz.me.world.biomes.surface.MEBiome;
import net.jukoz.me.world.biomes.surface.MEBiomesData;
import net.jukoz.me.world.chunkgen.map.MiddleEarthHeightMap;
import net.jukoz.me.world.map.MiddleEarthMapRuntime;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_241;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;

public class ModBiomeSource
extends class_1966 {
    private final ArrayList<class_6880<class_1959>> biomes;
    private final int CAVE_NOISE = 96;
    private final int CAVE_OFFSET = 7220;
    private MiddleEarthMapRuntime middleEarthMapRuntime;

    public ModBiomeSource(ArrayList<class_6880<class_1959>> biomes) {
        this.biomes = biomes;
        this.middleEarthMapRuntime = MiddleEarthMapRuntime.getInstance();
    }

    protected Codec<? extends class_1966> method_28442() {
        return field_24713;
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        return this.biomes.stream();
    }

    private class_5321<class_1959> getCaveBiome(int x, int z, MEBiome surfaceBiome) {
        float temperature = (float)SimplexNoise.noise((double)x / 96.0, (double)z / 96.0);
        float humidity = (float)SimplexNoise.noise((double)(x + 7220) / 96.0, (double)(z + 7220) / 96.0);
        return ModCaveBiomes.getBiome(new class_241(temperature, humidity), surfaceBiome);
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 noise) {
        class_5321<class_1959> processedBiome;
        int i = class_5742.method_33101((int)x);
        int j = class_5742.method_33101((int)y);
        int k = class_5742.method_33101((int)z);
        MEBiome meBiome = this.middleEarthMapRuntime.getBiome(i, k);
        if (meBiome == null) {
            return this.biomes.get(0);
        }
        class_5321<class_1959> biome = meBiome.biome;
        if (!MEBiomesData.waterBiomes.contains(biome)) {
            float height = 66.0f + MiddleEarthHeightMap.getHeight(i, k);
            processedBiome = j <= -55 && meBiome.caveType == CaveType.MISTIES ? MEBiomeKeys.MITHRIL_CAVE : ((float)j < height - 16.0f ? this.getCaveBiome(i, k, meBiome) : (height <= 65.25f ? (MEBiomesData.wastePondBiomes.contains(biome) ? MEBiomesData.wastePond.biome : (MEBiomesData.mirkwoodSwampBiomes.contains(biome) ? MEBiomesData.mirkwoodSwamp.biome : (MEBiomesData.oasisBiomes.contains(biome) ? MEBiomesData.oasis.biome : (MEBiomesData.frozenBiomes.contains(biome) ? MEBiomesData.frozenPond.biome : MEBiomesData.pond.biome)))) : biome));
        } else {
            processedBiome = biome;
        }
        return this.biomes.stream().filter(b -> ((class_5321)b.method_40230().get()).toString().equalsIgnoreCase(processedBiome.toString())).findFirst().get();
    }
}

