/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.world.biomes.caves;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.jukoz.me.world.biomes.BiomeColorsDTO;
import net.jukoz.me.world.biomes.MEBiomeKeys;
import net.jukoz.me.world.biomes.caves.CaveBiomeDTO;
import net.jukoz.me.world.biomes.caves.CaveBiomesMap;
import net.jukoz.me.world.biomes.caves.CaveType;
import net.jukoz.me.world.biomes.caves.ModCaveBiomeFeatures;
import net.jukoz.me.world.biomes.surface.MEBiome;
import net.jukoz.me.world.features.underground.CavesPlacedFeatures;
import net.minecraft.class_1959;
import net.minecraft.class_241;
import net.minecraft.class_2893;
import net.minecraft.class_3864;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6796;
import net.minecraft.class_6812;
import net.minecraft.class_6814;
import net.minecraft.class_6815;
import net.minecraft.class_6816;
import net.minecraft.class_7891;
import net.minecraft.class_7924;

public class ModCaveBiomes {
    public static final int defaultSky = 7907327;
    public static final int defaultFog = 12638463;
    public static final int defaultWater = 4159204;
    public static final int defaultWaterFog = 329011;
    private static List<class_5321<class_6796>> undergroundOres = new ArrayList<class_5321<class_6796>>();
    public static CaveBiomesMap defaultCaves = new CaveBiomesMap();
    public static CaveBiomesMap ashCaves = new CaveBiomesMap();
    public static CaveBiomesMap forodCaves = new CaveBiomesMap();
    public static CaveBiomesMap haradCaves = new CaveBiomesMap();

    public static void init() {
        defaultCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.LUSH_CAVE, new class_241(-1.0f, 0.0f)));
        defaultCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.DRIPSTONE_CAVE, new class_241(1.0f, 0.0f)));
        defaultCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.MUD_CAVE, new class_241(1.0f, 1.0f)));
        defaultCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.FUNGUS_CAVE, new class_241(0.0f, -1.0f)));
        defaultCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.BASIC_CAVE, new class_241(0.0f, 0.8f)));
        ashCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.DRIPSTONE_CAVE, new class_241(1.0f, 0.5f)));
        ashCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.BASALT_CAVE, new class_241(-1.0f, 0.5f)));
        ashCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.MAGMA_CAVE, new class_241(0.0f, -1.0f)));
        haradCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.DRIPSTONE_CAVE, new class_241(1.0f, 0.0f)));
        haradCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.DRY_CAVE, new class_241(0.0f, 0.0f)));
        haradCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.BASIC_CAVE, new class_241(-1.0f, 0.0f)));
        forodCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.ICE_CAVE, new class_241(-0.5f, 0.0f)));
        forodCaves.addCave(new CaveBiomeDTO(MEBiomeKeys.DRIPSTONE_CAVE, new class_241(1.0f, 0.0f)));
    }

    public static class_5321<class_1959> getBiome(class_241 coordinates, MEBiome surfaceBiome) {
        return switch (surfaceBiome.caveType) {
            case CaveType.ASHEN -> ashCaves.getClosestBiome(coordinates);
            case CaveType.HARAD -> haradCaves.getClosestBiome(coordinates);
            case CaveType.FOROD -> forodCaves.getClosestBiome(coordinates);
            default -> defaultCaves.getClosestBiome(coordinates);
        };
    }

    public static void bootstrap(class_7891<class_1959> context) {
        context.method_46838(MEBiomeKeys.BASIC_CAVE, (Object)ModCaveBiomes.createBasicCave(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 10338918, 10604137)));
        context.method_46838(MEBiomeKeys.LUSH_CAVE, (Object)ModCaveBiomes.createLushCave(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 8703593, 8703593)));
        context.method_46838(MEBiomeKeys.DRIPSTONE_CAVE, (Object)ModCaveBiomes.createDripstoneCave(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 10338918, 10604137)));
        context.method_46838(MEBiomeKeys.MUD_CAVE, (Object)ModCaveBiomes.createMudCaves(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 7435337, 7905386)));
        context.method_46838(MEBiomeKeys.FUNGUS_CAVE, (Object)ModCaveBiomes.createFungusCave(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 5869935, 6263141)));
        context.method_46838(MEBiomeKeys.MITHRIL_CAVE, (Object)ModCaveBiomes.createMithrilCave(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 10338918, 10604137)));
        context.method_46838(MEBiomeKeys.BASALT_CAVE, (Object)ModCaveBiomes.createBasaltCave(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 9534809, 8878692)));
        context.method_46838(MEBiomeKeys.MAGMA_CAVE, (Object)ModCaveBiomes.createMagmaCave(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 9527897, 8876132)));
        context.method_46838(MEBiomeKeys.DRY_CAVE, (Object)ModCaveBiomes.createDryCave(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 10928742, 11259497)));
        context.method_46838(MEBiomeKeys.ICE_CAVE, (Object)ModCaveBiomes.createIceCaves(context, new BiomeColorsDTO(7907327, 12638463, 4159204, 329011, 11121530, 10990723)));
    }

    public static class_1959 createBasicCave(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModCaveBiomes.addBasicFeatures(generationSettings, true);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, true);
    }

    public static class_1959 createLushCave(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModCaveBiomeFeatures.addAxolotls(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModCaveBiomes.addBasicFeatures(generationSettings, true);
        class_3864.method_16981((class_5485.class_5495)generationSettings);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36051);
        undergroundOres.add((class_5321<class_6796>)class_6812.field_35987);
        undergroundOres.add((class_5321<class_6796>)class_6814.field_36011);
        undergroundOres.add((class_5321<class_6796>)class_6814.field_36009);
        undergroundOres.add((class_5321<class_6796>)class_6814.field_36010);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.LUSH_CAVES_CEILING_VEGETATION);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.CAVE_VINES);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.LUSH_CAVES_CLAY);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.LUSH_CAVES_VEGETATION);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.SPORE_BLOSSOM);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.CLASSIC_VINES_CAVE);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, true);
    }

    public static class_1959 createDripstoneCave(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        undergroundOres.add((class_5321<class_6796>)class_6812.field_35985);
        undergroundOres.add((class_5321<class_6796>)class_6812.field_35984);
        undergroundOres.add((class_5321<class_6796>)class_6812.field_35986);
        undergroundOres.add((class_5321<class_6796>)class_6814.field_36010);
        ModCaveBiomes.addBasicFeatures(generationSettings, true);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, true);
    }

    public static class_1959 createMudCaves(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModCaveBiomeFeatures.addSnails(spawnSettings);
        ModCaveBiomeFeatures.addFrogs(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModCaveBiomes.addBasicFeatures(generationSettings, true);
        undergroundOres.add(CavesPlacedFeatures.ORE_DIRT);
        undergroundOres.add(CavesPlacedFeatures.ORE_MUD);
        undergroundOres.add(CavesPlacedFeatures.POOL_MUD);
        undergroundOres.add((class_5321<class_6796>)class_6814.field_36010);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, true);
    }

    public static class_1959 createFungusCave(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        ModCaveBiomeFeatures.addSnails(spawnSettings);
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModCaveBiomes.addBasicFeatures(generationSettings, true);
        undergroundOres.add(CavesPlacedFeatures.ORE_DIRT);
        undergroundOres.add(CavesPlacedFeatures.DISK_MYCELIUM);
        undergroundOres.add((class_5321<class_6796>)class_6814.field_36010);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.TREE_BROWN_BOLETTE);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_CAVE_AMANITA);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_CAVE_AMANITA_TILLER);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.TREE_CAVE_AMANITA);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_DEEP_FIRECAP);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_DEEP_FIRECAP_TILLER);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.TREE_DEEP_FIRECAP);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_GHOSTSHROOM);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_GHOSTSHROOM_TILLER);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_SKY_FIRECAP);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_SKY_FIRECAP_TILLER);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.TREE_SKY_FIRECAP);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_TUBESHROOMS);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_TALL_TUBESHROOMS);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_TRUMPET_SHROOM);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_TALL_TRUMPET_SHROOM);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_VIOLET_CAPS);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_VIOLET_CAPS_TILLER);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_YELLOW_AMANITA);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.PATCH_YELLOW_AMANITA_TILLER);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.TREE_YELLOW_AMANITA);
        generationSettings.method_30992(class_2893.class_2895.field_13178, CavesPlacedFeatures.GLOWWORM_WEBBING);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, true);
    }

    public static class_1959 createMithrilCave(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModCaveBiomes.addBasicFeatures(generationSettings, true);
        undergroundOres.add(CavesPlacedFeatures.ORE_MITHRIL);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, true);
    }

    public static class_1959 createBasaltCave(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModCaveBiomes.addBasicFeatures(generationSettings, false);
        generationSettings.method_30992(class_2893.class_2895.field_13173, CavesPlacedFeatures.DELTA);
        generationSettings.method_30992(class_2893.class_2895.field_13173, class_6815.field_36019);
        undergroundOres.add(CavesPlacedFeatures.ORE_ASH);
        undergroundOres.add(CavesPlacedFeatures.ORE_ASHEN_DIRT);
        undergroundOres.add((class_5321<class_6796>)class_6814.field_36010);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, true);
    }

    public static class_1959 createMagmaCave(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        ModCaveBiomes.addBasicFeatures(generationSettings, false);
        generationSettings.method_30992(class_2893.class_2895.field_13173, class_6815.field_36018);
        undergroundOres.add(CavesPlacedFeatures.ORE_MAGMA_ABUNDANT);
        undergroundOres.add(CavesPlacedFeatures.ORE_ASHEN_DIRT);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, true);
    }

    public static class_1959 createDryCave(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        undergroundOres.add(CavesPlacedFeatures.ORE_DRY_DIRT);
        undergroundOres.add(CavesPlacedFeatures.ORE_SAND);
        undergroundOres.add(CavesPlacedFeatures.ORE_SANDSTONE);
        undergroundOres.add(CavesPlacedFeatures.ORE_TERRACOTTA);
        undergroundOres.add(CavesPlacedFeatures.ORE_LAPIS_ABUNDANT);
        undergroundOres.add(CavesPlacedFeatures.PILLAR_SMOOTH_SANDSTONE);
        ModCaveBiomes.addBasicFeatures(generationSettings, true);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, false);
    }

    public static class_1959 createIceCaves(class_7891<class_1959> context, BiomeColorsDTO biomeColors) {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495(context.method_46799(class_7924.field_41245), context.method_46799(class_7924.field_41238));
        undergroundOres.add(CavesPlacedFeatures.ORE_BLUE_ICE);
        undergroundOres.add(CavesPlacedFeatures.ORE_PACKED_ICE);
        undergroundOres.add(CavesPlacedFeatures.ORE_SNOW);
        undergroundOres.add(CavesPlacedFeatures.PILLAR_PACKED_ICE);
        ModCaveBiomes.addBasicFeatures(generationSettings, true);
        return ModCaveBiomes.createBiome(biomeColors, spawnSettings, generationSettings, 0.5f, false);
    }

    private static void addBasicFeatures(class_5485.class_5495 generationSettings, boolean vanillaRocks) {
        ModCaveBiomeFeatures.addAmethystGeode(generationSettings);
        ModCaveBiomeFeatures.addCitrineGeode(generationSettings);
        ModCaveBiomeFeatures.addGlowstoneGeode(generationSettings);
        ModCaveBiomeFeatures.addRedAgateGeode(generationSettings);
        ModCaveBiomeFeatures.addQuartzGeode(generationSettings);
        undergroundOres.add(CavesPlacedFeatures.ORE_COAL);
        undergroundOres.add(CavesPlacedFeatures.ORE_COAL_UPPER);
        undergroundOres.add(CavesPlacedFeatures.ORE_COPPER);
        undergroundOres.add(CavesPlacedFeatures.ORE_COPPER_UPPER);
        undergroundOres.add(CavesPlacedFeatures.ORE_TIN);
        undergroundOres.add(CavesPlacedFeatures.ORE_LAPIS);
        undergroundOres.add(CavesPlacedFeatures.ORE_LEAD);
        undergroundOres.add(CavesPlacedFeatures.ORE_IRON);
        undergroundOres.add(CavesPlacedFeatures.ORE_SILVER);
        undergroundOres.add(CavesPlacedFeatures.ORE_JADE);
        undergroundOres.add(CavesPlacedFeatures.ORE_GOLD);
        undergroundOres.add(CavesPlacedFeatures.ORE_EMERALD);
        undergroundOres.add(CavesPlacedFeatures.SPRING_LAVA);
        undergroundOres.add((class_5321<class_6796>)class_6814.field_36017);
        undergroundOres.add(CavesPlacedFeatures.ORE_MAGMA);
        undergroundOres.add(CavesPlacedFeatures.ORE_OBSIDIAN);
        undergroundOres.add(CavesPlacedFeatures.PILLAR_BASALT);
        undergroundOres.add(CavesPlacedFeatures.ORE_BASALT);
        undergroundOres.add(CavesPlacedFeatures.ORE_TUFF);
        undergroundOres.add(CavesPlacedFeatures.PILLAR_BLACKSTONE);
        undergroundOres.add(CavesPlacedFeatures.ORE_BLACKSTONE);
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36061);
        undergroundOres.add(CavesPlacedFeatures.ORE_DOLOMITE);
        if (vanillaRocks) {
            undergroundOres.add(CavesPlacedFeatures.ORE_QUARTZITE);
            undergroundOres.add((class_5321<class_6796>)class_6816.field_36060);
            undergroundOres.add((class_5321<class_6796>)class_6816.field_36062);
            undergroundOres.add((class_5321<class_6796>)class_6816.field_36063);
            undergroundOres.add((class_5321<class_6796>)class_6816.field_36064);
            undergroundOres.add((class_5321<class_6796>)class_6816.field_36065);
            undergroundOres.add((class_5321<class_6796>)class_6816.field_36066);
            undergroundOres.add((class_5321<class_6796>)class_6816.field_36067);
        }
        undergroundOres.add((class_5321<class_6796>)class_6816.field_36068);
        generationSettings.method_30992(class_2893.class_2895.field_13178, class_6812.field_35988);
        class_3864.method_16999((class_5485.class_5495)generationSettings);
    }

    public static class_1959 createBiome(BiomeColorsDTO biomeColors, class_5483.class_5496 spawnSettings, class_5485.class_5495 generationSettings, float temperature, boolean precipitation) {
        ModCaveBiomeFeatures.addBats(spawnSettings);
        ModCaveBiomeFeatures.addCaveTrolls(spawnSettings);
        undergroundOres = undergroundOres.stream().sorted(Comparator.comparing(a -> a.method_29177().toString())).toList();
        for (class_5321<class_6796> feature : undergroundOres) {
            generationSettings.method_30992(class_2893.class_2895.field_13176, feature);
        }
        class_1959 biome = new class_1959.class_1960().method_48164(precipitation).method_8747(temperature).method_8727(0.5f).method_24379(new class_4763.class_4764().method_30820(biomeColors.skyColor).method_24392(biomeColors.fogColor).method_24395(biomeColors.waterColor).method_24397(biomeColors.waterFogColor).method_30822(biomeColors.grassColor).method_30821(biomeColors.foliageColor).method_24391()).method_30974(spawnSettings.method_31007()).method_30973(generationSettings.method_46671()).method_30972();
        undergroundOres = new ArrayList<class_5321<class_6796>>();
        return biome;
    }
}

