/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.utils.resources;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.jukoz.me.utils.LoggerUtil;
import net.jukoz.me.utils.resources.FileType;
import net.jukoz.me.world.chunkgen.map.ImageUtils;

public class FileUtils {
    private static FileUtils single_instance = null;
    private ClassLoader classLoader;

    public static synchronized FileUtils getInstance() {
        if (single_instance == null) {
            single_instance = new FileUtils(ClassLoader.getSystemClassLoader());
        }
        return single_instance;
    }

    public FileUtils(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public BufferedImage getResourceImage(String path) {
        try {
            return ImageUtils.fetchResourceImage(this.getClass().getClassLoader(), path);
        }
        catch (IOException e) {
            return null;
        }
    }

    public BufferedImage getRunImage(String path) {
        try {
            File f = new File(path);
            if (!f.exists()) {
                return null;
            }
            return ImageIO.read(f);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void saveImage(BufferedImage bufferedImage, String path, String fileName, FileType fileType) {
        try {
            new File(path).mkdirs();
            File f = new File(path + fileName);
            ImageIO.write((RenderedImage)bufferedImage, fileType.extension, f);
        }
        catch (Exception e) {
            LoggerUtil.getInstance().logError("Image Utils couldn't save image for {0}.".formatted(path + fileName));
        }
    }

    public static BufferedImage blur(BufferedImage image, int brushSize, float ratio) {
        int y;
        int x;
        int width = image.getWidth();
        int height = image.getHeight();
        int newWidth = width + 2 * brushSize;
        int newHeight = height + 2 * brushSize;
        BufferedImage expendedImage = new BufferedImage(newWidth, newHeight, image.getType());
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                expendedImage.setRGB(x + brushSize, y + brushSize, image.getRGB(x, y));
            }
        }
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < brushSize; ++x2) {
                expendedImage.setRGB(x2, y2 + brushSize, image.getRGB(0, y2));
                expendedImage.setRGB(width + brushSize + x2, y2 + brushSize, image.getRGB(width - 1, y2));
            }
        }
        for (x = 0; x < width + 2 * brushSize; ++x) {
            for (y = 0; y < brushSize; ++y) {
                expendedImage.setRGB(x, y, expendedImage.getRGB(x, brushSize));
                expendedImage.setRGB(x, height + brushSize + y, expendedImage.getRGB(x, height + brushSize - 1));
            }
        }
        float[] blurKernel = new float[brushSize * brushSize];
        Arrays.fill(blurKernel, ratio);
        Kernel kernel = new Kernel(brushSize, brushSize, blurKernel);
        ConvolveOp op = new ConvolveOp(kernel, 1, null);
        expendedImage = op.filter(expendedImage, null);
        return expendedImage.getSubimage(brushSize, brushSize, width, height);
    }
}

