/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jukoz.me.world.biomes.MEBiomeFogData;
import net.jukoz.me.world.dimension.ModDimensions;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_6854;
import net.minecraft.class_746;
import net.minecraft.class_758;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_758.class})
public class BackgroundRendererMixin {
    private static final float TICK_SPEED = 0.001f;
    private static float fogStartMultiplier = 0.25f;
    private static float fogEndMultiplier = 1.0f;

    @Inject(method={"applyFog"}, at={@At(value="TAIL")})
    private static void applyFog(class_4184 camera, class_758.class_4596 fogType, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo ci) {
        class_746 clientPlayerEntity;
        class_1297 entity = camera.method_19331();
        if (entity instanceof class_746 && !(clientPlayerEntity = (class_746)entity).method_6059(class_1294.field_38092) && !clientPlayerEntity.method_6059(class_1294.field_5919) && !clientPlayerEntity.method_5869() && ModDimensions.isInMiddleEarth(clientPlayerEntity.method_37908())) {
            Optional biomeRegistry = clientPlayerEntity.method_37908().method_23753(clientPlayerEntity.method_24515()).method_40230();
            if (biomeRegistry.isPresent() && MEBiomeFogData.DATA.containsKey(biomeRegistry.get())) {
                MEBiomeFogData fogData = MEBiomeFogData.DATA.get(biomeRegistry.get());
                if (fogStartMultiplier < fogData.fogStart) {
                    fogStartMultiplier = Math.min(fogStartMultiplier + tickDelta * 0.001f, fogData.fogStart);
                } else if (fogStartMultiplier > fogData.fogStart) {
                    fogStartMultiplier = Math.max(fogStartMultiplier - tickDelta * 0.001f, fogData.fogStart);
                }
                if (fogEndMultiplier < fogData.fogEnd) {
                    fogEndMultiplier = Math.min(fogEndMultiplier + tickDelta * 0.001f, fogData.fogEnd);
                } else if (fogEndMultiplier > fogData.fogEnd) {
                    fogEndMultiplier = Math.max(fogEndMultiplier - tickDelta * 0.001f, fogData.fogEnd);
                }
            } else {
                fogEndMultiplier = Math.min(fogEndMultiplier + tickDelta * 0.001f, 1.0f);
                fogStartMultiplier = Math.min(fogStartMultiplier + tickDelta * 0.001f, 1.0f);
            }
            float f = class_3532.method_15363((float)(viewDistance / 10.0f), (float)4.0f, (float)64.0f);
            float fogStart = (viewDistance - f) * fogStartMultiplier;
            float fogEnd = viewDistance * fogEndMultiplier;
            RenderSystem.setShaderFogStart((float)fogStart);
            RenderSystem.setShaderFogEnd((float)fogEnd);
            RenderSystem.setShaderFogShape((class_6854)class_6854.field_36350);
        }
    }
}

