/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.entity.beasts;

import java.util.UUID;
import java.util.function.Predicate;
import net.jukoz.me.item.items.TrollArmorItem;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1429;
import net.minecraft.class_1492;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5630;
import net.minecraft.class_5819;
import net.minecraft.class_7094;

public class BeastEntity
extends class_1492 {
    public static final class_2940<Boolean> CHARGING = class_2945.method_12791(BeastEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SITTING = class_2945.method_12791(BeastEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public final class_7094 chargeAnimationState = new class_7094();
    public final class_7094 sittingAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    private int attackTicksLeft = 0;
    protected int chargeTimeout;
    public static final int ATTACK_COOLDOWN = 10;
    public static final float RESISTANCE = 0.15f;
    protected class_243 targetDir = class_243.field_1353;
    private static final UUID BEAST_ARMOR_BONUS_ID = UUID.fromString("667E1665-8B10-40C8-8F9D-CF9B1667F295");

    protected BeastEntity(class_1299<? extends class_1492> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CHARGING, (Object)false);
        this.field_6011.method_12784(SITTING, (Object)false);
    }

    protected void method_6001(class_5819 random) {
    }

    protected void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isSitting()) {
            this.sittingAnimationState.method_41324(this.field_6012);
        } else {
            this.sittingAnimationState.method_41325();
        }
    }

    public void method_5674(class_2940<?> data) {
        if (!this.field_5953 && CHARGING.equals(data)) {
            this.chargeTimeout = this.chargeTimeout == 0 ? this.maxChargeCooldown() : this.chargeTimeout;
        }
        super.method_5674(data);
    }

    private class_5630 createInventoryStackReference(final int slot, final Predicate<class_1799> predicate) {
        return new class_5630(){

            public class_1799 method_32327() {
                return BeastEntity.this.field_6962.method_5438(slot);
            }

            public boolean method_32332(class_1799 stack) {
                if (!predicate.test(stack)) {
                    return false;
                }
                BeastEntity.this.field_6962.method_5447(slot, stack);
                BeastEntity.this.method_6731();
                return true;
            }
        };
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("ChestedBeast", this.method_6703());
        if (this.method_6703()) {
            class_2499 nbtList = new class_2499();
            for (int i = 2; i < this.field_6962.method_5439(); ++i) {
                class_1799 itemStack = this.field_6962.method_5438(i);
                if (itemStack.method_7960()) continue;
                class_2487 nbtCompound = new class_2487();
                nbtCompound.method_10567("Slot", (byte)i);
                itemStack.method_7953(nbtCompound);
                nbtList.add((Object)nbtCompound);
            }
            nbt.method_10566("Items", (class_2520)nbtList);
        }
        if (!this.field_6962.method_5438(1).method_7960()) {
            nbt.method_10566("ArmorItem", (class_2520)this.field_6962.method_5438(1).method_7953(new class_2487()));
        }
    }

    public void method_5749(class_2487 nbt) {
        class_1799 itemStack;
        super.method_5749(nbt);
        this.method_6704(nbt.method_10577("ChestedBeast"));
        this.method_6721();
        if (this.method_6703()) {
            class_2499 nbtList = nbt.method_10554("Items", 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                int j = nbtCompound.method_10571("Slot") & 0xFF;
                if (j < 2 || j >= this.field_6962.method_5439()) continue;
                this.field_6962.method_5447(j, class_1799.method_7915((class_2487)nbtCompound));
            }
        }
        if (nbt.method_10573("ArmorItem", 10) && !(itemStack = class_1799.method_7915((class_2487)nbt.method_10562("ArmorItem"))).method_7960() && this.method_6773(itemStack)) {
            this.field_6962.method_5447(1, itemStack);
        }
        this.method_6731();
    }

    public boolean canCharge() {
        return !this.isSitting();
    }

    protected float method_6106() {
        return 0.5f * this.method_23313() + this.method_37416();
    }

    public int method_45327() {
        return this.chargeTimeout;
    }

    public double method_5621() {
        float f = Math.min(0.25f, this.field_42108.method_48566());
        float g = this.field_42108.method_48569();
        return (double)this.method_17682() - 0.19 + (double)(0.12f * class_3532.method_15362((float)(g * 1.5f)) * 2.0f * f);
    }

    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        if (this.method_24828() && this.field_6976 == 0.0f && this.method_6736() && !this.field_6960 || this.isSitting()) {
            return class_243.field_1353;
        }
        float f = controllingPlayer.field_6212 * 0.5f;
        float g = controllingPlayer.field_6250 * 0.75f;
        if (g <= 0.0f) {
            g *= 0.25f;
        }
        return new class_243((double)f, 0.0, (double)g);
    }

    public class_1657 getOwner() {
        if (this.method_6139() != null) {
            return this.getPlayerByUuid(this.method_6139());
        }
        return null;
    }

    public boolean isSitting() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.field_6011.method_12778(SITTING, (Object)sitting);
    }

    public boolean isCommandItem(class_1799 stack) {
        return false;
    }

    public void setCharging(boolean charging) {
        this.field_6011.method_12778(CHARGING, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(CHARGING);
    }

    public int getChargeTimeout() {
        return this.chargeTimeout;
    }

    public void setChargeTimeout(int chargeTimeout) {
        this.chargeTimeout = chargeTimeout;
    }

    public int maxChargeCooldown() {
        return 400;
    }

    public int chargeDuration() {
        return 20;
    }

    private float getAttackDamage() {
        return (float)this.method_26825(class_5134.field_23721);
    }

    protected void method_16078() {
        super.method_16078();
        if (this.method_6703()) {
            if (!this.method_37908().field_9236) {
                this.method_5706((class_1935)class_2246.field_10034);
            }
            this.method_6704(false);
        }
    }

    public void method_5453(class_1263 sender) {
        class_1799 itemStack = this.getArmorType();
        super.method_5453(sender);
        class_1799 itemStack2 = this.getArmorType();
        if (this.field_6012 > 20 && this.method_6773(itemStack2) && itemStack != itemStack2) {
            this.method_5783(class_3417.field_14862, 0.5f, 1.0f);
        }
    }

    public class_5630 method_32318(int mappedIndex) {
        int j;
        int i = mappedIndex - 400;
        if (i >= 0 && i < 2 && i < this.field_6962.method_5439()) {
            if (i == 0) {
                return this.createInventoryStackReference(i, stack -> stack.method_7960() || stack.method_31574(class_1802.field_8175));
            }
            if (i == 1) {
                if (!this.method_6735()) {
                    return class_5630.field_27860;
                }
                return this.createInventoryStackReference(i, stack -> stack.method_7960() || this.method_6773((class_1799)stack));
            }
        }
        if ((j = mappedIndex - 500 + 2) >= 2 && j < this.field_6962.method_5439()) {
            return class_5630.method_32328((class_1263)this.field_6962, (int)j);
        }
        return super.method_32318(mappedIndex);
    }

    protected int method_6750() {
        return this.method_6703() ? 17 : super.method_6750();
    }

    public int method_6702() {
        return 5;
    }

    private void addChest(class_1657 player, class_1799 chest) {
        this.method_6704(true);
        this.method_6705();
        if (!player.method_31549().field_7477) {
            chest.method_7934(1);
        }
        this.method_6721();
    }

    protected void method_6705() {
        this.method_5783(class_3417.field_14598, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
    }

    private void equipArmor(class_1799 stack) {
        this.method_5673(class_1304.field_6174, stack);
        this.method_5946(class_1304.field_6174, 0.0f);
    }

    public class_1799 getArmorType() {
        return this.method_6118(class_1304.field_6174);
    }

    public boolean method_6735() {
        return true;
    }

    private void setArmorTypeFromStack(class_1799 stack) {
        this.equipArmor(stack);
        if (!this.method_37908().field_9236) {
            int i;
            this.method_5996(class_5134.field_23724).method_6200(BEAST_ARMOR_BONUS_ID);
            if (this.method_6773(stack) && (i = ((TrollArmorItem)stack.method_7909()).method_18455()) != 0) {
                this.method_5996(class_5134.field_23724).method_26835(new class_1322(BEAST_ARMOR_BONUS_ID, "Beast armor bonus", (double)i, class_1322.class_1323.field_6328));
            }
        }
    }

    protected void method_6731() {
        if (!this.method_37908().field_9236) {
            super.method_6731();
            this.setArmorTypeFromStack(this.field_6962.method_5438(1));
            this.method_5946(class_1304.field_6174, 0.0f);
        }
    }

    public class_3414 method_45328() {
        return super.method_45328();
    }

    protected void method_45343(float strength, class_243 movementInput) {
        if (this.isSitting()) {
            this.setSitting(false);
        } else if (this.chargeTimeout <= 0) {
            this.setCharging(true);
            this.chargeTimeout = this.maxChargeCooldown();
        }
    }

    public void method_6155(int height) {
        if (!this.isSitting()) {
            this.method_5783(class_3417.field_40073, 1.0f, 1.0f);
            this.setCharging(true);
        } else {
            this.setSitting(false);
        }
    }

    public void tryBonding(class_1657 player) {
        if (this.field_5974.method_43058() <= 0.1) {
            if (player instanceof class_3222) {
                this.method_6732(player.method_5667());
                this.method_6766(true);
                class_174.field_1201.method_9132((class_3222)player, (class_1429)this);
            }
            this.method_37908().method_8421((class_1297)this, (byte)7);
            this.chargeTimeout = 0;
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)6);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack;
        boolean bl;
        boolean bl2 = bl = !this.method_6109() && this.method_6727() && player.method_21823();
        if (this.method_6727() && this.isCommandItem(player.method_5998(hand)) && player.method_5667() == this.method_6139()) {
            this.setSitting(!this.isSitting());
        }
        if (this.method_6727() && !this.isCommandItem(player.method_5998(hand))) {
            super.method_5992(player, hand);
        }
        if (player.method_5998(hand).method_31574(this.getBondingItem()) && !this.method_6727() && !this.method_37908().field_9236) {
            this.tryBonding(player);
        }
        if (!(this.method_5782() || bl || (itemStack = player.method_5998(hand)).method_7960())) {
            if (!this.method_6703() && itemStack.method_31574(class_1802.field_8106)) {
                this.addChest(player, itemStack);
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            if (this.method_6735() && this.method_6773(itemStack) && !this.method_6753()) {
                this.method_45375(player, itemStack);
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
        }
        return class_1269.method_29236((boolean)this.method_37908().field_9236);
    }

    public class_1792 getBondingItem() {
        return null;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!(source.equals(this.method_48923().method_48824()) || source.equals(this.method_48923().method_48817()) || source.equals(this.method_48923().method_48823()) || source.equals(this.method_48923().method_48831()))) {
            amount *= 0.85f;
        }
        return super.method_5643(source, amount);
    }

    public void chargeAttack() {
    }

    public boolean method_6121(class_1297 target) {
        this.attackTicksLeft = 10;
        this.method_37908().method_8421((class_1297)this, (byte)4);
        float f = this.getAttackDamage();
        float g = (int)f > 0 ? f / 2.0f + (float)this.field_5974.method_43048((int)f) : f;
        boolean bl = target.method_5643(this.method_48923().method_48812((class_1309)this), g);
        if (bl) {
            double d;
            if (target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                d = livingEntity.method_26825(class_5134.field_23718);
            } else {
                d = 0.0;
            }
            double e = Math.max(0.0, 1.0 - d);
            target.method_18799(target.method_18798().method_1021(1.0 + (double)0.8f * e));
            this.method_5723((class_1309)this, target);
        }
        this.method_5783(class_3417.field_22258, 1.5f, 0.8f);
        return bl;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5968() != null) {
            this.method_5988().method_35111((class_1297)this.method_5968());
        }
        if (this.isCharging()) {
            this.chargeAttack();
            if (!this.chargeAnimationState.method_41327()) {
                this.chargeAnimationState.method_41322(this.field_6012);
            }
        }
        if (this.chargeTimeout <= this.maxChargeCooldown() - this.chargeDuration() || !this.isCharging()) {
            this.setCharging(false);
            this.targetDir = class_243.field_1353;
        }
        if (!this.isCharging()) {
            this.chargeAnimationState.method_41325();
        }
        if (this.chargeTimeout > 0) {
            --this.chargeTimeout;
        }
        if (this.method_37908().field_9236) {
            this.setupAnimationStates();
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.attackTicksLeft > 0) {
            --this.attackTicksLeft;
        }
    }

    public void method_5711(byte status) {
        if (status == 4) {
            this.attackTicksLeft = 10;
        }
        if (status == 4) {
            this.attackAnimationState.method_41322(this.field_6012);
        }
        if (status == 7) {
            this.method_6760(true);
        } else if (status == 6) {
            this.method_6760(false);
        } else {
            super.method_5711(status);
        }
    }

    public class_1657 getPlayerByUuid(UUID uuid) {
        for (int i = 0; i < this.method_37908().method_18456().size(); ++i) {
            class_1657 playerEntity = (class_1657)this.method_37908().method_18456().get(i);
            if (!uuid.equals(playerEntity.method_5667())) continue;
            return playerEntity;
        }
        return null;
    }

    protected void method_48565(float posDelta) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(posDelta * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_38077, 0.15f, 2.0f);
    }

    public boolean method_36320() {
        return super.method_36320();
    }

    public class_1924 method_48926() {
        return null;
    }
}

