/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jukoz.me.world.dimension.ModDimensions;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7417;
import net.minecraft.class_742;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class MiddleEarthMapScreen
extends class_437 {
    private static final class_2960 WINDOW_TEXTURE = new class_2960("me", "textures/gui/map_background.png");
    private static final class_2960 MAP_UI_TEXTURE = new class_2960("me", "textures/gui/map_ui.png");
    private static final class_2960 MAP_TEXTURE = new class_2960("me", "textures/map.png");
    private static final class_2561 MAP_TITLE_TEXT = class_2561.method_30163((String)"Middle-earth Map");
    public static final int MARGIN = 5;
    public static final int MAP_IMAGE_WIDTH = 3000;
    public static final int MAP_IMAGE_HEIGHT = 3000;
    public int windowWidth;
    public int windowHeight;
    public int mapWindowWidth;
    public int mapWindowHeight;
    public float minZoom;
    private static final int MAX_ZOOM_LEVEL = 20;
    public static final float[] ZOOM_LEVELS = new float[20];
    private static final Vector2i WORLD_SIZE = MiddleEarthMapScreen.getWorldSize();
    private static int mapDisplacementX = 0;
    private static int mapDisplacementY = 0;
    private static int zoomLevel = 1;
    private static int zoomButtonIndex;
    private static int dezoomButtonIndex;
    private static int centerOnPlayerButtonIndex;
    private static int debugButtonIndex;
    private Vector2i cursorWorldCoordinate;
    private static boolean debug;
    class_742 player;
    private static int pixelWeight;

    public MiddleEarthMapScreen() {
        super(MAP_TITLE_TEXT);
        pixelWeight = 4;
        float zoom = 1.0f;
        for (int i = 0; i < ZOOM_LEVELS.length; ++i) {
            MiddleEarthMapScreen.ZOOM_LEVELS[i] = zoom;
            zoom *= 1.2f;
        }
    }

    protected void method_25426() {
        if (this.field_22787 != null) {
            float[] guiScaleModifiers = new float[]{6.25f, 3.0f, 4.0f, 5.0f, 6.25f};
            int guiScale = Math.max(0, Math.min(guiScaleModifiers.length - 1, (Integer)this.field_22787.field_1690.method_42474().method_41753()));
            this.windowWidth = Math.round(3000.0f / guiScaleModifiers[guiScale] / 2.0f);
            this.windowHeight = Math.round(3000.0f / guiScaleModifiers[guiScale] / 2.0f);
            this.mapWindowWidth = this.windowWidth - 10;
            this.mapWindowHeight = this.windowHeight - 10;
        }
        this.minZoom = (float)this.mapWindowWidth / 3000.0f;
        int x = (this.field_22789 - this.windowWidth) / 2;
        int y = (this.field_22790 - this.windowHeight) / 2;
        int offset = 18;
        int buttonMargin = 3;
        int optionsOffsetX = x + this.windowWidth + 2;
        int optionsOffsetY = y + this.windowHeight - 5;
        class_4185 debugButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Debug"), button -> {
            debug = !debug;
        }).method_46434(optionsOffsetX, y + 5, 18, 18).method_46431();
        class_4185 centerOnPlayer = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Center on Player"), button -> this.centerOnPlayer()).method_46434(optionsOffsetX, optionsOffsetY - offset * 3 - buttonMargin * 2, 18, 18).method_46431();
        class_4185 zoomButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Zoom"), button -> this.zoom(1, false)).method_46434(optionsOffsetX, optionsOffsetY - offset * 2 - buttonMargin, 18, 18).method_46431();
        class_4185 dezoomButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Dezoom"), button -> this.zoom(-1, false)).method_46434(optionsOffsetX, optionsOffsetY - offset, 18, 18).method_46431();
        this.method_37063((class_364)debugButton);
        this.method_37063((class_364)centerOnPlayer);
        this.method_37063((class_364)zoomButton);
        this.method_37063((class_364)dezoomButton);
        debugButtonIndex = this.method_25396().indexOf(debugButton);
        centerOnPlayerButtonIndex = this.method_25396().indexOf(centerOnPlayer);
        zoomButtonIndex = this.method_25396().indexOf(zoomButton);
        dezoomButtonIndex = this.method_25396().indexOf(dezoomButton);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_1297 cameraEntity = this.field_22787.method_1560();
        if (cameraEntity != null) {
            if (cameraEntity instanceof class_742) {
                class_742 abstractClientPlayerEntity;
                this.player = abstractClientPlayerEntity = (class_742)cameraEntity;
                this.method_25420(context);
                this.drawWindow(context, mouseX, mouseY);
            } else {
                this.player = null;
            }
        }
    }

    public void drawWindow(class_332 context, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.windowWidth) / 2;
        int y = (this.field_22790 - this.windowHeight) / 2;
        RenderSystem.enableBlend();
        this.drawMaintTextures(context, x, y, mouseX, mouseY);
        class_241 mapPlayerPos = this.getCoordinateOnMap(this.player.method_24515().method_10263(), this.player.method_24515().method_10260(), 4, 4);
        if (ModDimensions.isInMiddleEarth(this.player.method_37908())) {
            context.method_25290(this.player.method_3117(), x + 5 + (int)mapPlayerPos.field_1343 - 4, y + 5 + (int)mapPlayerPos.field_1342 - 4, 8.0f, 8.0f, 8, 8, 64, 64);
            boolean outsideBound = this.cursorIsOutsideOfMapBounds(mouseX, mouseY);
            this.cursorWorldCoordinate = this.getWorldCoordinateOfCursor(mouseX, mouseY);
            if (debug) {
                class_1937 world = this.player.method_37908();
                Optional biomeRegistry = world.method_23753(this.player.method_24515()).method_40230();
                class_5250 text = class_5250.method_43477((class_7417)new class_2585("N/A"));
                if (biomeRegistry.isPresent()) {
                    String currentBiomeId = ((class_5321)biomeRegistry.get()).method_29177().toString().replace(':', '.');
                    text = class_5250.method_43477((class_7417)new class_2585("Biome: "));
                    text.method_10852((class_2561)class_2561.method_43471((String)("biome." + currentBiomeId)));
                }
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Player information"), 0, 5, 0xFFFFFF);
                class_2338 playerPos = this.player.method_24515();
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)("Coordinates : " + playerPos.method_10263() + ", " + playerPos.method_10264() + ", " + playerPos.method_10260())), 5, 15, 0xFFFFFF);
                context.method_27535(this.field_22793, (class_2561)text, 5, 25, 0xFFFFFF);
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Cursor information"), 0, 45, 0xFFFFFF);
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)("Coordinates : " + (String)(outsideBound ? "N/A" : this.cursorWorldCoordinate.x + ", " + this.cursorWorldCoordinate.y))), 5, 55, 0xFFFFFF);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1 && !this.cursorIsOutsideOfMapBounds(mouseX, mouseY) && this.player.method_7337() && debug) {
            this.getTeleport(this.getWorldCoordinateOfCursor(mouseX, mouseY));
            this.method_25419();
            return true;
        }
        super.method_25402(mouseX, mouseY, button);
        return false;
    }

    private void getTeleport(Vector2i coord) {
        if (ModDimensions.isInMiddleEarth(this.player.method_37908())) {
            String tpString = "/tp %s ~ %s".formatted(coord.x, coord.y);
            new class_2558(class_2558.class_2559.field_21462, tpString);
        }
    }

    private float getZoomLevel() {
        return ZOOM_LEVELS[zoomLevel - 1];
    }

    private void drawMaintTextures(class_332 context, int x, int y, double mouseX, double mouseY) {
        int dezoomTextureOffset;
        int zoomTextureOffset;
        int centerOnPlayerTextureOffset;
        int debugButtonTextureOffset;
        context.method_25290(WINDOW_TEXTURE, x, y, 0.0f, 0.0f, this.windowWidth, this.windowHeight, this.windowWidth, this.windowHeight);
        context.method_25290(MAP_TEXTURE, x + 5, y + 5, (float)mapDisplacementX, (float)mapDisplacementY, this.mapWindowWidth, this.mapWindowHeight, (int)(3000.0f * this.getZoomLevel() * this.minZoom), (int)(3000.0f * this.getZoomLevel() * this.minZoom));
        int n = debugButtonTextureOffset = ((class_364)this.method_25396().get(debugButtonIndex)).method_25405(mouseX, mouseY) ? 18 : 0;
        if (!ModDimensions.isInMiddleEarth(this.player.method_37908())) {
            debugButtonTextureOffset = 36;
        }
        context.method_25290(MAP_UI_TEXTURE, ((class_4185)this.method_25396().get(debugButtonIndex)).method_46426(), ((class_4185)this.method_25396().get(debugButtonIndex)).method_46427(), (float)debugButtonTextureOffset, 54.0f, 18, 18, 256, 256);
        int n2 = centerOnPlayerTextureOffset = ((class_364)this.method_25396().get(centerOnPlayerButtonIndex)).method_25405(mouseX, mouseY) ? 18 : 0;
        if (!this.canCenterOnPlayer()) {
            centerOnPlayerTextureOffset = 36;
        }
        context.method_25290(MAP_UI_TEXTURE, ((class_4185)this.method_25396().get(centerOnPlayerButtonIndex)).method_46426(), ((class_4185)this.method_25396().get(centerOnPlayerButtonIndex)).method_46427(), (float)centerOnPlayerTextureOffset, 36.0f, 18, 18, 256, 256);
        int n3 = zoomTextureOffset = ((class_364)this.method_25396().get(zoomButtonIndex)).method_25405(mouseX, mouseY) ? 18 : 0;
        if (zoomLevel == 19) {
            zoomTextureOffset = 36;
        }
        context.method_25290(MAP_UI_TEXTURE, ((class_4185)this.method_25396().get(zoomButtonIndex)).method_46426(), ((class_4185)this.method_25396().get(zoomButtonIndex)).method_46427(), (float)zoomTextureOffset, 0.0f, 18, 18, 256, 256);
        int n4 = dezoomTextureOffset = ((class_364)this.method_25396().get(dezoomButtonIndex)).method_25405(mouseX, mouseY) ? 18 : 0;
        if (zoomLevel == 1) {
            dezoomTextureOffset = 36;
        }
        context.method_25290(MAP_UI_TEXTURE, ((class_4185)this.method_25396().get(dezoomButtonIndex)).method_46426(), ((class_4185)this.method_25396().get(dezoomButtonIndex)).method_46427(), (float)dezoomTextureOffset, 18.0f, 18, 18, 256, 256);
        ((class_4185)this.method_25396().get((int)MiddleEarthMapScreen.debugButtonIndex)).field_22763 = ModDimensions.isInMiddleEarth(this.player.method_37908());
        ((class_4185)this.method_25396().get((int)MiddleEarthMapScreen.centerOnPlayerButtonIndex)).field_22763 = this.canCenterOnPlayer();
        ((class_4185)this.method_25396().get((int)MiddleEarthMapScreen.zoomButtonIndex)).field_22763 = zoomLevel < 19;
        ((class_4185)this.method_25396().get((int)MiddleEarthMapScreen.dezoomButtonIndex)).field_22763 = zoomLevel > 1;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button != 0) {
            return false;
        }
        if (this.cursorIsOutsideOfMapBounds(mouseX, mouseY)) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        mapDisplacementX = (int)((float)mapDisplacementX - (float)deltaX);
        mapDisplacementY = (int)((float)mapDisplacementY - (float)deltaY);
        this.correctMapVision();
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.cursorIsOutsideOfMapBounds(mouseX, mouseY)) {
            Vector2i coord = this.getWorldCoordinateOfCursor(mouseX, mouseY);
            coord.x /= pixelWeight;
            coord.y /= pixelWeight;
            this.cursorWorldCoordinate = coord;
            this.zoom((int)Math.round(amount), true);
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    private void zoom(int amount, boolean towardCursor) {
        int newZoomLevelIndex = Math.min(19, Math.max(1, zoomLevel + amount));
        if (newZoomLevelIndex != zoomLevel) {
            Vector2i center = towardCursor ? this.cursorWorldCoordinate : this.getCoordinateInCenterOfMap();
            zoomLevel = newZoomLevelIndex;
            this.centerOnCoordinates(center.x, center.y);
        }
    }

    private void correctMapVision() {
        mapDisplacementX = Math.max(0, mapDisplacementX);
        mapDisplacementY = Math.max(0, mapDisplacementY);
        float modifier = this.getZoomLevel() - 1.0f;
        mapDisplacementX = (int)Math.min((float)this.mapWindowWidth * modifier, (float)mapDisplacementX);
        mapDisplacementY = (int)Math.min((float)this.mapWindowHeight * modifier, (float)mapDisplacementY);
    }

    private class_241 getCoordinateOnMap(float posX, float posZ, int textureOffsetX, int textureOffsetY) {
        float transformedPosX = posX / (float)pixelWeight / (float)MiddleEarthMapScreen.WORLD_SIZE.x * (float)this.mapWindowWidth * this.getZoomLevel() - (float)mapDisplacementX;
        float transformedPosY = posZ / (float)pixelWeight / (float)MiddleEarthMapScreen.WORLD_SIZE.y * (float)this.mapWindowHeight * this.getZoomLevel() - (float)mapDisplacementY;
        transformedPosX = Math.max((float)textureOffsetX, Math.min((float)(this.mapWindowWidth - textureOffsetX), transformedPosX));
        transformedPosY = Math.max((float)textureOffsetY, Math.min((float)(this.mapWindowHeight - textureOffsetY), transformedPosY));
        return new class_241(transformedPosX, transformedPosY);
    }

    private boolean cursorIsOutsideOfMapBounds(double mouseX, double mouseY) {
        int x = (this.field_22789 - this.windowWidth) / 2 + 5;
        int y = (this.field_22790 - this.windowHeight) / 2 + 5;
        boolean isInBoundX = (int)mouseX - x > 0 && (int)mouseX - x < this.mapWindowWidth;
        boolean isInBoundY = (int)mouseY - y > 0 && (int)mouseY - y < this.mapWindowHeight;
        return !isInBoundX || !isInBoundY;
    }

    private void centerOnPlayer() {
        if (this.canCenterOnPlayer()) {
            this.centerOnCoordinates(this.player.method_23317() / (double)pixelWeight, this.player.method_23321() / (double)pixelWeight);
        }
    }

    private boolean canCenterOnPlayer() {
        return zoomLevel > 1 && this.player != null && ModDimensions.isInMiddleEarth(this.player.method_37908());
    }

    private void centerOnCoordinates(double x, double y) {
        double transformedCoordinatesX = x / (double)MiddleEarthMapScreen.WORLD_SIZE.x * (double)this.mapWindowWidth * (double)this.getZoomLevel();
        double transformedCoordinatesY = y / (double)MiddleEarthMapScreen.WORLD_SIZE.y * (double)this.mapWindowHeight * (double)this.getZoomLevel();
        this.centerMapTo((int)transformedCoordinatesX, (int)transformedCoordinatesY);
    }

    private Vector2i getCenterOfCurrentMap() {
        int centerX = (int)((float)(mapDisplacementX + this.mapWindowWidth / 2) / (this.getZoomLevel() * this.minZoom) / (float)pixelWeight);
        int centerY = (int)((float)(mapDisplacementY + this.mapWindowHeight / 2) / (this.getZoomLevel() * this.minZoom) / (float)pixelWeight);
        return new Vector2i(centerX, centerY);
    }

    private Vector2i getWorldCoordinateOfCursor(double mouseX, double mouseY) {
        int centerX = (int)(((double)mapDisplacementX + (mouseX -= (double)(this.field_22789 - this.windowWidth) / 2.0)) / (double)(this.getZoomLevel() * this.minZoom));
        int centerY = (int)(((double)mapDisplacementY + (mouseY -= (double)(this.field_22790 - this.windowHeight) / 2.0)) / (double)(this.getZoomLevel() * this.minZoom));
        centerX = MiddleEarthMapScreen.WORLD_SIZE.x / 3000 * centerX;
        centerY = MiddleEarthMapScreen.WORLD_SIZE.y / 3000 * centerY;
        return new Vector2i(centerX * pixelWeight, centerY * pixelWeight);
    }

    private Vector2i getCoordinateInCenterOfMap() {
        Vector2i currentCenter = this.getCenterOfCurrentMap();
        currentCenter.x = MiddleEarthMapScreen.WORLD_SIZE.x / 3000 * currentCenter.x;
        currentCenter.y = MiddleEarthMapScreen.WORLD_SIZE.y / 3000 * currentCenter.y;
        return currentCenter;
    }

    private void centerMapTo(int x, int y) {
        mapDisplacementX = x - this.mapWindowWidth / 2;
        mapDisplacementY = y - this.mapWindowHeight / 2;
        this.correctMapVision();
    }

    private static Vector2i getWorldSize() {
        float worldSize = (float)Math.pow(2.0, 3.0);
        return new Vector2i((int)(3000.0f * worldSize), (int)(3000.0f * worldSize));
    }

    static {
        debug = false;
    }
}

