/*
 * Decompiled with CFR 0.152.
 */
package net.jukoz.me.block.special.alloyfurnace;

import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.jukoz.me.block.ModBlockEntities;
import net.jukoz.me.gui.alloyfurnace.AlloyFurnaceScreenHandler;
import net.jukoz.me.network.ModNetworks;
import net.jukoz.me.recipe.AlloyRecipe;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class AlloyFurnaceEntity
extends class_2586
implements class_3908,
class_1278 {
    private static final String ID = "alloy_furnace";
    public static final int MAX_PROGRESS = 1200;
    public static final int FUEL_SLOT = 0;
    public static final int OUTPUT_SLOT = 5;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    protected final class_3913 propertyDelegate;
    protected final Map<class_1792, Integer> fuelTimeMap = class_2609.method_11196();
    private int progress = 0;
    private int fuelTime = 0;
    private int maxFuelTime = 0;

    public AlloyFurnaceEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.ALLOY_FURNACE, pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> AlloyFurnaceEntity.this.progress;
                    case 1 -> AlloyFurnaceEntity.this.fuelTime;
                    case 2 -> AlloyFurnaceEntity.this.maxFuelTime;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        AlloyFurnaceEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        AlloyFurnaceEntity.this.fuelTime = value;
                        break;
                    }
                    case 2: {
                        AlloyFurnaceEntity.this.maxFuelTime = value;
                    }
                }
            }

            public int method_17389() {
                return 3;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"screen.me.alloy_furnace");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new AlloyFurnaceScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("alloy_furnace.progress", this.progress);
        nbt.method_10569("alloy_furnace.fuel-time", this.fuelTime);
        nbt.method_10569("alloy_furnace.max-fuel-time", this.maxFuelTime);
    }

    public void method_11014(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt, this.inventory);
        super.method_11014(nbt);
        this.progress = nbt.method_10550("alloy_furnace.progress");
        this.fuelTime = nbt.method_10550("alloy_furnace.fuel-time");
        this.maxFuelTime = nbt.method_10550("alloy_furnace.max-fuel-time");
    }

    public class_1799 getRenderStack() {
        return this.method_5438(5);
    }

    public void setInventory(class_2371<class_1799> inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            this.inventory.set(i, (Object)((class_1799)inventory.get(i)));
        }
    }

    public void method_5431() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            class_2540 data = PacketByteBufs.create();
            data.writeInt(this.inventory.size());
            for (int i = 0; i < this.inventory.size(); ++i) {
                data.method_10793((class_1799)this.inventory.get(i));
            }
            data.method_10807(this.method_11016());
            for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016())) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ModNetworks.ITEM_SYNC, (class_2540)data);
            }
        }
        super.method_5431();
    }

    protected boolean isFuel(class_1792 item) {
        for (class_1792 item1 : this.fuelTimeMap.keySet()) {
            if (!item1.equals(item)) continue;
            return true;
        }
        return false;
    }

    public int[] method_5494(class_2350 side) {
        int[] slots = new int[this.inventory.size()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (slot == 0) {
            return this.isFuel(stack.method_7909());
        }
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot != 5;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, AlloyFurnaceEntity entity) {
        if (world.method_8608()) {
            return;
        }
        entity.fuelTime = Math.max(0, entity.fuelTime - 1);
        boolean progress = false;
        if (AlloyFurnaceEntity.hasRecipe(entity) && entity.hasFuel(entity)) {
            ++entity.progress;
            progress = true;
            AlloyFurnaceEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)blockState);
            if (entity.progress >= 1200) {
                AlloyFurnaceEntity.craftItem(entity);
                entity.progress = 0;
            }
        }
        if (!progress) {
            entity.progress = Math.max(entity.progress - 2, 0);
            AlloyFurnaceEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)blockState);
        }
        boolean isCooking = entity.fuelTime > 0;
        blockState = (class_2680)blockState.method_11657((class_2769)class_2363.field_11105, (Comparable)Boolean.valueOf(isCooking));
        world.method_8652(blockPos, blockState, 3);
    }

    private static void craftItem(AlloyFurnaceEntity entity) {
        class_1277 inventory1 = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory1.method_5447(i, entity.method_5438(i));
        }
        Optional match = entity.method_10997().method_8433().method_8132((class_3956)AlloyRecipe.Type.INSTANCE, (class_1263)inventory1, entity.method_10997());
        if (match.isEmpty()) {
            throw new RuntimeException("Somehow... you crafted an item without recipe?!");
        }
        if (AlloyFurnaceEntity.hasRecipe(entity)) {
            for (int i = 1; i <= 4; ++i) {
                entity.method_5434(i, 1);
            }
            entity.method_5447(5, new class_1799(((AlloyRecipe)match.get()).output.method_41409(), entity.method_5438(5).method_7947() + ((AlloyRecipe)match.get()).output.method_7947()));
            entity.method_5431();
        }
    }

    private static boolean hasRecipe(AlloyFurnaceEntity entity) {
        class_1277 inventory1 = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory1.method_5447(i, entity.method_5438(i));
        }
        Optional match = entity.method_10997().method_8433().method_8132((class_3956)AlloyRecipe.Type.INSTANCE, (class_1263)inventory1, entity.method_10997());
        if (match.isEmpty()) {
            return false;
        }
        return AlloyFurnaceEntity.canInsertAmountIntoOutput(inventory1, ((AlloyRecipe)match.get()).output.method_7947()) && AlloyFurnaceEntity.canInsertRecipeIntoOutput(inventory1, ((AlloyRecipe)match.get()).output.method_7909());
    }

    private boolean hasFuel(AlloyFurnaceEntity entity) {
        class_1277 inventory1 = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory1.method_5447(i, entity.method_5438(i));
        }
        class_1792 fuelItem = inventory1.method_5438(0).method_7909();
        if (this.fuelTime > 0) {
            return true;
        }
        if (this.isFuel(fuelItem)) {
            this.getFuel(entity, fuelItem);
            return true;
        }
        return false;
    }

    private void getFuel(AlloyFurnaceEntity entity, class_1792 fuelItem) {
        this.maxFuelTime = this.fuelTime = Math.round(this.fuelTimeMap.get(fuelItem) / 16);
        if (fuelItem == class_1802.field_8187) {
            entity.method_5441(0);
            entity.method_5447(0, class_1802.field_8550.method_7854());
        } else {
            entity.method_5438(0).method_7934(1);
        }
    }

    private static boolean canInsertAmountIntoOutput(class_1277 inventory1, int count) {
        return inventory1.method_5438(5).method_7914() > inventory1.method_5438(5).method_7947() + (count - 1);
    }

    private static boolean canInsertRecipeIntoOutput(class_1277 inventory1, class_1792 item) {
        return inventory1.method_5438(5).method_7909() == item || inventory1.method_5438(5).method_7960();
    }
}

