/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.mekanismtweaks.mixin;

import dev.felnull.mekanismtweaks.Utils;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Upgrade;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={UpgradeUtils.class}, remap=false)
public class MixinUpgradeUtils {
    @Overwrite
    public static List<ITextComponent> getExpScaledInfo(IUpgradeTile tile, Upgrade upgrade) {
        ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
        if (tile.supportsUpgrades() && upgrade.getMax() > 1) {
            ret.add((ITextComponent)MekanismLang.UPGRADES_EFFECT.translate(new Object[]{Utils.time(tile)}));
        }
        return ret;
    }

    @Overwrite
    public static List<ITextComponent> getMultScaledInfo(IUpgradeTile tile, Upgrade upgrade) {
        ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
        if (tile.supportsUpgrades() && upgrade.getMax() > 1) {
            double effect = upgrade == Upgrade.ENERGY ? Utils.capacity(tile) : (upgrade == Upgrade.SPEED ? Utils.time(tile) : Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), (float)tile.getComponent().getUpgrades(upgrade) / (float)upgrade.getMax()));
            ret.add((ITextComponent)MekanismLang.UPGRADES_EFFECT.translate(new Object[]{Utils.exponential(effect)}));
        }
        return ret;
    }
}

