/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.value.CachedValue;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.material.IPaxelMaterial;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.material.VanillaPaxelMaterialCreator;
import mekanism.tools.common.util.ToolsUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class ItemMekanismPaxel
extends ToolItem
implements IHasRepairType,
IAttributeRefresher {
    private static final ToolType PAXEL_TOOL_TYPE = ToolType.get((String)"paxel");
    private final IPaxelMaterial material;
    private final AttributeCache attributeCache;

    private static Item.Properties addHarvestLevel(Item.Properties properties, IPaxelMaterial material) {
        int harvestLevel = material.getPaxelHarvestLevel();
        return properties.addToolType(ToolType.AXE, harvestLevel).addToolType(ToolType.PICKAXE, harvestLevel).addToolType(ToolType.SHOVEL, harvestLevel).addToolType(PAXEL_TOOL_TYPE, harvestLevel);
    }

    public ItemMekanismPaxel(MaterialCreator material, Item.Properties properties) {
        super(material.getPaxelDamage(), material.getPaxelAtkSpeed(), (IItemTier)material, Collections.emptySet(), ItemMekanismPaxel.addHarvestLevel(properties, material));
        this.material = material;
        this.attributeCache = new AttributeCache((IAttributeRefresher)this, new CachedValue[]{material.attackDamage, material.paxelDamage, material.paxelAtkSpeed});
    }

    public ItemMekanismPaxel(VanillaPaxelMaterialCreator material, Item.Properties properties) {
        super(material.getPaxelDamage(), material.getPaxelAtkSpeed(), (IItemTier)material.getVanillaTier(), Collections.emptySet(), ItemMekanismPaxel.addHarvestLevel(properties, material));
        this.material = material;
        this.attributeCache = new AttributeCache((IAttributeRefresher)this, new CachedValue[]{material.paxelDamage, material.paxelAtkSpeed});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        ToolsUtils.addDurability(tooltip, stack);
    }

    public float func_234675_d_() {
        return this.material.getPaxelDamage() + this.func_200891_e().func_200929_c();
    }

    private int getHarvestLevel() {
        return this.material.getPaxelHarvestLevel();
    }

    public boolean func_150897_b(BlockState state) {
        ToolType harvestTool = state.getHarvestTool();
        if ((harvestTool == ToolType.AXE || harvestTool == ToolType.PICKAXE || harvestTool == ToolType.SHOVEL) && this.getHarvestLevel() >= state.getHarvestLevel()) {
            return true;
        }
        if (state.func_203425_a(Blocks.field_150433_aE) || state.func_203425_a(Blocks.field_196604_cC)) {
            return true;
        }
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
    }

    public float func_150893_a(@Nonnull ItemStack stack, BlockState state) {
        block3: {
            block2: {
                Material material = state.func_185904_a();
                if (material == Material.field_151573_f || material == Material.field_151574_g || material == Material.field_151576_e || AxeItem.field_234662_c_.contains(material)) break block2;
                if (!this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) && !this.field_150914_c.contains(state.func_177230_c())) break block3;
            }
            return this.material.getPaxelEfficiency();
        }
        return 1.0f;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        BlockState blockstate = world.func_180495_p(blockpos);
        BlockState resultToSet = blockstate.getToolModifiedState(world, blockpos, player, stack, ToolType.AXE);
        if (resultToSet != null) {
            world.func_184133_a(player, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            if (context.func_196000_l() == Direction.DOWN) {
                return ActionResultType.PASS;
            }
            BlockState foundResult = blockstate.getToolModifiedState(world, blockpos, player, stack, ToolType.SHOVEL);
            if (foundResult != null && world.func_175623_d(blockpos.func_177984_a())) {
                world.func_184133_a(player, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                resultToSet = foundResult;
            } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
                if (!world.field_72995_K) {
                    world.func_217378_a(null, 1009, blockpos, 0);
                }
                CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)blockpos, (BlockState)blockstate);
                resultToSet = (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
            }
        }
        if (resultToSet == null) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            world.func_180501_a(blockpos, resultToSet, 11);
            if (player != null) {
                stack.func_222118_a(1, (LivingEntity)player, onBroken -> onBroken.func_213334_d(context.func_221531_n()));
            }
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    public int func_77619_b() {
        return this.material.getPaxelEnchantability();
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.func_200891_e().func_200924_f();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getPaxelMaxUses();
    }

    public boolean func_77645_m() {
        return this.material.getPaxelMaxUses() > 0;
    }

    public int getHarvestLevel(@Nonnull ItemStack stack, @Nonnull ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (tool == ToolType.AXE || tool == ToolType.PICKAXE || tool == ToolType.SHOVEL || tool == PAXEL_TOOL_TYPE) {
            return this.getHarvestLevel();
        }
        return super.getHarvestLevel(stack, tool, player, blockState);
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, @Nonnull ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeCache.getAttributes() : ImmutableMultimap.of();
    }

    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.func_234675_d_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.material.getPaxelAtkSpeed(), AttributeModifier.Operation.ADDITION));
    }
}

