/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import mekanism.api.text.ILangEntry;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlockTypes;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;

public class TurbineValidator
extends CuboidStructureValidator<TurbineMultiblockData> {
    public static final int MAX_BLADES = 28;

    public TurbineValidator() {
        super(new VoxelCuboid(3, 3, 3), new VoxelCuboid(17, 18, 17));
    }

    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.func_177230_c();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.TURBINE_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.TURBINE_VALVE})) {
            return FormationProtocol.CasingType.VALVE;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.TURBINE_VENT})) {
            return FormationProtocol.CasingType.OTHER;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    protected boolean validateInner(BlockState state, Long2ObjectMap<IChunk> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        return BlockType.is((Block)state.func_177230_c(), (BlockType[])new BlockType[]{MekanismBlockTypes.PRESSURE_DISPERSER, GeneratorsBlockTypes.TURBINE_ROTOR, GeneratorsBlockTypes.ROTATIONAL_COMPLEX, GeneratorsBlockTypes.ELECTROMAGNETIC_COIL, GeneratorsBlockTypes.SATURATING_CONDENSER});
    }

    public FormationProtocol.FormationResult postcheck(TurbineMultiblockData structure, Set<BlockPos> innerNodes, Long2ObjectMap<IChunk> chunkMap) {
        if (structure.length() % 2 != 1 || structure.width() % 2 != 1) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_EVEN_LENGTH);
        }
        int centerX = structure.getMinPos().func_177958_n() + (structure.length() - 1) / 2;
        int centerZ = structure.getMinPos().func_177952_p() + (structure.width() - 1) / 2;
        BlockPos complex = null;
        ObjectOpenHashSet turbines = new ObjectOpenHashSet();
        ObjectOpenHashSet dispersers = new ObjectOpenHashSet();
        ObjectOpenHashSet coils = new ObjectOpenHashSet();
        ObjectOpenHashSet condensers = new ObjectOpenHashSet();
        for (BlockPos pos : innerNodes) {
            TileEntity tile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, (BlockPos)pos);
            if (tile instanceof TileEntityRotationalComplex) {
                if (complex != null || pos.func_177958_n() != centerX || pos.func_177952_p() != centerZ) {
                    return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_BAD_COMPLEX, (BlockPos)pos);
                }
                structure.internalLocations.add(pos);
                complex = pos;
                continue;
            }
            if (tile instanceof TileEntityTurbineRotor) {
                if (pos.func_177958_n() != centerX || pos.func_177952_p() != centerZ) {
                    return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_BAD_ROTOR, (BlockPos)pos);
                }
                turbines.add(pos);
                continue;
            }
            if (tile instanceof TileEntityPressureDisperser) {
                dispersers.add(pos);
                continue;
            }
            if (tile instanceof TileEntityElectromagneticCoil) {
                coils.add(pos);
                continue;
            }
            if (!(tile instanceof TileEntitySaturatingCondenser)) continue;
            condensers.add(pos);
        }
        if (complex == null) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MISSING_COMPLEX);
        }
        int rotors = complex.func_177956_o() - structure.getMinPos().func_177956_o() + 1;
        int innerRadius = (Math.min(structure.length(), structure.width()) - 3) / 2;
        if (innerRadius < rotors / 4) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_TOO_NARROW);
        }
        if (coils.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MISSING_COILS);
        }
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = complex.func_177958_n() - innerRadius; x <= complex.func_177958_n() + innerRadius; ++x) {
            for (int z = complex.func_177952_p() - innerRadius; z <= complex.func_177952_p() + innerRadius; ++z) {
                if (x == centerX && z == centerZ) continue;
                mutablePos.func_181079_c(x, complex.func_177956_o(), z);
                TileEntityPressureDisperser tile = (TileEntityPressureDisperser)WorldUtils.getTileEntity(TileEntityPressureDisperser.class, (IWorld)this.world, chunkMap, (BlockPos)mutablePos);
                if (tile == null) {
                    return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MISSING_DISPERSER, (BlockPos)mutablePos);
                }
                dispersers.remove(mutablePos);
            }
        }
        if (!dispersers.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MALFORMED_DISPERSERS);
        }
        for (BlockPos coord2 : condensers) {
            if (coord2.func_177956_o() > complex.func_177956_o()) continue;
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_CONDENSER_BELOW_COMPLEX, (BlockPos)coord2);
        }
        structure.condensers = condensers.size();
        int turbineHeight = 0;
        int blades = 0;
        for (int y = complex.func_177956_o() - 1; y > structure.getMinPos().func_177956_o(); --y) {
            mutablePos.func_181079_c(centerX, y, centerZ);
            TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)WorldUtils.getTileEntity(TileEntityTurbineRotor.class, (IWorld)this.world, chunkMap, (BlockPos)mutablePos);
            if (rotor == null) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_ROTORS_NOT_CONTIGUOUS);
            }
            ++turbineHeight;
            blades += rotor.getHousedBlades();
            structure.internalLocations.add(rotor.func_174877_v());
            turbines.remove(mutablePos);
        }
        if (!turbines.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_BAD_ROTORS);
        }
        structure.blades = blades;
        BlockPos startCoord = complex.func_177972_a(Direction.UP);
        if (WorldUtils.getTileEntity(TileEntityElectromagneticCoil.class, (IWorld)this.world, chunkMap, (BlockPos)startCoord) != null) {
            structure.coils = FormationProtocol.explore((BlockPos)startCoord, coord -> WorldUtils.getTileEntity(TileEntityElectromagneticCoil.class, (IWorld)this.world, (Long2ObjectMap)chunkMap, (BlockPos)coord) != null);
        }
        if (coils.size() > structure.coils) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_MALFORMED_COILS);
        }
        for (BlockPos coord3 : structure.locations) {
            if (WorldUtils.getTileEntity(TileEntityTurbineVent.class, (IWorld)this.world, chunkMap, (BlockPos)coord3) == null) continue;
            if (coord3.func_177956_o() < complex.func_177956_o()) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.TURBINE_INVALID_VENT_BELOW_COMPLEX, (BlockPos)coord3);
            }
            ++structure.vents;
        }
        structure.lowerVolume = structure.length() * structure.width() * turbineHeight;
        structure.complex = complex;
        return FormationProtocol.FormationResult.SUCCESS;
    }
}

