/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IGasProvider;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.MekanismLang;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class FissionReactorRecipeCategory
extends BaseRecipeCategory<FissionJEIRecipe> {
    private static final ResourceLocation iconRL = MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"radioactive.png");
    private final GuiGauge<?> coolantTank;
    private final GuiGauge<?> fuelTank;
    private final GuiGauge<?> heatedCoolantTank;
    private final GuiGauge<?> wasteTank;

    public FissionReactorRecipeCategory(IGuiHelper helper, ResourceLocation id) {
        super(helper, id, (ITextComponent)GeneratorsLang.FISSION_REACTOR.translate(new Object[0]), FissionReactorRecipeCategory.createIcon((IGuiHelper)helper, (ResourceLocation)iconRL), 6, 13, 182, 60);
        this.addElement((GuiTexturedElement)new GuiInnerScreen((IGuiWrapper)this, 45, 17, 105, 56, () -> Arrays.asList(MekanismLang.STATUS.translate(new Object[]{EnumColor.BRIGHT_GREEN, BooleanStateDisplay.ActiveDisabled.of((boolean)true)}), GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{1.0}), GeneratorsLang.FISSION_HEATING_RATE.translate(new Object[]{0}), MekanismLang.TEMPERATURE.translate(new Object[]{EnumColor.BRIGHT_GREEN, MekanismUtils.getTemperatureDisplay((double)300.0, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), GeneratorsLang.FISSION_DAMAGE.translate(new Object[]{EnumColor.BRIGHT_GREEN, TextUtils.getPercent((double)0.0)}))).spacing(2));
        this.coolantTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiFluidGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)6, (int)13).setLabel((ITextComponent)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.fuelTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)25, (int)13).setLabel((ITextComponent)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN, new Object[0])));
        this.heatedCoolantTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)152, (int)13).setLabel((ITextComponent)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.GRAY, new Object[0])));
        this.wasteTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)171, (int)13).setLabel((ITextComponent)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN, new Object[0])));
    }

    private List<FluidStack> getWaterInput(FissionJEIRecipe recipe) {
        int amount = MathUtils.clampToInt((long)recipe.outputCoolant.getAmount());
        return FluidTags.field_206959_a.func_230236_b_().stream().map(fluid -> new FluidStack(fluid, amount)).collect(Collectors.toList());
    }

    @Nonnull
    public Class<? extends FissionJEIRecipe> getRecipeClass() {
        return FissionJEIRecipe.class;
    }

    public void setIngredients(FissionJEIRecipe recipe, @Nonnull IIngredients ingredients) {
        if (recipe.inputCoolant == null) {
            ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(this.getWaterInput(recipe)));
            ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(recipe.fuel.getRepresentations()));
        } else {
            ingredients.setInputLists(MekanismJEI.TYPE_GAS, Arrays.asList(recipe.inputCoolant.getRepresentations(), recipe.fuel.getRepresentations()));
        }
        ingredients.setOutputs(MekanismJEI.TYPE_GAS, Arrays.asList(recipe.outputCoolant, recipe.waste));
    }

    public void setRecipe(IRecipeLayout recipeLayout, FissionJEIRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        int chemicalTankIndex = 0;
        if (recipe.inputCoolant == null) {
            this.initFluid(recipeLayout.getFluidStacks(), 0, true, this.coolantTank, this.getWaterInput(recipe));
        } else {
            this.initChemical(gasStacks, chemicalTankIndex++, true, this.coolantTank, recipe.inputCoolant.getRepresentations());
        }
        this.initChemical(gasStacks, chemicalTankIndex++, true, this.fuelTank, recipe.fuel.getRepresentations());
        this.initChemical(gasStacks, chemicalTankIndex++, false, this.heatedCoolantTank, Collections.singletonList(recipe.outputCoolant));
        this.initChemical(gasStacks, chemicalTankIndex, false, this.wasteTank, Collections.singletonList(recipe.waste));
    }

    public static List<FissionJEIRecipe> getFissionRecipes() {
        ArrayList<FissionJEIRecipe> recipes = new ArrayList<FissionJEIRecipe>();
        double energyPerFuel = ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFissionFuel.get()).doubleValue();
        long coolantAmount = Math.round(energyPerFuel * HeatUtils.getSteamEnergyEfficiency() / HeatUtils.getWaterThermalEnthalpy());
        recipes.add(new FissionJEIRecipe(null, GasStackIngredient.from((IGasProvider)MekanismGases.FISSILE_FUEL, (long)1L), MekanismGases.STEAM.getStack(coolantAmount), MekanismGases.NUCLEAR_WASTE.getStack(1L)));
        for (Gas gas : MekanismAPI.gasRegistry()) {
            GasAttributes.CooledCoolant cooledCoolant = (GasAttributes.CooledCoolant)gas.get(GasAttributes.CooledCoolant.class);
            if (cooledCoolant == null) continue;
            Gas heatedCoolant = cooledCoolant.getHeatedGas();
            coolantAmount = Math.round(energyPerFuel / cooledCoolant.getThermalEnthalpy());
            recipes.add(new FissionJEIRecipe(GasStackIngredient.from((IGasProvider)gas, (long)coolantAmount), GasStackIngredient.from((IGasProvider)MekanismGases.FISSILE_FUEL, (long)1L), heatedCoolant.getStack(coolantAmount), MekanismGases.NUCLEAR_WASTE.getStack(1L)));
        }
        return recipes;
    }

    public static class FissionJEIRecipe {
        @Nullable
        private final GasStackIngredient inputCoolant;
        private final GasStackIngredient fuel;
        private final GasStack outputCoolant;
        private final GasStack waste;

        public FissionJEIRecipe(@Nullable GasStackIngredient inputCoolant, GasStackIngredient fuel, GasStack outputCoolant, GasStack waste) {
            this.inputCoolant = inputCoolant;
            this.fuel = fuel;
            this.outputCoolant = outputCoolant;
            this.waste = waste;
        }
    }
}

