/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.additions.client.model.AdditionsModelCache;
import mekanism.additions.common.MekanismAdditions;
import mekanism.additions.common.entity.EntityBalloon;
import mekanism.api.text.EnumColor;
import mekanism.client.model.BaseModelCache;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class RenderBalloon
extends EntityRenderer<EntityBalloon> {
    public static final ResourceLocation BALLOON_TEXTURE = MekanismAdditions.rl("textures/item/balloon.png");

    public RenderBalloon(EntityRendererManager renderManager) {
        super(renderManager);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull EntityBalloon entity) {
        return BALLOON_TEXTURE;
    }

    public void render(@Nonnull EntityBalloon balloon, float entityYaw, float partialTick, @Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(-0.5, -1.0, -0.5);
        if (balloon.isLatchedToEntity()) {
            double x = balloon.latchedEntity.field_70142_S + (balloon.latchedEntity.func_226277_ct_() - balloon.latchedEntity.field_70142_S) * (double)partialTick - (balloon.field_70142_S + (balloon.func_226277_ct_() - balloon.field_70142_S) * (double)partialTick);
            double y = balloon.latchedEntity.field_70137_T + (balloon.latchedEntity.func_226278_cu_() - balloon.latchedEntity.field_70137_T) * (double)partialTick - (balloon.field_70137_T + (balloon.func_226278_cu_() - balloon.field_70137_T) * (double)partialTick) + balloon.getAddedHeight();
            double z = balloon.latchedEntity.field_70136_U + (balloon.latchedEntity.func_226281_cx_() - balloon.latchedEntity.field_70136_U) * (double)partialTick - (balloon.field_70136_U + (balloon.func_226281_cx_() - balloon.field_70136_U) * (double)partialTick);
            matrix.func_227861_a_(x, y, z);
        }
        BaseModelCache.JSONModelData model = balloon.isLatched() ? AdditionsModelCache.INSTANCE.BALLOON : AdditionsModelCache.INSTANCE.BALLOON_FREE;
        List quads = model.getBakedModel().func_200117_a(null, null, balloon.field_70170_p.field_73012_v);
        RenderType renderType = RenderType.func_228644_e_((ResourceLocation)AtlasTexture.field_110575_b);
        IVertexBuilder builder = renderer.getBuffer(renderType);
        MatrixStack.Entry last = matrix.func_227866_c_();
        for (BakedQuad quad : quads) {
            float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            if (quad.func_178211_c() == 0) {
                EnumColor balloonColor = balloon.getColor();
                color[0] = balloonColor.getColor(0);
                color[1] = balloonColor.getColor(1);
                color[2] = balloonColor.getColor(2);
            }
            builder.addVertexData(last, quad, color[0], color[1], color[2], color[3], light, OverlayTexture.field_229196_a_);
        }
        ((IRenderTypeBuffer.Impl)renderer).func_228462_a_(renderType);
        matrix.func_227865_b_();
        super.func_225623_a_((Entity)balloon, entityYaw, partialTick, matrix, renderer, light);
    }
}

