/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.PaintingRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.chemical.ItemStackChemicalToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.PigmentInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;

public class TileEntityPaintingMachine
extends TileEntityProgressMachine<PaintingRecipe>
implements IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<Pigment, PigmentStack, PaintingRecipe> {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getPigmentInput", "getPigmentInputCapacity", "getPigmentInputNeeded", "getPigmentInputFilledPercentage"})
    public IPigmentTank pigmentTank;
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final IInputHandler<@NonNull PigmentStack> pigmentInputHandler;
    private MachineEnergyContainer<TileEntityPaintingMachine> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputPigmentItem"})
    private PigmentInventorySlot pigmentInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutput"})
    private OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityPaintingMachine() {
        super(MekanismBlocks.PAINTING_MACHINE, 200);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.PIGMENT, TransmissionType.ENERGY);
        this.configComponent.setupItemIOExtraConfig(this.inputSlot, this.outputSlot, this.pigmentInputSlot, this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.PIGMENT, this.pigmentTank);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
        this.itemInputHandler = InputHelper.getInputHandler(this.inputSlot);
        this.pigmentInputHandler = InputHelper.getInputHandler(this.pigmentTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputSlot);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks() {
        ChemicalTankHelper<Pigment, PigmentStack, IPigmentTank> builder = ChemicalTankHelper.forSidePigmentWithConfig(this::getDirection, this::getConfig);
        this.pigmentTank = ChemicalTankBuilder.PIGMENT.input(15000L, pigment -> this.containsRecipeBA(this.inputSlot.getStack(), (Chemical)pigment), this::containsRecipeB, this.recipeCacheLookupMonitor);
        builder.addTank(this.pigmentTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.pigmentInputSlot = PigmentInventorySlot.fill(this.pigmentTank, this, 6, 56);
        builder.addSlot(this.pigmentInputSlot);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipeAB(item, this.pigmentTank.getStack()), this::containsRecipeA, (IContentsListener)this.recipeCacheLookupMonitor, 45, 35);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(this, 116, 35);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityPaintingMachine)this).func_145831_w(), this, 144, 35);
        builder.addSlot(this.energySlot);
        this.pigmentInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.pigmentInputSlot.fillTankOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Override
    @Nonnull
    public MekanismRecipeType<PaintingRecipe, InputRecipeCache.ItemChemical<Pigment, PigmentStack, PaintingRecipe>> getRecipeType() {
        return MekanismRecipeType.PAINTING;
    }

    @Override
    @Nullable
    public PaintingRecipe getRecipe(int cacheIndex) {
        return (PaintingRecipe)this.findFirstRecipe(this.itemInputHandler, this.pigmentInputHandler);
    }

    @Override
    @Nonnull
    public CachedRecipe<PaintingRecipe> createNewCachedRecipe(@Nonnull PaintingRecipe recipe, int cacheIndex) {
        return new ItemStackChemicalToItemStackCachedRecipe(recipe, this.itemInputHandler, this.pigmentInputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    public MachineEnergyContainer<TileEntityPaintingMachine> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod
    private FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }
}

