/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.chemical.ChemicalToChemicalCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.world.IWorld;

public class TileEntityIsotopicCentrifuge
extends TileEntityRecipeMachine<GasToGasRecipe>
implements IBoundingBlock,
ISingleRecipeLookupHandler.ChemicalRecipeLookupHandler<Gas, GasStack, GasToGasRecipe> {
    public static final int MAX_GAS = 10000;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"})
    public IGasTank inputTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"})
    public IGasTank outputTank;
    private FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull GasStack> inputHandler;
    private MachineEnergyContainer<TileEntityIsotopicCentrifuge> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private GasInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private GasInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityIsotopicCentrifuge() {
        super(MekanismBlocks.ISOTOPIC_CENTRIFUGE);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.ENERGY);
        this.configComponent.setupItemIOConfig(this.inputSlot, this.outputSlot, this.energySlot);
        this.configComponent.setupIOConfig(TransmissionType.GAS, this.inputTank, this.outputTank, RelativeSide.FRONT, false, true).setEjecting(true);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.configComponent.addDisabledSides(RelativeSide.TOP);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.GAS).setCanTankEject(tank -> tank != this.inputTank);
        this.inputHandler = InputHelper.getInputHandler(this.inputTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.inputTank = ChemicalTankBuilder.GAS.create(10000L, (type, automationType) -> automationType != AutomationType.EXTERNAL || this.outputTank.isEmpty() && type.has(GasAttributes.Radiation.class), ChemicalTankBuilder.GAS.alwaysTrueBi, this::containsRecipe, ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this.recipeCacheLookupMonitor);
        builder.addTank(this.inputTank);
        this.outputTank = ChemicalTankBuilder.GAS.output(10000L, this);
        builder.addTank(this.outputTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputSlot = GasInventorySlot.fill(this.inputTank, this, 5, 56);
        builder.addSlot(this.inputSlot);
        this.outputSlot = GasInventorySlot.drain(this.outputTank, this, 155, 56);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityIsotopicCentrifuge)this).func_145831_w(), this, 155, 14);
        builder.addSlot(this.energySlot);
        this.inputSlot.setSlotType(ContainerSlotType.INPUT);
        this.inputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.inputSlot.fillTank();
        this.outputSlot.drainTank();
        this.clientEnergyUsed = this.recipeCacheLookupMonitor.updateAndProcess(this.energyContainer);
    }

    @Nonnull
    @ComputerMethod(nameOverride="getEnergyUsage")
    public FloatingLong getEnergyUsed() {
        return this.clientEnergyUsed;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> getRecipeType() {
        return MekanismRecipeType.CENTRIFUGING;
    }

    @Override
    @Nullable
    public GasToGasRecipe getRecipe(int cacheIndex) {
        return (GasToGasRecipe)this.findFirstRecipe(this.inputHandler);
    }

    @Override
    @Nonnull
    public CachedRecipe<GasToGasRecipe> createNewCachedRecipe(@Nonnull GasToGasRecipe recipe, int cacheIndex) {
        return new ChemicalToChemicalCachedRecipe(recipe, this.inputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setOnFinish(() -> this.markDirty(false)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), currentMax);
        });
    }

    public MachineEnergyContainer<TileEntityIsotopicCentrifuge> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getCapacity());
    }

    @Override
    public void onPlace() {
        super.onPlace();
        WorldUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177984_a(), this.func_174877_v());
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177984_a(), false);
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(this::getEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }
}

