/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import mekanism.api.heat.HeatAPI;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.FuelInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeHooks;

public class TileEntityFuelwoodHeater
extends TileEntityMekanism {
    public int burnTime;
    public int maxBurnTime;
    private double lastEnvironmentLoss;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"})
    private FuelInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"})
    private BasicHeatCapacitor heatCapacitor;

    public TileEntityFuelwoodHeater() {
        super(MekanismBlocks.FUELWOOD_HEATER);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.fuelSlot = FuelInventorySlot.forFuel(ForgeHooks::getBurnTime, this, 15, 29);
        builder.addSlot(this.fuelSlot);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(CachedAmbientTemperature ambientTemperature) {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(this::getDirection);
        this.heatCapacitor = BasicHeatCapacitor.create(100.0, 5.0, 10.0, ambientTemperature, this);
        builder.addCapacitor(this.heatCapacitor);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.burnTime == 0) {
            this.maxBurnTime = this.burnTime = this.fuelSlot.burn();
        }
        if (this.burnTime > 0) {
            int ticks = Math.min(this.burnTime, MekanismConfig.general.fuelwoodTickMultiplier.get());
            this.burnTime -= ticks;
            this.heatCapacitor.handleHeat(MekanismConfig.general.heatPerFuelTick.get() * (double)ticks);
            this.setActive(true);
        } else {
            this.setActive(false);
        }
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastEnvironmentLoss = loss.getEnvironmentTransfer();
    }

    @ComputerMethod(nameOverride="getEnvironmentalLoss")
    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        this.burnTime = nbtTags.func_74762_e("burnTime");
        this.maxBurnTime = nbtTags.func_74762_e("maxBurnTime");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("burnTime", this.burnTime);
        nbtTags.func_74768_a("maxBurnTime", this.maxBurnTime);
        return nbtTags;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableInt.create(() -> this.burnTime, value -> {
            this.burnTime = value;
        }));
        container.track(SyncableInt.create(() -> this.maxBurnTime, value -> {
            this.maxBurnTime = value;
        }));
        container.track(SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }
}

