/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;

public class TileEntityLaserAmplifier
extends TileEntityLaserReceptor
implements IHasMode {
    private static final FloatingLong MAX = FloatingLong.createConst(5000000000L);
    private FloatingLong minThreshold = FloatingLong.ZERO;
    private FloatingLong maxThreshold = MAX;
    private int ticks = 0;
    private int delay = 0;
    private boolean emittingRedstone;
    private RedstoneOutput outputMode = RedstoneOutput.OFF;

    public TileEntityLaserAmplifier() {
        super(MekanismBlocks.LASER_AMPLIFIER);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    protected void addInitialEnergyContainers(EnergyContainerHelper builder) {
        this.energyContainer = LaserEnergyContainer.create(BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.internalOnly, this);
        builder.addContainer(this.energyContainer);
    }

    @Override
    protected void onUpdateServer() {
        this.setEmittingRedstone(false);
        this.ticks = this.ticks < this.delay ? ++this.ticks : 0;
        super.onUpdateServer();
        if (this.outputMode != RedstoneOutput.ENTITY_DETECTION) {
            this.setEmittingRedstone(false);
        }
    }

    @Override
    protected void setEmittingRedstone(boolean foundEntity) {
        this.emittingRedstone = foundEntity;
    }

    private boolean shouldFire() {
        return this.ticks >= this.delay && this.energyContainer.getEnergy().compareTo(this.minThreshold) >= 0 && MekanismUtils.canFunction(this);
    }

    @Override
    protected FloatingLong toFire() {
        return this.shouldFire() ? super.toFire().min(this.maxThreshold) : FloatingLong.ZERO;
    }

    @Override
    public int getRedstoneLevel() {
        if (this.outputMode == RedstoneOutput.ENERGY_CONTENTS) {
            return MekanismUtils.redstoneLevelFromContents(this.energyContainer.getEnergy(), this.energyContainer.getMaxEnergy());
        }
        return this.emittingRedstone ? 15 : 0;
    }

    @Override
    protected void notifyComparatorChange() {
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.getBlockType());
    }

    public void setDelay(int delay) {
        if (this.delay != (delay = Math.max(0, delay))) {
            this.delay = delay;
            this.markDirty(false);
        }
    }

    @Override
    public void nextMode() {
        this.outputMode = (RedstoneOutput)this.outputMode.getNext();
        this.markDirty(false);
    }

    public void setMinThresholdFromPacket(FloatingLong floatingLong) {
        FloatingLong threshold;
        FloatingLong maxEnergy = this.energyContainer.getMaxEnergy();
        FloatingLong floatingLong2 = threshold = maxEnergy.greaterThan(floatingLong) ? floatingLong : maxEnergy.copyAsConst();
        if (!this.minThreshold.equals(threshold)) {
            this.minThreshold = threshold;
            this.markDirty(false);
        }
    }

    public void setMaxThresholdFromPacket(FloatingLong floatingLong) {
        FloatingLong threshold;
        FloatingLong maxEnergy = this.energyContainer.getMaxEnergy();
        FloatingLong floatingLong2 = threshold = maxEnergy.greaterThan(floatingLong) ? floatingLong : maxEnergy.copyAsConst();
        if (!this.maxThreshold.equals(threshold)) {
            this.maxThreshold = threshold;
            this.markDirty(false);
        }
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        NBTUtils.setFloatingLongIfPresent(data, "min", value -> {
            this.minThreshold = value;
        });
        NBTUtils.setFloatingLongIfPresent(data, "max", value -> {
            this.maxThreshold = value;
        });
        NBTUtils.setIntIfPresent(data, "time", value -> {
            this.delay = value;
        });
        NBTUtils.setEnumIfPresent(data, "outputMode", RedstoneOutput::byIndexStatic, mode -> {
            this.outputMode = mode;
        });
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        data.func_74778_a("min", this.minThreshold.toString());
        data.func_74778_a("max", this.maxThreshold.toString());
        data.func_74768_a("time", this.delay);
        data.func_74768_a("outputMode", this.outputMode.ordinal());
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @ComputerMethod(nameOverride="getRedstoneOutputMode")
    public RedstoneOutput getOutputMode() {
        return this.outputMode;
    }

    @ComputerMethod
    public int getDelay() {
        return this.delay;
    }

    @ComputerMethod
    public FloatingLong getMinThreshold() {
        return this.minThreshold;
    }

    @ComputerMethod
    public FloatingLong getMaxThreshold() {
        return this.maxThreshold;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(this::getMinThreshold, value -> {
            this.minThreshold = value;
        }));
        container.track(SyncableFloatingLong.create(this::getMaxThreshold, value -> {
            this.maxThreshold = value;
        }));
        container.track(SyncableInt.create(this::getDelay, value -> {
            this.delay = value;
        }));
        container.track(SyncableEnum.create(RedstoneOutput::byIndexStatic, RedstoneOutput.OFF, this::getOutputMode, value -> {
            this.outputMode = value;
        }));
    }

    @ComputerMethod
    private void setRedstoneOutputMode(RedstoneOutput mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.outputMode != mode) {
            this.outputMode = mode;
            this.markDirty(false);
        }
    }

    @ComputerMethod(nameOverride="setDelay")
    private void computerSetDelay(int delay) throws ComputerException {
        this.validateSecurityIsPublic();
        if (delay < 0) {
            throw new ComputerException("Delay cannot be negative. Received: %d", delay);
        }
        this.setDelay(delay);
    }

    @ComputerMethod
    private void setMinThreshold(FloatingLong threshold) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setMinThresholdFromPacket(threshold);
    }

    @ComputerMethod
    private void setMaxThreshold(FloatingLong threshold) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setMaxThresholdFromPacket(threshold);
    }

    public static enum RedstoneOutput implements IIncrementalEnum<RedstoneOutput>,
    IHasTranslationKey
    {
        OFF(MekanismLang.OFF),
        ENTITY_DETECTION(MekanismLang.ENTITY_DETECTION),
        ENERGY_CONTENTS(MekanismLang.ENERGY_CONTENTS);

        private static final RedstoneOutput[] MODES;
        private final ILangEntry langEntry;

        private RedstoneOutput(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        @Nonnull
        public RedstoneOutput byIndex(int index) {
            return RedstoneOutput.byIndexStatic(index);
        }

        public static RedstoneOutput byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = RedstoneOutput.values();
        }
    }
}

