/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.base.ProcessInfo;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FactoryInputInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.upgrade.MachineUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;

public abstract class TileEntityFactory<RECIPE extends MekanismRecipe>
extends TileEntityConfigurableMachine
implements IRecipeLookupHandler<RECIPE> {
    protected static final int BASE_TICKS_REQUIRED = 200;
    protected FactoryRecipeCacheLookupMonitor<RECIPE>[] recipeCacheLookupMonitors;
    private final boolean[] activeStates;
    protected ProcessInfo[] processInfoSlots;
    public FactoryTier tier;
    public final int[] progress;
    private int ticksRequired = 200;
    private boolean sorting;
    private boolean sortingNeeded = true;
    private FloatingLong lastUsage = FloatingLong.ZERO;
    @Nonnull
    protected final FactoryType field_200663_e;
    protected MachineEnergyContainer<TileEntityFactory<?>> energyContainer;
    protected final List<IInventorySlot> inputSlots;
    protected final List<IInventorySlot> outputSlots;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    protected EnergyInventorySlot energySlot;

    protected TileEntityFactory(IBlockProvider blockProvider) {
        super(blockProvider);
        ConfigInfo itemConfig;
        this.field_200663_e = Attribute.get(blockProvider, AttributeFactoryType.class).getFactoryType();
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.inputSlots = new ArrayList<IInventorySlot>();
        this.outputSlots = new ArrayList<IInventorySlot>();
        for (ProcessInfo info : this.processInfoSlots) {
            this.inputSlots.add(info.getInputSlot());
            this.outputSlots.add(info.getOutputSlot());
            if (info.getSecondaryOutputSlot() == null) continue;
            this.outputSlots.add(info.getSecondaryOutputSlot());
        }
        this.configComponent.setupItemIOConfig(this.inputSlots, this.outputSlots, this.energySlot, false);
        IInventorySlot extraSlot = this.getExtraSlot();
        if (extraSlot != null && (itemConfig = this.configComponent.getConfig(TransmissionType.ITEM)) != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, new InventorySlotInfo(true, true, extraSlot));
            itemConfig.setDataType(DataType.EXTRA, RelativeSide.BOTTOM);
        }
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
        this.progress = new int[this.tier.processes];
        this.activeStates = new boolean[this.tier.processes];
    }

    private void onContentsChangedUpdateSorting() {
        this.onContentsChanged();
        this.sortingNeeded = true;
    }

    protected void onContentsChangedUpdateSortingAndCache() {
        this.onContentsChangedUpdateSorting();
        for (FactoryRecipeCacheLookupMonitor<RECIPE> cacheLookupMonitor : this.recipeCacheLookupMonitors) {
            cacheLookupMonitor.markMayHaveRecipe();
        }
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.tier = Attribute.getTier(this.getBlockType(), FactoryTier.class);
        Runnable setSortingNeeded = () -> {
            this.sortingNeeded = true;
        };
        this.recipeCacheLookupMonitors = new FactoryRecipeCacheLookupMonitor[this.tier.processes];
        for (int i = 0; i < this.recipeCacheLookupMonitors.length; ++i) {
            this.recipeCacheLookupMonitors[i] = new FactoryRecipeCacheLookupMonitor(this, i, setSortingNeeded);
        }
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.addSlots(builder, this::onContentsChangedUpdateSorting);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityFactory)this).func_145831_w(), this, 7, 13);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    protected abstract void addSlots(InventorySlotHelper var1, IContentsListener var2);

    @Nullable
    protected IInventorySlot getExtraSlot() {
        return null;
    }

    public FactoryType getFactoryType() {
        return this.field_200663_e;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.handleSecondaryFuel();
        if (this.sortingNeeded && this.isSorting()) {
            this.sortingNeeded = false;
            this.sortInventory();
        } else if (!this.sortingNeeded && CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.sortingNeeded = true;
        }
        FloatingLong prev = this.energyContainer.getEnergy().copy();
        for (int i = 0; i < this.recipeCacheLookupMonitors.length; ++i) {
            if (this.recipeCacheLookupMonitors[i].updateAndProcess()) continue;
            this.activeStates[i] = false;
        }
        boolean isActive = false;
        for (boolean state : this.activeStates) {
            if (!state) continue;
            isActive = true;
            break;
        }
        this.setActive(isActive);
        this.lastUsage = isActive ? prev.minusEqual(this.energyContainer.getEnergy()) : FloatingLong.ZERO;
    }

    public boolean inputProducesOutput(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, boolean updateCache) {
        return outputSlot.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputSlot, secondaryOutputSlot, updateCache) != null;
    }

    protected abstract boolean isCachedRecipeValid(@Nullable CachedRecipe<RECIPE> var1, @Nonnull ItemStack var2);

    @Nullable
    protected RECIPE getRecipeForInput(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, boolean updateCache) {
        CachedRecipe<RECIPE> cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && (cached = this.getCachedRecipe(process)) != null && this.isCachedRecipeValid(cached, fallbackInput)) {
            return cached.getRecipe();
        }
        RECIPE foundRecipe = this.findRecipe(process, fallbackInput, outputSlot, secondaryOutputSlot);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe(foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected abstract RECIPE findRecipe(int var1, @Nonnull ItemStack var2, @Nonnull IInventorySlot var3, @Nullable IInventorySlot var4);

    protected abstract int getNeededInput(RECIPE var1, ItemStack var2);

    @Nullable
    private CachedRecipe<RECIPE> getCachedRecipe(int cacheIndex) {
        return this.recipeCacheLookupMonitors[cacheIndex].getCachedRecipe(cacheIndex);
    }

    protected void setActiveState(boolean state, int cacheIndex) {
        this.activeStates[cacheIndex] = state;
    }

    protected void handleSecondaryFuel() {
    }

    public abstract boolean isValidInputItem(@Nonnull ItemStack var1);

    public int getProgress(int cacheIndex) {
        return this.progress[cacheIndex];
    }

    @Override
    public int getSavedOperatingTicks(int cacheIndex) {
        return this.getProgress(cacheIndex);
    }

    public double getScaledProgress(int i, int process) {
        return (double)this.getProgress(process) * (double)i / (double)this.ticksRequired;
    }

    public void toggleSorting() {
        this.sorting = !this.isSorting();
        this.markDirty(false);
    }

    @ComputerMethod(nameOverride="isAutoSortEnabled")
    public boolean isSorting() {
        return this.sorting;
    }

    @Nonnull
    @ComputerMethod(nameOverride="getEnergyUsage")
    public FloatingLong getLastUsage() {
        return this.lastUsage;
    }

    @ComputerMethod
    public int getTicksRequired() {
        return this.ticksRequired;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        if (nbtTags.func_150297_b("progress", 11)) {
            int[] savedProgress = nbtTags.func_74759_k("progress");
            if (this.tier.processes != savedProgress.length) {
                Arrays.fill(this.progress, 0);
            }
            for (int i = 0; i < this.tier.processes && i < savedProgress.length; ++i) {
                this.progress[i] = savedProgress[i];
            }
        } else {
            for (int i = 0; i < this.tier.processes; ++i) {
                this.progress[i] = nbtTags.func_74762_e("progress" + i);
            }
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_218657_a("progress", (INBT)new IntArrayNBT(Arrays.copyOf(this.progress, this.progress.length)));
        return nbtTags;
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        data.func_74757_a("sorting", this.isSorting());
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        NBTUtils.setBooleanIfPresent(data, "sorting", value -> {
            this.sorting = value;
        });
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, 200);
        }
    }

    @Override
    public List<ITextComponent> getInfo(Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    @Override
    public boolean isConfigurationDataCompatible(TileEntityType<?> tileType) {
        if (super.isConfigurationDataCompatible(tileType)) {
            return true;
        }
        for (FactoryTier factoryTier : EnumUtils.FACTORY_TIERS) {
            if (factoryTier == this.tier || MekanismTileEntityTypes.getFactoryTile(factoryTier, this.field_200663_e).get() != tileType) continue;
            return true;
        }
        return this.field_200663_e.getBaseMachine().getTileType() == tileType;
    }

    public boolean hasSecondaryResourceBar() {
        return false;
    }

    public MachineEnergyContainer<TileEntityFactory<?>> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.trackArray(this.progress);
        container.track(SyncableFloatingLong.create(this::getLastUsage, value -> {
            this.lastUsage = value;
        }));
        container.track(SyncableBoolean.create(this::isSorting, value -> {
            this.sorting = value;
        }));
        container.track(SyncableInt.create(this::getTicksRequired, value -> {
            this.ticksRequired = value;
        }));
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof MachineUpgradeData) {
            int i;
            MachineUpgradeData data = (MachineUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(data.energySlot.serializeNBT());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                this.inputSlots.get(i).deserializeNBT(data.inputSlots.get(i).serializeNBT());
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                this.outputSlots.get(i).setStack(data.outputSlots.get(i).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    protected void validateValidProcess(int process) throws ComputerException {
        if (process < 0 || process >= this.progress.length) {
            throw new ComputerException("Process: '%d' is out of bounds, as this factory only has '%d' processes (zero indexed).", process, this.progress.length);
        }
    }

    @ComputerMethod
    private void setAutoSort(boolean enabled) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.sorting != enabled) {
            this.sorting = enabled;
            this.markDirty(false);
        }
    }

    @ComputerMethod
    private int getRecipeProgress(int process) throws ComputerException {
        this.validateValidProcess(process);
        return this.getProgress(process);
    }

    @ComputerMethod
    private ItemStack getInput(int process) throws ComputerException {
        this.validateValidProcess(process);
        return this.processInfoSlots[process].getInputSlot().getStack();
    }

    @ComputerMethod
    private ItemStack getOutput(int process) throws ComputerException {
        this.validateValidProcess(process);
        return this.processInfoSlots[process].getOutputSlot().getStack();
    }

    private void sortInventory() {
        HashMap<HashedItem, RecipeProcessInfo> processes = new HashMap<HashedItem, RecipeProcessInfo>();
        ArrayList<ProcessInfo> emptyProcesses = new ArrayList<ProcessInfo>();
        for (ProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe<RECIPE> cachedRecipe;
            FactoryInputInventorySlot inputSlot = processInfo.getInputSlot();
            if (inputSlot.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ItemStack inputStack = inputSlot.getStack();
            HashedItem item = HashedItem.raw(inputStack);
            RecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(item, i -> new RecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            RecipeProcessInfo recipeProcessInfo2 = recipeProcessInfo;
            recipeProcessInfo2.totalCount = recipeProcessInfo2.totalCount + inputStack.func_190916_E();
            if (recipeProcessInfo.lazyMinPerSlot != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.getProcess()), inputStack)) continue;
            recipeProcessInfo.lazyMinPerSlot = () -> Math.max(1, this.getNeededInput(cachedRecipe.getRecipe(), inputStack));
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            RecipeProcessInfo recipeProcessInfo = (RecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerSlot != null) continue;
            recipeProcessInfo.lazyMinPerSlot = () -> {
                HashedItem item = (HashedItem)entry.getKey();
                ItemStack largerInput = item.createStack(Math.min(item.getStack().func_77976_d(), recipeProcessInfo.totalCount));
                ProcessInfo processInfo = (ProcessInfo)recipeProcessInfo.processes.get(0);
                RECIPE recipe = this.getRecipeForInput(processInfo.getProcess(), largerInput, processInfo.getOutputSlot(), processInfo.getSecondaryOutputSlot(), true);
                if (recipe != null) {
                    return Math.max(1, this.getNeededInput(recipe, largerInput));
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptySlotsAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    private void addEmptySlotsAsTargets(Map<HashedItem, RecipeProcessInfo> processes, List<ProcessInfo> emptyProcesses) {
        for (Map.Entry<HashedItem, RecipeProcessInfo> entry : processes.entrySet()) {
            int processCount;
            RecipeProcessInfo recipeProcessInfo = entry.getValue();
            int minPerSlot = recipeProcessInfo.getMinPerSlot();
            int maxSlots = recipeProcessInfo.totalCount / minPerSlot;
            if (maxSlots <= 1 || maxSlots <= (processCount = recipeProcessInfo.processes.size())) continue;
            ItemStack sourceStack = entry.getKey().getStack();
            int emptyToAdd = maxSlots - processCount;
            int added = 0;
            ArrayList<ProcessInfo> toRemove = new ArrayList<ProcessInfo>();
            for (ProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.getProcess(), sourceStack, emptyProcess.getOutputSlot(), emptyProcess.getSecondaryOutputSlot(), true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if (++added < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    private void distributeItems(Map<HashedItem, RecipeProcessInfo> processes) {
        for (Map.Entry<HashedItem, RecipeProcessInfo> entry : processes.entrySet()) {
            RecipeProcessInfo recipeProcessInfo = entry.getValue();
            int processCount = recipeProcessInfo.processes.size();
            if (processCount == 1) continue;
            HashedItem item = entry.getKey();
            int maxStackSize = item.getStack().func_77976_d();
            int numberPerSlot = recipeProcessInfo.totalCount / processCount;
            if (numberPerSlot == maxStackSize) continue;
            int remainder = recipeProcessInfo.totalCount % processCount;
            int minPerSlot = recipeProcessInfo.getMinPerSlot();
            if (minPerSlot > 1) {
                int perSlotRemainder = numberPerSlot % minPerSlot;
                if (perSlotRemainder > 0) {
                    numberPerSlot -= perSlotRemainder;
                    remainder += perSlotRemainder * processCount;
                }
                if (numberPerSlot + minPerSlot > maxStackSize) {
                    minPerSlot = maxStackSize - numberPerSlot;
                }
            }
            for (int i = 0; i < processCount; ++i) {
                ProcessInfo processInfo = (ProcessInfo)recipeProcessInfo.processes.get(i);
                FactoryInputInventorySlot inputSlot = processInfo.getInputSlot();
                int sizeForSlot = numberPerSlot;
                if (remainder > 0) {
                    if (remainder > minPerSlot) {
                        sizeForSlot += minPerSlot;
                        remainder -= minPerSlot;
                    } else {
                        sizeForSlot += remainder;
                        remainder = 0;
                    }
                }
                if (inputSlot.isEmpty()) {
                    if (sizeForSlot <= 0) continue;
                    inputSlot.setStackUnchecked(item.createStack(sizeForSlot));
                    continue;
                }
                if (sizeForSlot == 0) {
                    inputSlot.setEmpty();
                    continue;
                }
                if (inputSlot.getCount() == sizeForSlot) continue;
                MekanismUtils.logMismatchedStackSize(sizeForSlot, inputSlot.setStackSize(sizeForSlot, Action.EXECUTE));
            }
        }
    }

    private static class RecipeProcessInfo {
        private final List<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        @Nullable
        private IntSupplier lazyMinPerSlot;
        private int minPerSlot = 1;
        private int totalCount;

        private RecipeProcessInfo() {
        }

        public int getMinPerSlot() {
            if (this.lazyMinPerSlot != null) {
                this.minPerSlot = this.lazyMinPerSlot.getAsInt();
                this.lazyMinPerSlot = null;
            }
            return this.minPerSlot;
        }
    }
}

