/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMoveVehiclePacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TileEntityTeleporter
extends TileEntityMekanism
implements IChunkLoader {
    public final Set<UUID> didTeleport = new ObjectOpenHashSet();
    private AxisAlignedBB teleportBounds;
    public int teleDelay = 0;
    public boolean shouldRender;
    @Nullable
    private Direction frameDirection;
    private boolean frameRotated;
    private EnumColor color;
    public byte status = 0;
    private final TileComponentChunkLoader<TileEntityTeleporter> chunkLoaderComponent = new TileComponentChunkLoader<TileEntityTeleporter>(this);
    private MachineEnergyContainer<TileEntityTeleporter> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityTeleporter() {
        super(MekanismBlocks.TELEPORTER);
        this.frequencyComponent.track(FrequencyType.TELEPORTER, true, true, false);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.cacheCoord();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityTeleporter)this).func_145831_w(), this, 153, 7);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    public static void alignPlayer(ServerPlayerEntity player, BlockPos target, TileEntityTeleporter teleporter) {
        Direction side = null;
        if (teleporter.frameDirection != null && teleporter.frameDirection.func_176740_k().func_176722_c()) {
            side = teleporter.frameDirection;
        } else {
            for (Direction iterSide : MekanismUtils.SIDE_DIRS) {
                if (!player.field_70170_p.func_175623_d(target.func_177972_a(iterSide))) continue;
                side = iterSide;
                break;
            }
        }
        float yaw = player.field_70177_z;
        if (side != null) {
            switch (side) {
                case NORTH: {
                    yaw = 180.0f;
                    break;
                }
                case SOUTH: {
                    yaw = 0.0f;
                    break;
                }
                case WEST: {
                    yaw = 90.0f;
                    break;
                }
                case EAST: {
                    yaw = 270.0f;
                    break;
                }
            }
        }
        player.field_71135_a.func_147364_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), yaw, player.field_70125_A);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.teleportBounds == null && this.frameDirection != null) {
            this.resetBounds();
        }
        this.status = this.canTeleport();
        if (MekanismUtils.canFunction(this) && this.status == 1 && this.teleDelay == 0) {
            this.teleport();
        }
        if (this.teleDelay == 0 && this.teleportBounds != null && !this.didTeleport.isEmpty()) {
            this.cleanTeleportCache();
        }
        boolean prevShouldRender = this.shouldRender;
        this.shouldRender = this.status == 1 || this.status > 4;
        EnumColor prevColor = this.color;
        TeleporterFrequency freq = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        EnumColor enumColor = this.color = freq != null ? freq.getColor() : null;
        if (this.shouldRender != prevShouldRender) {
            WorldUtils.notifyLoadedNeighborsOfTileChange(this.field_145850_b, this.func_174877_v());
            this.sendUpdatePacket();
        } else if (this.color != prevColor) {
            this.sendUpdatePacket();
        }
        this.teleDelay = Math.max(0, this.teleDelay - 1);
        this.energySlot.fillContainerOrConvert();
    }

    @Nullable
    private Coord4D getClosest() {
        TeleporterFrequency frequency = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        return frequency == null ? null : frequency.getClosestCoords(this.getTileCoord());
    }

    private void cleanTeleportCache() {
        List inTeleporter = this.field_145850_b.func_217357_a(Entity.class, this.teleportBounds).stream().map(Entity::func_110124_au).collect(Collectors.toList());
        if (inTeleporter.isEmpty()) {
            this.didTeleport.clear();
        } else {
            this.didTeleport.removeIf(id -> !inTeleporter.contains(id));
        }
    }

    private void resetBounds() {
        this.teleportBounds = this.frameDirection == null ? null : this.getTeleporterBoundingBox(this.frameDirection);
    }

    private byte canTeleport() {
        Coord4D closestCoords;
        Direction direction = this.getFrameDirection();
        if (direction == null) {
            this.frameDirection = null;
            return 2;
        }
        if (this.frameDirection != direction) {
            this.frameDirection = direction;
            this.resetBounds();
        }
        if ((closestCoords = this.getClosest()) == null) {
            return 3;
        }
        FloatingLong sum = FloatingLong.ZERO;
        for (Entity entity : this.getToTeleport(this.field_145850_b.func_234923_W_() == closestCoords.dimension)) {
            sum = sum.plusEqual(TileEntityTeleporter.calculateEnergyCost(entity, closestCoords));
        }
        if (this.energyContainer.extract(sum, Action.SIMULATE, AutomationType.INTERNAL).smallerThan(sum)) {
            return 4;
        }
        return 1;
    }

    public BlockPos getTeleporterTargetPos() {
        if (this.frameDirection == null) {
            return this.field_174879_c.func_177984_a();
        }
        if (this.frameDirection == Direction.DOWN) {
            return this.field_174879_c.func_177979_c(2);
        }
        return this.field_174879_c.func_177972_a(this.frameDirection);
    }

    public void sendTeleportParticles() {
        BlockPos teleporterTargetPos = this.getTeleporterTargetPos();
        Direction offsetDirection = this.frameDirection == null || this.frameDirection.func_176740_k().func_200128_b() ? Direction.UP : this.frameDirection;
        Mekanism.packetHandler.sendToAllTracking(new PacketPortalFX(teleporterTargetPos, offsetDirection), this.field_145850_b, teleporterTargetPos);
    }

    private void teleport() {
        boolean sameDimension;
        List<Entity> entitiesToTeleport;
        BlockPos closestPos;
        Coord4D closestCoords = this.getClosest();
        if (closestCoords == null || this.field_145850_b == null) {
            return;
        }
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        ServerWorld teleWorld = currentServer.func_71218_a(closestCoords.dimension);
        TileEntityTeleporter teleporter = WorldUtils.getTileEntity(TileEntityTeleporter.class, (IBlockReader)teleWorld, closestPos = closestCoords.getPos());
        if (teleporter != null && !(entitiesToTeleport = this.getToTeleport(sameDimension = this.field_145850_b.func_234923_W_() == closestCoords.dimension)).isEmpty()) {
            Set<Coord4D> activeCoords = ((TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER)).getActiveCoords();
            BlockPos teleporterTargetPos = teleporter.getTeleporterTargetPos();
            for (Entity entity : entitiesToTeleport) {
                this.markTeleported(teleporter, entity, sameDimension);
                teleporter.teleDelay = 5;
                FloatingLong energyCost = TileEntityTeleporter.calculateEnergyCost(entity, closestCoords);
                double oldX = entity.func_226277_ct_();
                double oldY = entity.func_226278_cu_();
                double oldZ = entity.func_226281_cx_();
                Entity teleportedEntity = TileEntityTeleporter.teleportEntityTo(entity, (World)teleWorld, teleporterTargetPos);
                if (teleportedEntity instanceof ServerPlayerEntity) {
                    TileEntityTeleporter.alignPlayer((ServerPlayerEntity)teleportedEntity, teleporterTargetPos, teleporter);
                }
                for (Coord4D coords : activeCoords) {
                    Object world = this.field_145850_b.func_234923_W_() == coords.dimension ? this.field_145850_b : currentServer.func_71218_a(coords.dimension);
                    TileEntityTeleporter tile = WorldUtils.getTileEntity(TileEntityTeleporter.class, (IBlockReader)world, coords.getPos());
                    if (tile == null) continue;
                    tile.sendTeleportParticles();
                }
                this.energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.INTERNAL);
                if (teleportedEntity == null) continue;
                if (this.field_145850_b != teleportedEntity.field_70170_p || teleportedEntity.func_70092_e(oldX, oldY, oldZ) >= 25.0) {
                    this.field_145850_b.func_184148_a(null, oldX, oldY, oldZ, SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f);
                }
                teleportedEntity.field_70170_p.func_184148_a(null, teleportedEntity.func_226277_ct_(), teleportedEntity.func_226278_cu_(), teleportedEntity.func_226281_cx_(), SoundEvents.field_187534_aX, teleportedEntity.func_184176_by(), 1.0f, 1.0f);
            }
        }
    }

    private void markTeleported(TileEntityTeleporter teleporter, Entity entity, boolean sameDimension) {
        if (sameDimension || entity.func_184222_aU()) {
            teleporter.didTeleport.add(entity.func_110124_au());
            for (Entity passenger : entity.func_184188_bt()) {
                this.markTeleported(teleporter, passenger, sameDimension);
            }
        }
    }

    @Nullable
    public static Entity teleportEntityTo(Entity entity, World targetWorld, BlockPos target) {
        if (entity.func_130014_f_().func_234923_W_() == targetWorld.func_234923_W_()) {
            entity.func_70634_a((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5);
            if (!entity.func_184188_bt().isEmpty()) {
                ((ServerChunkProvider)entity.func_130014_f_().func_72863_F()).func_217218_b(entity, (IPacket)new SSetPassengersPacket(entity));
                Entity controller = entity.func_184179_bs();
                if (controller != entity && controller instanceof ServerPlayerEntity && !(controller instanceof FakePlayer)) {
                    ServerPlayerEntity player = (ServerPlayerEntity)controller;
                    if (player.field_71135_a != null) {
                        player.field_71135_a.func_147359_a((IPacket)new SMoveVehiclePacket(entity));
                    }
                }
            }
            return entity;
        }
        final Vector3d destination = new Vector3d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5);
        final List passengers = entity.func_184188_bt();
        return entity.changeDimension((ServerWorld)targetWorld, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                Entity repositionedEntity = repositionEntity.apply(false);
                if (repositionedEntity != null) {
                    for (Entity passenger : passengers) {
                        TileEntityTeleporter.teleportPassenger(destWorld, destination, repositionedEntity, passenger);
                    }
                }
                return repositionedEntity;
            }

            public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
                return new PortalInfo(destination, entity.func_213322_ci(), entity.field_70177_z, entity.field_70125_A);
            }

            public boolean playTeleportSound(ServerPlayerEntity player, ServerWorld sourceWorld, ServerWorld destWorld) {
                return false;
            }
        });
    }

    private static void teleportPassenger(ServerWorld destWorld, final Vector3d destination, final Entity repositionedEntity, Entity passenger) {
        if (!passenger.func_184222_aU()) {
            return;
        }
        final List passengers = passenger.func_184188_bt();
        passenger.changeDimension(destWorld, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                boolean invulnerable = entity.func_190530_aW();
                entity.func_184224_h(true);
                Entity repositionedPassenger = repositionEntity.apply(false);
                if (repositionedPassenger != null) {
                    repositionedPassenger.func_184205_a(repositionedEntity, true);
                    for (Entity passenger : passengers) {
                        TileEntityTeleporter.teleportPassenger(destWorld, destination, repositionedPassenger, passenger);
                    }
                    repositionedPassenger.func_184224_h(invulnerable);
                }
                entity.func_184224_h(invulnerable);
                return repositionedPassenger;
            }

            public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
                return new PortalInfo(destination, entity.func_213322_ci(), entity.field_70177_z, entity.field_70125_A);
            }

            public boolean playTeleportSound(ServerPlayerEntity player, ServerWorld sourceWorld, ServerWorld destWorld) {
                return false;
            }
        });
    }

    private List<Entity> getToTeleport(boolean sameDimension) {
        return this.field_145850_b == null || this.teleportBounds == null ? Collections.emptyList() : this.field_145850_b.func_175647_a(Entity.class, this.teleportBounds, entity -> !entity.func_175149_v() && !entity.func_184218_aH() && !(entity instanceof PartEntity) && (sameDimension || entity.func_184222_aU()) && !this.didTeleport.contains(entity.func_110124_au()));
    }

    @Nonnull
    public static FloatingLong calculateEnergyCost(Entity entity, Coord4D coords) {
        FloatingLong energyCost = (FloatingLong)MekanismConfig.usage.teleporterBase.get();
        energyCost = entity.field_70170_p.func_234923_W_() == coords.dimension ? energyCost.add(((FloatingLong)MekanismConfig.usage.teleporterDistance.get()).multiply(Math.sqrt(entity.func_70092_e((double)coords.getX(), (double)coords.getY(), (double)coords.getZ())))) : energyCost.add((FloatingLong)MekanismConfig.usage.teleporterDimensionPenalty.get());
        HashSet<Entity> passengers = new HashSet<Entity>();
        TileEntityTeleporter.fillIndirectPassengers(entity, entity.field_70170_p.func_234923_W_() == coords.dimension, passengers);
        int passengerCount = passengers.size();
        return passengerCount > 0 ? energyCost.multiply(passengerCount) : energyCost;
    }

    private static void fillIndirectPassengers(Entity base, boolean sameDimension, Set<Entity> passengers) {
        for (Entity entity : base.func_184188_bt()) {
            if (!sameDimension && !entity.func_184222_aU()) continue;
            passengers.add(entity);
            TileEntityTeleporter.fillIndirectPassengers(entity, sameDimension, passengers);
        }
    }

    @Nullable
    private Direction getFrameDirection() {
        for (Direction direction : EnumUtils.DIRECTIONS) {
            if (this.hasFrame(direction, false)) {
                this.frameRotated = false;
                return direction;
            }
            if (!this.hasFrame(direction, true)) continue;
            this.frameRotated = true;
            return direction;
        }
        return null;
    }

    private boolean hasFrame(Direction direction, boolean rotated) {
        int alternatingX = 0;
        int alternatingY = 0;
        int alternatingZ = 0;
        if (rotated) {
            if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                alternatingX = 1;
            } else {
                alternatingZ = 1;
            }
        } else if (direction == Direction.UP || direction == Direction.DOWN) {
            alternatingX = 1;
        } else {
            alternatingY = 1;
        }
        int xComponent = direction.func_82601_c();
        int yComponent = direction.func_96559_d();
        int zComponent = direction.func_82599_e();
        Long2ObjectArrayMap chunkMap = new Long2ObjectArrayMap(3);
        return this.isFramePair((Long2ObjectMap<IChunk>)chunkMap, 0, alternatingX, 0, alternatingY, 0, alternatingZ) && this.isFramePair((Long2ObjectMap<IChunk>)chunkMap, xComponent, alternatingX, yComponent, alternatingY, zComponent, alternatingZ) && this.isFramePair((Long2ObjectMap<IChunk>)chunkMap, 2 * xComponent, alternatingX, 2 * yComponent, alternatingY, 2 * zComponent, alternatingZ) && this.isFramePair((Long2ObjectMap<IChunk>)chunkMap, 3 * xComponent, alternatingX, 3 * yComponent, alternatingY, 3 * zComponent, alternatingZ) && this.isFrame((Long2ObjectMap<IChunk>)chunkMap, 3 * xComponent, 3 * yComponent, 3 * zComponent);
    }

    private boolean isFramePair(Long2ObjectMap<IChunk> chunkMap, int xOffset, int alternatingX, int yOffset, int alternatingY, int zOffset, int alternatingZ) {
        return this.isFrame(chunkMap, xOffset - alternatingX, yOffset - alternatingY, zOffset - alternatingZ) && this.isFrame(chunkMap, xOffset + alternatingX, yOffset + alternatingY, zOffset + alternatingZ);
    }

    private boolean isFrame(Long2ObjectMap<IChunk> chunkMap, int xOffset, int yOffset, int zOffset) {
        Optional<BlockState> state = WorldUtils.getBlockState((IWorld)this.field_145850_b, chunkMap, this.field_174879_c.func_177982_a(xOffset, yOffset, zOffset));
        return state.filter(blockState -> blockState.func_203425_a(MekanismBlocks.TELEPORTER_FRAME.getBlock())).isPresent();
    }

    @Nullable
    public Direction frameDirection() {
        if (this.frameDirection == null) {
            return this.getFrameDirection();
        }
        return this.frameDirection;
    }

    public boolean frameRotated() {
        return this.frameRotated;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        Direction frameDirection = this.getFrameDirection();
        return frameDirection == null ? new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)) : this.getTeleporterBoundingBox(frameDirection);
    }

    private AxisAlignedBB getTeleporterBoundingBox(@Nonnull Direction frameDirection) {
        switch (frameDirection) {
            case UP: {
                return new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177982_a(1, 3, 1));
            }
            case DOWN: {
                return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, -2, 1));
            }
            case EAST: {
                return new AxisAlignedBB(this.field_174879_c.func_177974_f(), this.field_174879_c.func_177982_a(3, 1, 1));
            }
            case WEST: {
                return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(-2, 1, 1));
            }
            case NORTH: {
                return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, -2));
            }
            case SOUTH: {
                return new AxisAlignedBB(this.field_174879_c.func_177968_d(), this.field_174879_c.func_177982_a(1, 1, 3));
            }
        }
        throw new IllegalArgumentException("Invalid frame direction");
    }

    public TileComponentChunkLoader<TileEntityTeleporter> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        return Collections.singleton(new ChunkPos(this.func_174877_v()));
    }

    @Override
    public int getRedstoneLevel() {
        return this.shouldRender ? 15 : 0;
    }

    @Override
    public int getCurrentRedstoneLevel() {
        return this.getRedstoneLevel();
    }

    public MachineEnergyContainer<TileEntityTeleporter> getEnergyContainer() {
        return this.energyContainer;
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableByte.create(() -> this.status, value -> {
            this.status = value;
        }));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74757_a("rendering", this.shouldRender);
        if (this.color != null) {
            updateTag.func_74768_a("color", this.color.ordinal());
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setBooleanIfPresent(tag, "rendering", value -> {
            this.shouldRender = value;
        });
        this.color = tag.func_150297_b("color", 3) ? EnumColor.byIndexStatic(tag.func_74762_e("color")) : null;
    }

    @ComputerMethod
    private Collection<TeleporterFrequency> getFrequencies() {
        return FrequencyType.TELEPORTER.getManagerWrapper().getPublicManager().getFrequencies();
    }

    @ComputerMethod
    private boolean hasFrequency() {
        TeleporterFrequency frequency = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        return frequency != null && frequency.isValid();
    }

    @ComputerMethod
    private TeleporterFrequency getFrequency() throws ComputerException {
        TeleporterFrequency frequency = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        if (frequency == null || !frequency.isValid()) {
            throw new ComputerException("No frequency is currently selected.");
        }
        return frequency;
    }

    @ComputerMethod
    private void setFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = FrequencyType.TELEPORTER.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency == null) {
            throw new ComputerException("No public teleporter frequency with name '%s' found.", name);
        }
        this.setFrequency(FrequencyType.TELEPORTER, frequency.getIdentity(), this.getOwnerUUID());
    }

    @ComputerMethod
    private void createFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = FrequencyType.TELEPORTER.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency != null) {
            throw new ComputerException("Unable to create public teleporter frequency with name '%s' as one already exists.", name);
        }
        this.setFrequency(FrequencyType.TELEPORTER, new Frequency.FrequencyIdentity(name, true), this.getOwnerUUID());
    }

    @ComputerMethod
    private EnumColor getFrequencyColor() throws ComputerException {
        return this.getFrequency().getColor();
    }

    @ComputerMethod
    private void setFrequencyColor(EnumColor color) throws ComputerException {
        this.validateSecurityIsPublic();
        this.getFrequency().setColor(color);
    }

    @ComputerMethod
    private void incrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = this.getFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getNext());
    }

    @ComputerMethod
    private void decrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = this.getFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getPrevious());
    }

    @ComputerMethod
    private Set<Coord4D> getActiveTeleporters() throws ComputerException {
        return this.getFrequency().getActiveCoords();
    }

    @ComputerMethod
    private String getStatus() {
        if (this.hasFrequency()) {
            switch (this.status) {
                case 1: {
                    return "ready";
                }
                case 2: {
                    return "no frame";
                }
                case 4: {
                    return "needs energy";
                }
            }
            return "no link";
        }
        return "no frequency";
    }
}

