/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.AbstractInputRecipeCache;
import mekanism.common.recipe.lookup.cache.type.ChemicalInputCache;
import mekanism.common.util.EnumUtils;
import net.minecraft.world.World;

public class ChemicalCrystallizerInputRecipeCache
extends AbstractInputRecipeCache<ChemicalCrystallizerRecipe> {
    private final Map<ChemicalType, ChemicalInputCache<?, ?, ChemicalCrystallizerRecipe>> typeBasedCache = new EnumMap(ChemicalType.class);
    private final Map<ChemicalType, Set<ChemicalCrystallizerRecipe>> typeBasedComplexRecipes = new EnumMap<ChemicalType, Set<ChemicalCrystallizerRecipe>>(ChemicalType.class);

    public ChemicalCrystallizerInputRecipeCache(MekanismRecipeType<ChemicalCrystallizerRecipe, ?> recipeType) {
        super(recipeType);
        for (ChemicalType chemicalType : EnumUtils.CHEMICAL_TYPES) {
            this.typeBasedCache.put(chemicalType, new ChemicalInputCache());
            this.typeBasedComplexRecipes.put(chemicalType, new HashSet());
        }
    }

    @Override
    public void clear() {
        super.clear();
        for (ChemicalType chemicalType : EnumUtils.CHEMICAL_TYPES) {
            this.typeBasedCache.get((Object)chemicalType).clear();
            this.typeBasedComplexRecipes.get((Object)chemicalType).clear();
        }
    }

    public boolean containsInput(@Nullable World world, BoxedChemicalStack input) {
        if (input.isEmpty()) {
            return false;
        }
        this.initCacheIfNeeded(world);
        ChemicalType type = input.getChemicalType();
        return this.containsInput(type, input.getChemicalStack()) || this.typeBasedComplexRecipes.get((Object)type).stream().anyMatch(recipe -> recipe.testType(input));
    }

    public <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean containsInput(@Nullable World world, CHEMICAL input) {
        if (input.isEmptyType()) {
            return false;
        }
        this.initCacheIfNeeded(world);
        ChemicalType type = ChemicalType.getTypeFor(input);
        ChemicalStack stack = input.getStack(1L);
        return this.containsInput(type, stack) || this.typeBasedComplexRecipes.get((Object)type).stream().anyMatch(recipe -> recipe.testType(stack));
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean containsInput(ChemicalType type, STACK stack) {
        return this.typeBasedCache.get((Object)type).contains(stack);
    }

    @Nullable
    public ChemicalCrystallizerRecipe findFirstRecipe(@Nullable World world, BoxedChemicalStack input) {
        if (input.isEmpty()) {
            return null;
        }
        this.initCacheIfNeeded(world);
        return this.findFirstRecipe(input.getChemicalType(), input.getChemicalStack());
    }

    @Nullable
    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> ChemicalCrystallizerRecipe findFirstRecipe(ChemicalType type, STACK stack) {
        Predicate<ChemicalCrystallizerRecipe> matchPredicate = recipe -> recipe.getInput().test(stack);
        ChemicalInputCache<?, ?, ChemicalCrystallizerRecipe> cache = this.typeBasedCache.get((Object)type);
        ChemicalCrystallizerRecipe recipe2 = cache.findFirstRecipe(stack, matchPredicate);
        return recipe2 == null ? this.findFirstRecipe((Collection)this.typeBasedComplexRecipes.get((Object)type), matchPredicate) : recipe2;
    }

    @Override
    protected void initCache(List<ChemicalCrystallizerRecipe> recipes) {
        for (ChemicalCrystallizerRecipe recipe : recipes) {
            IChemicalStackIngredient<?, ?> ingredient;
            ChemicalType type;
            if (!this.mapInputs(recipe, type = ChemicalType.getTypeFor(ingredient = recipe.getInput()), ingredient)) continue;
            this.typeBasedComplexRecipes.get((Object)type).add(recipe);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>> boolean mapInputs(ChemicalCrystallizerRecipe recipe, ChemicalType type, INGREDIENT ingredient) {
        return this.typeBasedCache.get((Object)type).mapInputs(recipe, ingredient);
    }
}

