/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class Meltdown {
    private static final int DURATION = 100;
    private final BlockPos minPos;
    private final BlockPos maxPos;
    private final double magnitude;
    private final double chance;
    private final UUID multiblockID;
    private int ticksExisted;

    public Meltdown(BlockPos minPos, BlockPos maxPos, double magnitude, double chance, UUID multiblockID) {
        this(minPos, maxPos, magnitude, chance, multiblockID, 0);
    }

    private Meltdown(BlockPos minPos, BlockPos maxPos, double magnitude, double chance, UUID multiblockID, int ticksExisted) {
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.magnitude = magnitude;
        this.chance = chance;
        this.multiblockID = multiblockID;
        this.ticksExisted = ticksExisted;
    }

    public static Meltdown load(CompoundNBT tag) {
        return new Meltdown(NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("min")), NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("max")), tag.func_74769_h("magnitude"), tag.func_74769_h("chance"), tag.func_186857_a("inventoryID"), tag.func_74762_e("age"));
    }

    public void write(CompoundNBT tag) {
        tag.func_218657_a("min", (INBT)NBTUtil.func_186859_a((BlockPos)this.minPos));
        tag.func_218657_a("max", (INBT)NBTUtil.func_186859_a((BlockPos)this.maxPos));
        tag.func_74780_a("magnitude", this.magnitude);
        tag.func_74780_a("chance", this.chance);
        tag.func_186854_a("inventoryID", this.multiblockID);
        tag.func_74768_a("age", this.ticksExisted);
    }

    public boolean update(World world) {
        ++this.ticksExisted;
        if (world.field_73012_v.nextInt() % 10 == 0 && world.field_73012_v.nextDouble() < this.magnitude * this.chance) {
            int x = MathHelper.func_76136_a((Random)world.field_73012_v, (int)this.minPos.func_177958_n(), (int)this.maxPos.func_177958_n());
            int y = MathHelper.func_76136_a((Random)world.field_73012_v, (int)this.minPos.func_177956_o(), (int)this.maxPos.func_177956_o());
            int z = MathHelper.func_76136_a((Random)world.field_73012_v, (int)this.minPos.func_177952_p(), (int)this.maxPos.func_177952_p());
            this.createExplosion(world, x, y, z, 8.0f, true, Explosion.Mode.DESTROY);
        }
        if (!WorldUtils.isBlockLoaded((IBlockReader)world, this.minPos) || !WorldUtils.isBlockLoaded((IBlockReader)world, this.maxPos)) {
            return true;
        }
        return this.ticksExisted >= 100;
    }

    private void createExplosion(World world, double x, double y, double z, float radius, boolean causesFire, Explosion.Mode mode) {
        MeltdownExplosion explosion = new MeltdownExplosion(world, x, y, z, radius, causesFire, mode, this.multiblockID);
        ArrayList<BlockPos> toBlow = new ArrayList<BlockPos>();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (double)j / 7.5 - 1.0;
                    double d1 = (double)k / 7.5 - 1.0;
                    double d2 = (double)l / 7.5 - 1.0;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = x;
                    double d6 = y;
                    double d8 = z;
                    for (float f = radius * (0.7f + world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos pos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = world.func_180495_p(pos);
                        FluidState fluidstate = blockstate.func_204520_s();
                        if (!blockstate.isAir((IBlockReader)world, pos) || !fluidstate.func_206888_e()) {
                            f -= (Math.max(blockstate.getExplosionResistance((IBlockReader)world, pos, (Explosion)explosion), fluidstate.getExplosionResistance((IBlockReader)world, pos, (Explosion)explosion)) + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (double)this.minPos.func_177958_n() <= d4 && (double)this.minPos.func_177956_o() <= d6 && (double)this.minPos.func_177952_p() <= d8 && d4 <= (double)this.maxPos.func_177958_n() && d6 <= (double)this.maxPos.func_177956_o() && d8 <= (double)this.maxPos.func_177952_p()) {
                            toBlow.add(pos);
                        }
                        d4 += d0 * 0.3;
                        d6 += d1 * 0.3;
                        d8 += d2 * 0.3;
                    }
                }
            }
        }
        if (!ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
        Collections.shuffle(toBlow, world.field_73012_v);
        ArrayList drops = new ArrayList();
        for (BlockPos toExplode : toBlow) {
            BlockState state = world.func_180495_p(toExplode);
            if (state.isAir((IBlockReader)world, toExplode)) continue;
            if (state.canDropFromExplosion((IBlockReader)world, toExplode, (Explosion)explosion) && world instanceof ServerWorld) {
                TileEntity tileentity = state.hasTileEntity() ? world.func_175625_s(toExplode) : null;
                LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)toExplode)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, null);
                if (mode == Explosion.Mode.DESTROY) {
                    lootContextBuilder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(radius));
                }
                state.func_215693_a(lootContextBuilder).forEach(stack -> Meltdown.addBlockDrops(drops, stack, toExplode));
            }
            state.onBlockExploded(world, toExplode, (Explosion)explosion);
        }
        for (Pair pair : drops) {
            Block.func_180635_a((World)world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private static void addBlockDrops(List<Pair<ItemStack, BlockPos>> dropPositions, ItemStack stack, BlockPos pos) {
        int size = dropPositions.size();
        for (int i = 0; i < size; ++i) {
            Pair<ItemStack, BlockPos> pair = dropPositions.get(i);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            dropPositions.set(i, (Pair<ItemStack, BlockPos>)Pair.of((Object)itemstack1, (Object)pair.getSecond()));
            if (!stack.func_190926_b()) continue;
            return;
        }
        dropPositions.add((Pair<ItemStack, BlockPos>)Pair.of((Object)stack, (Object)pos));
    }

    public static class MeltdownExplosion
    extends Explosion {
        private final UUID multiblockID;

        private MeltdownExplosion(World world, double x, double y, double z, float radius, boolean causesFire, Explosion.Mode mode, UUID multiblockID) {
            super(world, null, null, null, x, y, z, radius, causesFire, mode);
            this.multiblockID = multiblockID;
        }

        public UUID getMultiblockID() {
            return this.multiblockID;
        }
    }
}

