/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityMode;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SecurityInventorySlot
extends BasicInventorySlot {
    private static final Predicate<@NonNull ItemStack> validator = stack -> stack.func_77973_b() instanceof IOwnerItem;

    public static SecurityInventorySlot unlock(Supplier<UUID> ownerSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(ownerSupplier, "Owner supplier cannot be null");
        return new SecurityInventorySlot(stack -> ((IOwnerItem)stack.func_77973_b()).getOwnerUUID((ItemStack)stack) == null, stack -> {
            UUID ownerUUID = ((IOwnerItem)stack.func_77973_b()).getOwnerUUID((ItemStack)stack);
            return ownerUUID != null && ownerUUID.equals(ownerSupplier.get());
        }, listener, x, y);
    }

    public static SecurityInventorySlot lock(@Nullable IContentsListener listener, int x, int y) {
        return new SecurityInventorySlot(stack -> ((IOwnerItem)stack.func_77973_b()).getOwnerUUID((ItemStack)stack) != null, stack -> ((IOwnerItem)stack.func_77973_b()).getOwnerUUID((ItemStack)stack) == null, listener, x, y);
    }

    private SecurityInventorySlot(Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
    }

    public void unlock(UUID ownerUUID) {
        IOwnerItem item;
        UUID stackOwner;
        if (!this.isEmpty() && this.current.func_77973_b() instanceof IOwnerItem && (stackOwner = (item = (IOwnerItem)this.current.func_77973_b()).getOwnerUUID(this.current)) != null && stackOwner.equals(ownerUUID)) {
            item.setOwnerUUID(this.current, null);
            if (item instanceof ISecurityItem) {
                ((ISecurityItem)item).setSecurity(this.current, SecurityMode.PUBLIC);
            }
        }
    }

    public void lock(UUID ownerUUID, SecurityFrequency frequency) {
        if (!this.isEmpty() && this.current.func_77973_b() instanceof IOwnerItem) {
            IOwnerItem item = (IOwnerItem)this.current.func_77973_b();
            UUID stackOwner = item.getOwnerUUID(this.current);
            if (stackOwner == null) {
                stackOwner = ownerUUID;
                item.setOwnerUUID(this.current, stackOwner);
            }
            if (stackOwner.equals(ownerUUID) && item instanceof ISecurityItem) {
                ((ISecurityItem)item).setSecurity(this.current, frequency.getSecurityMode());
            }
        }
    }
}

