/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.IntPropertyData;

public class SyncableEnum<ENUM extends Enum<ENUM>>
implements ISyncableData {
    private final Int2ObjectFunction<ENUM> decoder;
    private final Supplier<@NonNull ENUM> getter;
    private final Consumer<@NonNull ENUM> setter;
    @Nonnull
    private ENUM lastKnownValue;

    public static <ENUM extends Enum<ENUM>> SyncableEnum<ENUM> create(Int2ObjectFunction<ENUM> decoder, @Nonnull ENUM defaultValue, Supplier<@NonNull ENUM> getter, Consumer<@NonNull ENUM> setter) {
        return new SyncableEnum<ENUM>(decoder, defaultValue, getter, setter);
    }

    private SyncableEnum(Int2ObjectFunction<ENUM> decoder, @Nonnull ENUM defaultValue, Supplier<@NonNull ENUM> getter, Consumer<@NonNull ENUM> setter) {
        this.decoder = decoder;
        this.lastKnownValue = defaultValue;
        this.getter = getter;
        this.setter = setter;
    }

    @Nonnull
    public ENUM get() {
        return (ENUM)((Enum)this.getter.get());
    }

    public void set(int ordinal) {
        this.set((Enum)this.decoder.apply(ordinal));
    }

    public void set(@Nonnull ENUM value) {
        this.setter.accept(value);
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        ENUM oldValue = this.get();
        boolean dirty = oldValue != this.lastKnownValue;
        this.lastKnownValue = oldValue;
        return ISyncableData.DirtyType.get(dirty);
    }

    @Override
    public IntPropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        return new IntPropertyData(property, ((Enum)this.get()).ordinal());
    }
}

