/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.JSONConverter;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCIngredientList;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerItem;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=ItemStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ItemStackIngredient")
public class CrTItemStackIngredient {
    private CrTItemStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(IItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be created from an empty stack.");
        }
        return CrTItemStackIngredient.from((IIngredient)stack, stack.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(Item item) {
        return CrTItemStackIngredient.from(item, 1);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(Item item, int amount) {
        CrTIngredientHelper.assertValidAmount("ItemStackIngredients", amount);
        return ItemStackIngredient.from((IItemProvider)item, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(MCTag<Item> itemTag, int amount) {
        ITag tag = CrTIngredientHelper.assertValidAndGet(itemTag, amount, arg_0 -> ((TagManagerItem)TagManagerItem.INSTANCE).getInternal(arg_0), "ItemStackIngredients");
        return ItemStackIngredient.from(tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(MCTag<Item> itemTag) {
        return CrTItemStackIngredient.from(itemTag, 1);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(MCTagWithAmount<Item> itemTag) {
        return CrTItemStackIngredient.from((MCTag<Item>)itemTag.getTag(), itemTag.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(IIngredient ingredient) {
        return CrTItemStackIngredient.from(ingredient, 1);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(IIngredientWithAmount ingredient) {
        return CrTItemStackIngredient.from(ingredient.getIngredient(), ingredient.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(IIngredient ingredient, int amount) {
        CrTIngredientHelper.assertValidAmount("ItemStackIngredients", amount);
        Ingredient vanillaIngredient = ingredient.asVanillaIngredient();
        if (vanillaIngredient == Ingredient.field_193370_a) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be made using the empty ingredient: " + amount);
        }
        return ItemStackIngredient.from(vanillaIngredient, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(MCIngredientList ingredientList) {
        IIngredient[] ingredients = ingredientList.getIngredients();
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be created from an empty ingredient list!");
        }
        ArrayList<ItemStackIngredient> itemStackIngredients = new ArrayList<ItemStackIngredient>();
        CrTItemStackIngredient.addIngredients(itemStackIngredients, ingredients);
        return CrTItemStackIngredient.createMulti(itemStackIngredients.toArray(new ItemStackIngredient[0]));
    }

    private static void addIngredients(List<ItemStackIngredient> itemStackIngredients, IIngredient[] ingredients) {
        for (IIngredient ingredient : ingredients) {
            if (ingredient instanceof IItemStack) {
                itemStackIngredients.add(CrTItemStackIngredient.from((IItemStack)ingredient));
                continue;
            }
            if (ingredient instanceof MCIngredientList) {
                CrTItemStackIngredient.addIngredients(itemStackIngredients, ((MCIngredientList)ingredient).getIngredients());
                continue;
            }
            itemStackIngredients.add(CrTItemStackIngredient.from(ingredient));
        }
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient createMulti(ItemStackIngredient ... ingredients) {
        return (ItemStackIngredient)CrTIngredientHelper.createMulti((String)"ItemStackIngredients", ItemStackIngredient::createMulti, (InputIngredient[])ingredients);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(ItemStackIngredient _this) {
        return JSONConverter.convert((JsonElement)_this.serialize());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static ItemStackIngredient or(ItemStackIngredient _this, ItemStackIngredient other) {
        return ItemStackIngredient.createMulti(_this, other);
    }
}

