/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker;

import com.blamejared.crafttweaker.impl.tag.MCTag;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class CrTUtils {
    public static ResourceLocation rl(String path) {
        return new ResourceLocation("crafttweaker", path);
    }

    public static ICrTChemicalStack.ICrTGasStack stackFromGas(Gas gas) {
        return new CrTChemicalStack.CrTGasStack(gas.getStack(1L));
    }

    public static ICrTChemicalStack.ICrTInfusionStack stackFromInfuseType(InfuseType infuseType) {
        return new CrTChemicalStack.CrTInfusionStack(infuseType.getStack(1L));
    }

    public static ICrTChemicalStack.ICrTPigmentStack stackFromPigment(Pigment pigment) {
        return new CrTChemicalStack.CrTPigmentStack(pigment.getStack(1L));
    }

    public static ICrTChemicalStack.ICrTSlurryStack stackFromSlurry(Slurry slurry) {
        return new CrTChemicalStack.CrTSlurryStack(slurry.getStack(1L));
    }

    @Nullable
    public static ICrTChemicalStack<?, ?, ?> fromBoxedStack(BoxedChemicalStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        switch (stack.getChemicalType()) {
            case GAS: {
                return new CrTChemicalStack.CrTGasStack((GasStack)stack.getChemicalStack());
            }
            case INFUSION: {
                return new CrTChemicalStack.CrTInfusionStack((InfusionStack)stack.getChemicalStack());
            }
            case PIGMENT: {
                return new CrTChemicalStack.CrTPigmentStack((PigmentStack)stack.getChemicalStack());
            }
            case SLURRY: {
                return new CrTChemicalStack.CrTSlurryStack((SlurryStack)stack.getChemicalStack());
            }
        }
        return null;
    }

    public static <TYPE> String describeOutputs(List<TYPE> outputs, Function<TYPE, Object> converter) {
        int size = outputs.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return converter.apply(outputs.get(0)).toString();
        }
        StringBuilder description = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                description.append(", or ");
            }
            description.append(converter.apply(outputs.get(i)));
        }
        return description.toString();
    }

    public static <TYPE, CRT_TYPE> ITag<TYPE> validateTagAndGet(MCTag<CRT_TYPE> crtTag, Function<MCTag<CRT_TYPE>, ITag<TYPE>> getter) {
        ITag<TYPE> tag = getter.apply(crtTag);
        if (tag == null) {
            throw new IllegalArgumentException("Tag " + crtTag.getCommandString() + " does not exist.");
        }
        return tag;
    }
}

